//-----------------------------------------------------------------------------
//
//  BT848.cc
//
//  Definition of BT848 class member functions.
//
// 	Initialisation routines shamelessly stolen from 'vu4'
//	(Copyright (C) 1996  Jim Bray)
//
//  7.1.1997
//  Jouni Aro <jaro@iki.fi>
//
//-----------------------------------------------------------------------------

#include <site_config.h>
#ifdef USE_BT848

extern "C" {
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <sys/signal.h>
#include <sys/ioctl.h>
#include "bttv.h"
}
#include <errno.h>
#include <stdio.h>
#include <unistd.h>

extern int errno;
#include <sys/signal.h>
#include <stdlib.h>
#include "Video.hh"
#include "Acquire.hh"
#include "BT848.hh"



static void gotframe(int);

// In order to get the writer to work right we'll hardcode two sets
// of global variables; who'd want more?

typedef struct {
} BT848info;

static BT848info BT848s[2];

void BT848::error_exit(char *mess) {
  if (mess != NULL) 
    cerr << "BT848: " << mess << endl;
  else
    cerr << "Some problem with the BT848 setup" << endl;
  if (errno)
    perror("ioctl");
  exit(1);
}

void
BT848::grabber()
{
  
  int locked[3] = {0,0,0};
  int last;

  if (-1 == ioctl(fd,VIDIOCMCAPTURE,&(gb))) {
    if (errno == EAGAIN)
      fprintf(stderr,"grabber chip can't sync (no station tuned in?)\n");
    else
      perror("ioctl VIDIOCMCAPTURE");
    exit(1);
  }

  last = 0;
  count++;

  /* main loop */
  while (1) {

    //    cout << "Grabbing " << count << endl;
    gb.frame = count %3;
    if (-1 == ioctl(fd,VIDIOCMCAPTURE,&(gb))) {
      if (errno == EAGAIN)
	fprintf(stderr,"grabber chip can't sync (no station tuned in?)\n");
      else
	perror("ioctl VIDIOCMCAPTURE");
      exit(1);
    }

    //    cout << "Syncing on " << last << endl;
    if (-1 == ioctl(fd,VIDIOCSYNC,&last)) {
      perror("ioctl VIDIOCSYNC");
      exit(1);
    }
    last = gb.frame;
    count++;
  }

}


BT848::BT848(int nbytes, int cols, int rows, char *input_dev) 
  : ColorVideo(nbytes,cols,rows) 
{
  int i;
  int format;


  /* open */
  if (-1 == (fd = open(input_dev,O_RDWR))) {
    fprintf(stderr,"open %s: %s\n",input_dev,strerror(errno));
    return;
  }

  /* get settings */
  if (-1 == ioctl(fd,VIDIOCGCAP,&capability)) {
    perror("ioctl VIDIOCGCAP");
    return;
  }

  /* Tell us about this device */
  printf("%s %x %dx%d to %dx%d\n",
	 capability.name,
	 capability.type,
	 capability.minwidth,	   capability.minheight,
	 capability.maxwidth,	   capability.maxheight);


  /* Figure out the channels */
  channels = new video_channel[capability.channels];
  memset(channels,0,sizeof(struct video_channel)*capability.channels);

  for (i = 0; i < capability.channels; i++) {
    channels[i].channel = i;
    if (-1 == ioctl(fd,VIDIOCGCHAN,&channels[i])) {
      perror("ioctl VIDIOCGCHAN"); return;}
  }

  // Signal format and channel

  grab_input(2,DEFAULT_FORMAT);

  // Memory map the device

  mmap();

  // directly access the frame buffer array data in dataPtr

   _is_mappable = 1;

   // Start capture by spawning another process

   start();

}

int
BT848::grab_input(int input, int norm)
{

  if ((input < 0) || (input >= capability.channels)){
    perror("Input out of range");
    return 0;
  }

  channels[input].norm=norm;
    if (-1 == ioctl(fd, VIDIOCSCHAN, &channels[input]))
	perror("ioctl VIDIOCSCHAN");
    return 0;
}




void BT848::close()
{
  int s;
  
  stop();
  printf("BT848::close");
  ::close(fd); 
}

// Right now this won't work because of the logic of the child...

int BT848::start()
{

  switch(child = fork()) {
    case -1:
      cerr << "fork" << endl;
      return 0;
    case 0:
      grabber();
      exit(1);
      break;
  }

  return 1;

}


int BT848::stop()
{
  int s;

  // stop continuous frame capture
  
  kill(child,SIGINT);
  wait(&s);
  return 1;
}

int BT848::mmap()
{

  struct video_mbuf        gb_buffers = { 3*BTTV_MAX_FBUF, 3, {0,BTTV_MAX_FBUF,2*BTTV_MAX_FBUF }};

  dataPtr = ::mmap(0,gb_buffers.size,PROT_READ|PROT_WRITE,MAP_SHARED,fd,0);
  if ((unsigned char*)-1 == map) {
    perror("mmap");
    return 0;
  } else {
    fprintf(stderr,"v4l: mmap()'ed buffer size = 0x%x\n",
	    gb_buffers.size);
  }

  // Set the buffers and geometry

   // Set up the acquisition info


  gb.frame  = 0;
  gb.width  = width();
  gb.height = height();

  switch(bytesperpixel())
    {
    case 1:
      input_type = PIX_LUMINANCE;
      output_type = PIX_LUMINANCE;
      gb.format =  VIDEO_PALETTE_GREY;
      printf("Out format set to Y8\n");
      break;
    case 2:
      gb.format =  VIDEO_PALETTE_RGB565;
      printf("Out format set to RGB565\n");
      break;
    case 4:
      gb.format =  VIDEO_PALETTE_RGB32;
      printf("Out format set to RGB32\n");
      break;

    default:
      fprintf(stderr,
	      "only 1, 2 or 4 bytes per pixels allowed, you tried %d\n", 
	      bytesperpixel());
      exit(1);
    }

  return 1;
} 

int BT848::resize(int cols, int rows)
{
  if ( (cols > MAXCOLS) || (rows > MAXROWS) )
    {
      return 0;
    }
  set_size( cols, rows );
  mmap();
  return 1;
}

#if 0
int BT848::grab_aligned (int *image, float &x, float  &y,
 			 int width, int height,
			 int sampw, int samph, short int mask) 
{
  
  int i,j;
  int fx,fy;
  int rskip;
  register unsigned char *ldata, *endldata, *finalldata;

  if (!pre_grab())
    {
      return 0;
    }

  if (!(in_view(x,y,width*sampw,height*samph)))
    {
      return 0;
    }



  if (_bytesperpixel == 1)
    {
      _bytesperpixel = 2;
      short int yuvmask = 0Xff;
 
      fx = adjust_to_first_coord(x,width*sampw);
      fy = adjust_to_first_coord(y,height*samph);
  
      width *=sampw;
      rskip  = samph*ncols;
  
      ldata = (unsigned short *)dataPtr + fy*ncols+fx;
      finalldata = ldata + rskip*height;//(height-1) + width;
      rskip -= width;
      i=0;
      for(;ldata<finalldata;ldata += rskip) {
	for(endldata = ldata+width;ldata< endldata;ldata+=sampw)
	  {
	    *image++ = *ldata & yuvmask;
	    i++;
	  }
      }	
      _bytesperpixel = 1;
    }
  else
    {
    }
}

#endif



#endif // USE_BT848
