/*                                                                -*-c++-*-
    Copyright (C) 1993-1997 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//--------------------------------------------------------------------------
//
// Acquire.template.hh
//
// Heavily optimized code to acquire oriented lines and windows of pixels.
//
// 11/19/93 Gregory D. Hager
//
// 8 July 98 Alastair D. Reid
//   For every function which took an angle, I added a function which
//   took dx, dy and a quadrant number so that it's easy to grab
//   an exact number of pixels if you want.
//
// By convention, the width axis of a rectangle is also the orientation
// of the rectangle.  E.g., a rectangle at 0 has the width axis aligned
// with the x axis, and the height axis aligned with the y axis.  Rotation
// refers to the angle of the rectangle with respect to the standard
// framebuffer coordinate system.
// Windows that have an even length or width are skewed on pixel toward the
// "negative" side of the window.
//--------------------------------------------------------------------------

//----------------------------------------------------------------
// Acquire a rectangle with sampling specified in both height and width.
//----------------------------------------------------------------

template <class DATATYPE>
extern void 
UNIQNAM(rectangle_ms)(DATATYPE *mem_map, int *image, int cx, int cy, float angle, 
		  int height, int width, int samph,int sampw, short int mask,
		  int ncols);

template <class DATATYPE>
inline void
UNIQNAM(rectangle_ms)(DATATYPE * mem_map, int *image, 
		      int cx, int cy, 
		      short int dx, short int dy,
		      short int quadrant,
		      int height, int width, 
		      int samph,int sampw, short int mask, int ncols);

//----------------------------------------------------------------
// Acquire a rectangle with sampling specified in width.
//----------------------------------------------------------------

template <class DATATYPE>
extern void
UNIQNAM(rectangle_msw)(DATATYPE *mem_map, int *image, int cx, int cy, float angle, 
		   int height, int width, int sampw, short int mask,
		   int ncols);

template <class DATATYPE>
inline void
UNIQNAM(rectangle_msw)(DATATYPE * mem_map, int *image, 
		       int cx, int cy, 
		       short int dx, short int dy,
		       short int quadrant,
		       int height, int width, 
		       int sampw, short int mask, int ncols);

//----------------------------------------------------------------
// Acquire a rectangle with sampling specified in height.
//----------------------------------------------------------------

template <class DATATYPE>
extern void
UNIQNAM(rectangle_msh)(DATATYPE *mem_map, int *image, int cx, int cy, float angle, 
		   int height, int width, int samph,  short int mask,
		   int ncols);

template <class DATATYPE>
inline void
UNIQNAM(rectangle_msh)(DATATYPE * mem_map, int *image, 
		       int cx, int cy,
		       short int dx, short int dy,
		       short int quadrant,
		       int height, int width, 
		       int samph, short int mask, int ncols);

//----------------------------------------------------------------
// Acquire a rectangle with full resolution rectangle
//----------------------------------------------------------------

template <class DATATYPE>
extern void
UNIQNAM(rectangle)(DATATYPE *mem_map, int *image, int cx, int cy, float angle, 
	       int height, int width, short int mask,
	       int ncols);

template <class DATATYPE>
inline void
UNIQNAM(rectangle)(DATATYPE * mem_map, int *image,
                   int cx, int cy, 
                   short int dx, short int dy,
		   short int quadrant,
		   int height, int width, 
		   short int mask, int ncols);

//----------------------------------------------------------------
// Acquire a line of data.
//----------------------------------------------------------------

template <class DATATYPE>
extern void
UNIQNAM(line)(DATATYPE *mem_map,  int *image, int cx, int cy, float angle, 
	  int length, short int mask, int ncols);

template <class DATATYPE>
void
UNIQNAM(line)(DATATYPE * mem_map, int *image, int cx, int cy, 
	      short int dx, short int dy, short int quadrant,
	      int length, short int mask, int ncols);

//----------------------------------------------------------------
// End
//----------------------------------------------------------------
