/*                                                                -*-c++-*-
    Copyright (C) 1993-1997 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//--------------------------------------------------------------------------
//
// Acquire.hh
//
// 11/19/93 Gregory D. Hager
//
// This is NOT a class, but a set of isolated functions.
//
// Heavily optimized code to acquire oriented lines and windows of pixels.
//
// By convention, the width axis of a rectangle is also the orientation
// of the rectangle.  E.g., a rectangle at 0 has the width axis aligned
// with the x axis, and the height axis aligned with the y axis.  Rotation
// refers to the angle of the rectangle with respect to the standard
// framebuffer coordinate system.
//
// The macros UNIQNAM and PIXEL can be redefined to create
// different instantiations of the top-level routines which use
// memory models other than linear memory.  See Devices.cc for
// examples of how to do this.
//
//-------------------------------------------------------------------------

#include <sys/types.h>

#ifndef ACQUIRE_H
#define ACQUIRE_H

#ifndef UNIQNAM
#define UNIQNAM(base) bham_##base
#endif

/* This is the default view of frame memory */

#ifndef PIXEL
#define PIXEL(mem,loc,mask) ((int)(mem[loc] & mask))
#endif

#include "Acquire.template.hh"

#endif
