/*                                                                -*-c++-*-
    Copyright (C) 1991-1997 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//--------------------------------------------------------------------------
//
// Acquire.cc
//
// 11/19/93 Gregory D. Hager
//
// This NOT a class!
// Heavily optimized code to acquire oriented lines and windows of pixels
//
// By convention, the width axis of a rectangle is also the orientation
// of the rectangle.  E.g., a rectangle at 0 has the width axis aligned
// with the x axis, and the height axis aligned with the y axis.  Rotation
// refers to the angle of the rectangle with respect to the standard
// framebuffer coordinate system.
// Windows that have an even length or width are skewed on pixel toward the
// "negative" side of the window.
//
//-------------------------------------------------------------------------


#include <math.h>
#include <stdlib.h>
#include "Acquire.hh"

#define NCOLS ncols
#define TOCOLS *=ncols
#define TOCOLSNA *ncols

// These are implementations of Bresenhams line drawing algorithms
// that fill an array of indices.

inline 
void 
bham_array_pos(register int *ys, short int dx, short int dy, 
	       short int mid)
{
  short int i,y=0;
  register short int err = (dy>>1) - (dx>>1);
  
  ys += mid;
  
  *ys = 0;
  for (i=1;i<=mid;i++) {
    err += dy;
    if (err > 0) {
      y++;
      err -= dx;
    }
    ys[-i] = - (ys[i] = y);
  }
}

inline 
void 
bham_array_neg(register int *ys, short int dx,short int dy, 
	       short int mid)
{
  short int i,y=0;
  register short int err = (dy>>1) - (dx>>1);
  
  ys += mid;
  
  *ys = 0;
  for (i=1;i<=mid;i++) {
    err += dy;
    if (err > 0) {
      y--;
      err -= dx;
    }
    ys[-i] = - (ys[i] = y);
  }
}


// The following two routines are implementations of Bresenhams 
// line-drawing algorithm modified to handle differing sampling rates
// in a proper fashion.  The two routines differ only in whether they
// increment or decrement y.

inline 
void 
bham_array_pos(register int *ys, short int dx,short int dy, 
	       short int mid, short int samp)
{
  short int crit = dx>>1;
  short int i,y=0;
  register short int err = dy>>1;
  
  dy*=samp;
  ys += mid;
  
  *ys = 0;
  for (i=1;i<=mid;i++) {
    err += dy;
    if (err > crit) {
      y+= err/dx;
      err %= dx;
    }
    ys[-i] = - (ys[i] = y);
  }
}

inline 
void 
bham_array_neg(register int *ys, short int dx,short int dy, 
	       short int mid, short int samp)
{
  short int crit = dx>>1;
  short int i,y=0;
  register short int err = dy>>1;
  
  dy *= samp;
  ys += mid;
  
  *ys = 0;
  for (i=1;i<=mid;i++) {
    err += dy;
    if (err > crit) {
      y  -= err/dx;
      err %= dx;
    }
    ys[-i] = - (ys[i] = y);
  }
}

/*lengths must be odd*/

// These are temporary array storage areas to avoid doing any memory
// allocation inside the routine itself.

static int ccols[2048];
static int crows[2048];

// This is the "default" view of the framememory

#include "Acquire.cc.template"
#undef PIXEL

