/*                                                                -*-c++-*-
    Copyright (C) 1994 Kentaro Toyama and Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    We provide this software "as is" without express or implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Contour.hh
//
//  Declaration of Contour object.  Contours are modeled on FeatureGroup
//     and CompFeature classes, except that they use Circlists instead of
//     Lists.
//
//  July 19, 1994
//  Kentaro Toyama
//  Sept. 5, 1994 -- updated for 0.95 release of tracking code.
//  Feb. 28, 1995 -- updated for 0.99 release of tracking code.
//  Nov. 7, 1995  -- updated for 1.02 release, adapted to Component class.
//
//-----------------------------------------------------------------------------

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include "Tracker.hh"
#include "Video.hh"
#include "Circlist.hh"
#include "Component.hh"

int const INCH = 5;                     // length to look ahead in init.
int const SEARCH_LINE_LEN = 10;
int const SEARCH_LINE_WID = 30;

int const contour_dft_comps = 30;
int const contour_max_comps = 50;

enum { SEARCH_WINDOWS,
       LINE_SEGS,
       CUBIC_SEGS };

//-----------------------------------------------------------------------------
//  Contour class declaration
//-----------------------------------------------------------------------------

class Contour : public BasicFeature {

  Circlist<BasicFeature *> features;
  Component **feature_array;

  int number;      // number of features in Contour;

  int compwidth;

  int show_type;
  
 protected:

  BasicFeature *child(int n) {
    int i; features.front(); 
    for (i=0; i<n; ++i,++features); 
    return *features; 
  }

 public:

  // Constructors and Destructors

  Contour (Video *v_in, 
	   int st_in = LINE_SEGS,
	   int compwidth_in = comp_dft_width);
  Contour (Contour &p);
  ~Contour();

  // Initialization options

  int array_init();
  int state_init(float *state_in) { return 1;};
  int interactive_init (CWindow &c);
  int interactive_init (CWindow &c, Video *v, 
			int width, int comps = contour_dft_comps);

  // BasicFeature required functions

  BasicFeature *dup() { return new Contour (*this); }

  int show (Color color_in = no_color);
  int clear ();

  void forward(int n=1);
  void replicate_forward();
  void back(int n=1);
  void erase_last();
    
  int show1();
  int clear1();
  int show2();
  int clear2();
  int show3();
  int clear3();

  int update();

  // interpolation/extrapolation/coord-combining functions
  //    many aren't actually defined or are commented out in Contour.cc

  coords spinterpolate_nocheck (int num,int tot);
  coords addcoords (coords cs, coords offset);
  coords addoffset (coords *a, int offset);
  coords addoffset (Component *a, coords offset);
  coords addoffset (coords *a, coords offset);

  Contour &operator+= (BasicFeature *t);
  Contour &operator+= (BasicFeature &t);

  int track() {
    replicate_forward();
    int res = update();
    erase_last();
    show();
    return res;
  }

};
