/*
    Copyright (C) 1995 Kentaro Toyama and Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    We provide this software "as is" without express or implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Component.cc
//
//  Member functions for Component object.
//
//  July 19, 1994
//  Kentaro Toyama
//  Sept. 5, 1994 -- updated for 0.95 release of tracking code.
//  Feb. 28, 1995 -- updated for 0.99 release of tracking code.
//  Nov.  6, 1995 -- updated for 1.02 release of tracking code.  Bugs fixed.
//
//-----------------------------------------------------------------------------
#include "Video.hh"
#include "Component.hh"
#include "Tracker.hh"
#include "Tools.hh"

//--------------------------------------------------------------------------;

Component::Component(Video *v, int width_in, int dp_in, int grow_in,
		     int os_in) :
BasicFeature(comp_statevars,v), Orientable(this), Positionable(this) {
  
  length = comp_dft_length;
  distraction_proof = dp_in;
  grow = grow_in;
  max_width = width_in;
  set_width(max_width);
  orig_samp = os_in;
  set_samp(os_in);

  pat = new Shortedge;
  im = new Image (max_width + pat->xpad (max_width, length),
		  length + pat->ypad (max_width, length));

  int wid_half = max_width/2;
  lowout.pk = new int[wid_half];
  lowout.pkstrength = new int[wid_half];
  lowout.regionmode = new int[wid_half];
  lowout.imval = new int[max_width];

  lastimval = new int[max_width];
  color = cyan_color;

  set_x(v->width());
  set_y(v->height());
  set_o(0.0);
  replicate_forward();
  set_x(v->width());
  set_y(v->height());
  set_o(0.0);

}

Component::Component (const Component &x) : 
BasicFeature(x), Orientable(this), Positionable(this) {

  length = x.length; 
  max_width = x.max_width; 
  orig_samp = x.orig_samp;
  pat = x.pat; 
  im = new Image (*(x.im));
 
  // copy pointers only ;
 
  lowout.pk = x.lowout.pk;
  lowout.pkstrength = x.lowout.pkstrength;
  lowout.regionmode = x.lowout.regionmode;
  lowout.imval = x.lowout.imval;

  lastimval = x.lastimval;

}

int Component::in_view(int x, int y, float o) {
  return ((x < v->width()-max_width) &&
	  (x > max_width) &&
	  (y < v->height()-max_width) &&
	  (y > max_width));
}

int Component::interactive_init (CWindow &w) {
  position pos = w.getpos (*source(), "Position edge",length);
  state_init (pos.x, pos.y, pos.angle);
  return 1;
}

int Component::sub_init (SE_out *s) {
//   last.state = cur.state = AABB;
//   last.certainty = cur.certainty = SURE;
//   last.numedges = cur.numedges = s->numpks;
//   last.direction = cur.direction = CENTER;
//   
//   last.bestpk = cur.bestpk = maxindex(s->pk,s->numpks);
//   last.inside = cur.inside = s->regionmode[cur.bestpk];
//   last.outside = cur.outside = s->regionmode[(cur.bestpk)+1];
//   last.bestguess = cur.bestguess = s->pk[cur.bestpk];
// 
  memcpy(lastimval,s->imval,sizeof(int)*width());
  return 1;
}

int Component::state_init (coords *co) {
  int retval;
  if ((retval = state_init(co->x,co->y,co->o)) != 0) {
//     look(&lowout);
//     sub_init(&lowout);
  }
  return retval;
}

int Component::state_init (float xx, float yy, float oo) {
  set_x(xx); set_y(yy); set_o(oo);
//   look (&lowout);
//   sub_init (&lowout);
  if (in_view(int(xx), int(yy), oo)) {
    return 1;                
  } else {
    return 0;
  }
}

void Component::clear_last() {erase_last();}

int Component::showwid (Color color_in, Color color_in2) {
  v->line (round(x()), round(y()), width(), orientation()+3.14159/2.0, 
          color_in,
          samp());
  v->line (round(x()), round(y()), length+2, orientation(), 
          color_in2,
          1);
  return 1;
}

int Component::clearwid () {
  v->line (round(x()), round(y()), width(), orientation()+3.14159/2.0, 0, 
          samp());
  v->line (round(x()), round(y()), length+2, orientation(), 0, 
          1);
  return 1;
}

statedata *Component::look (coords *co) {

  int i;

  v->grab (*im,round(co->x),round(co->y),
            -(co->o)-M_PI_2,round(samp()),1);

#ifdef COMPONENT_DEBUG
    source()->show(*im,40,20);
#endif  

  ((Shortedge *) pat)->getlowout_ct(im,&lowout);

  float mx=0.0;
  int idx = 0;

  switch (lowout.numpks) {
  case 0:
    cur.bestguess = width()/2;
  case 1:
    cur.bestguess = lowout.pk[0];
  default:
    for (i=0;i<lowout.numpks;i++) 
      if (lowout.pkstrength[i] > mx) {
	idx = i;
	mx = lowout.pkstrength[i];
      }
    cur.bestguess = lowout.pk[idx];
  }
  color = cyan_color;

  return &cur;
}


void Component::set (int offset) {
  float angle = o();
  double ss, cc;

  //sincos(angle,&ss,&cc); //sgi doesn't have sincos()
  ss=sin(angle); cc=cos(angle);

  float off = offset;       
  float wangle = -(angle)-M_PI_2;
  
  set_x( x() - signum (off*ss) * fabs(off * cos (wangle)) );
  if (x() <     0) set_x(0);
  if (x() > (source()->width())) set_x((source()->width()));
  
  set_y( y() + signum (off*cc) * fabs(off * sin (wangle)) );
  if (y() <     0) set_y(0);
  if (y() > (source()->height())) set_y((source()->height()));
  
}

void Component::set (coords *final) {	
 
  if (final->v     ) { 
    set_x(final->x);
    set_y(final->y);
    set_o(final->o);
  }
  if (x() < width()/2+5) set_x(width()/2.+5);
  if (x() > (source()->width())-width()/2-5) 
    set_x((source()->width())-width()/2.-5);
  if (y() < width()/2+5) set_y(width()/2.+5);
  if (y() > (source()->height())-width()/2-5) 
    set_y((source()->height())-width()/2.-5);
  
//   hist[hcount].x = round(x());
//   hist[hcount].y = round(y());
//   hist[hcount].o = o();
//   hist[hcount].v = TRUE;
//   hcount = (hcount+1)%HISTMAX;
}

//--------------------------------------------------------------------------;
