//                                                                 -*-c++-*-
#ifndef _Circlist_h
#define _Circlist_h

#include "Tracker.hh"

//---------------------------------------------------------------------
// Circlist class template
//---------------------------------------------------------------------

template<class elt> class Circlist;
template<class elt> class CCell {
  friend class Circlist<elt>;
  
  elt val;
  CCell<elt> *next;
  CCell<elt> *prev;
  CCell (elt newelt) {val = newelt; next = prev = 0;}
};
template<class elt> class Circlist {
  CCell<elt> *head, *cur, *end;
  int count;
 public:
  Circlist() {head = cur = end = 0; count = 0;}
  ~Circlist() {kill();}

  void operator+= (elt newelt) {
    end = new CCell<elt> (newelt);
    if (count == 0) {
      cur = head = end;
      head->next = head;
      head->prev = head;
    } else {
      end->prev = head->prev;
      (head->prev)->next = end;
      end->next = head;
      head->prev = end;
    }
    count++;
  }
 
/*
  void operator-= () {
    if (count == 0) {
      printf ("Circlist error: no elements to delete.\n");
    } else {
      (cur->next)->prev = cur->prev;
      (cur->prev)->next = cur->next;
      CCell<elt> *tmp = cur;
      (*this)++;
      delete tmp;
    }
    count--;
  }
*/

  void kill () {
    for (front();count > 0; count--) {
      CCell<elt> *tmp = cur;
      ++(*this);
      delete tmp;
    }
  }

  void front() {cur = head;}
  elt nextelt() {return cur->next->val;}  
  elt prevelt() {return cur->prev->val;}  
  void operator++ () {cur = cur->next;}
  void operator-- () {cur = cur->prev;}
  elt operator* ()  {return cur->val;}
  int elements () {return count;}
  _bool operator~() {return (_bool) (cur==NULL);}
};
#endif
