
/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//* Class : XWindowPlus
//*
//* Definition of XWindowPlus class.  This class provides an interface to the user,
//* on top of the more (graphically abstract) XConsole, which stores things like
//* the GC, etc.
//*
//
//  08/01/94  Gregory D. Hager
//  07/05/95  Jonathan Wang
//  07/25/96  Gregory D. Hager
//  Added color support.  Now a console can be opened as color or
//  monochrome.  At the moment, however, all of the attached windows
//  inherit this from the console, so mixed windows are not possible.
//  Also if you try to display a monochrome image on a color window,
//  you'll get a very blue looking image.........
//
//-----------------------------------------------------------------------------


#ifndef XWindowPlus_h
#define XWindowPlus_h
 
#include <site_config.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h>
#include "CWindow.hh"
#include "Tracker.hh"
#include "Tools.hh"
#include "RGB2int.hh"
#include "XConsole.hh"
#include "Video.hh"
#include <unistd.h>
#include <assert.h>
#include "XVColors.hh"
#include "XVColorSchemes.hh"

#if (XV_OS == XV_IRIX) 
typedef int bool;
#define false 0
#define true 1
#endif 

const int xwpdefault_length = 40;
const int xwpcrlength = 5;
const int xwpgp_rows = 10;

// I put the connection to the server in here
// along with some other things that only need to be done once.
// as we pull apart the XConsole we need to move stuff into here.
static int xv_static_variables_initializedp = 0;

// should be able to deliver drawables for more 
// sophisticated graphics processing!
// have methods to get all the X11 components of this class

// add in syncing of display?



class XWindowPlus : public CWindow
{
private:
  unsigned long red_pixel;
  unsigned long blue_pixel;
  unsigned long green_pixel;
  unsigned long yellow_pixel;
  unsigned long purple_pixel;
  unsigned long cyan_pixel;
  unsigned long white_pixel;
  unsigned long black_pixel;
  unsigned long xv_get_color(Color pixel_name);
  void allocate_color_pixels();

  //************ X Windows variables ****************
  Display *display;  
  int screen;
  Visual *visual;
  XVisualInfo visual_info[1];

  dest_color_scheme color_scheme;
    
  Colormap colormap;

  Window root;          // parent (root window)
  Window winid;         // child (user window) 
  int width;            // dimensions of window
  int height;           
  int depth;            // depth of window

  Pixmap buffer_pixmap; // pixmap for double buffering with graphics calls 
  XImage *Xim;          // Ximage to be copied into window drawable area
  char *data;           // data buffer for Ximage in case conversion of
                        // image info is needed

  GC gc;                // graphics context used for drawing
  //*************************************************

  XConsole* c;


  // XShm stuff, to be figured out.....
  int CompletionType;
  int sent_image;
#ifndef noSHM
  int candoshm;
  XShmSegmentInfo IF;
#endif
  XImage *TrySharedImage();



    // These are here to make it simpler to make use of shared memory.

    //* This code contains a commented (unused) block which
    //* uses XPending to check for the status of the X display
  int ready_to_send_image();
    //* This is a utility function, used by XWindowPlus::resize and
    //* XWindowPlus::close to create an XImage, using a call to
    //* XCreateImage
  XImage *create_image(int width, int height);
    //* Seems that setting (height,width,&bytes_per_line) in
    //* the call to XPutImage suffices
    //* for getting images to show up right.  This is probably not the "right" 
    //* way to do it, but it works.
  int put_image(void *imdata_array, const src_color_scheme& scs,
		int x, int y, int width, int height, 
		int rete = 0, int no_buffer = 0);


  //* Overload of put_image which allows the first arg to be
  //* an unsigned char * (just calls putimage)
  int put_image(u_char *im, const src_color_scheme& scs,
		int x, int y, int width, int height, 
		int rete = 0, int no_buffer = 0)
    {
      assert(scs.bitsperpixel == 8);
      return put_image((void*)im, scs, x, y, width, height, rete, no_buffer);
    };
  
  //* Member for getting rid of an image created by one of the
  //* other image utility functions
  int destroy_image(XImage *im);

public:
  XWindowPlus (XConsole& c);
  XWindowPlus (int iscolor = 1);
  ~XWindowPlus ();

  // basic utilities
  //* Creates an X window  -- the function show is used to display it.
  //* Also initializes a lot of X variables & attributes, e.g. the Ximage
  void open (int width=0, int height=0, 
	     char *window_title = "XWindowPlus",
	     char *display_name = NULL);
  //* Closes an XWindowPlus & removes it from the display
  void close ();
  //* Resizes the corresponding XWindowPlus and XImage
  void resize (int NewHoriz, int NewVert, 
	       char *name = NULL);
  //* Sets the window title via the window manager
  void Set_Name (char *name);

  //* Displays image in a pixmap, flush() copies pixmap contents to 
  //* window on the X display.  Or, for quick display, with no graphics,
  //* specify no_buffer = 1 as a hint to copy information directly to 
  //* display.    
  void show (const Image &image, int x = 0, int y = 0, 
	     int no_buffer = 0, char* name=NULL);
  void show (int *imag, const src_color_scheme& color_scheme, 
	     int widim, int width_in, int height_in, 
	     int no_buffer = 0, char* name=NULL);
  
  void show (void *imag, const src_color_scheme& color_scheme, 
	     int widim, int width_in, int height_in, 
	     int no_buffer = 0, char* name=NULL);

  void show (const Image& image, int x, int y)
    {show(image, x, y, 0, NULL);}; 
  
  void show_grab(Video *v);
  
  //**********************************************
  //* drawing functions
  //**********************************************

  //* fill the pixmap with pixel color, flushrequest causes XWindowPlus::flush()
  //* to be called 
  void clear(int pixel = black_color, int flushrequest = 1);
  //* flush the pixmaps contents to the window, flushrequest controls whether
  //* XFlush(display) is called to empty X servers queue
  void flush(int flushrequest = 1);
  //* Draws a segment in pixmap
  void segment(int x1, int y1, int x2, int y2, int pixel = white_color);
  //* Draws a line on the pixmap at a specified angle with center (x,y)
  void line (int x, int y, int length, float angle,int pixel = white_color);
  //* Draws a crossed pair of lines of specified lengths at the specified angles
  void cline (int x, int y, int length1, float lam1,
	      float angle1,int length2, float lam2, float angle2,
	      int pixel = white_color);
  
  void clearline (int x, int y, int length, float angle) 
    {line (x, y, length, angle); };
  
  void rectangle(int x1, int x2, int y1, int y2, Video &v, int color=white_color);
  void rectangle(int x1, int y1, int width, int height, 
		 int color = white_color ,bool filled = false);
  void circle(int x, int y, int radius, 
	      int color= white_color, bool filled = false);
  
  // functions to get mouse events
  //* Gets a point from a mouse click on an XWindowPlus
  //* getpos() checks whether the video type is IMG_SEQ
  //* if so, grab_static() will be called instead of grab()
  //* consuming image sequence in getpos() is not only wasteful
  //* but will also mess up the console since getpos() grabs gp_rows at a time
  
  position getpos(Video &v,char *name = "Get position", 
		  int length = xwpdefault_length);
  position get_corner_pos(Video &v, char *name = "Get position", 
			  int length = xwpdefault_length);
  position* get_multi_pos(Video &v,int* count, 
			  char *name = "Get Multi Positions", 
			  int length = 1);

  //* Returns two positions: upper left and lower right in a position*
  //* Should be implemented to return a region class, in order that
  //* the caller not have to "delete" the pointer returned
  //* I believe some of the calls to this function currently do not
  //* delete it. The interface is point and drag
  //* It is based on a modified version of getpos()
  position* get_region(Video &v, char *name = "Get Region");
  position* get_region(Video &v, int size_x, int size_y,
		       char *name = "Get Region");		 		  
  position* get_region_with_sampling(Video &v, 
				     int size_x, int size_y,
				     int hs = 1, int vs = 1, 
				     char* name = "Get Region");    
};

// lude "XWindowPlus.icc"

#endif





