/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//* Class : XWindow
//*
//* Definition of XWindow class.  This class provides an interface to the user,
//* on top of the more (graphically abstract) XConsole, which stores things like
//* the GC, etc.
//*
//
//  08/01/94  Gregory D. Hager
//  07/05/95  Jonathan Wang
//  07/25/96  Gregory D. Hager
//  Added color support.  Now a console can be opened as color or
//  monochrome.  At the moment, however, all of the attached windows
//  inherit this from the console, so mixed windows are not possible.
//  Also if you try to display a monochrome image on a color window,
//  you'll get a very blue looking image.........
//
//-----------------------------------------------------------------------------

#ifndef XWindow_h
#define XWindow_h

#include <site_config.h>
#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>
#include "CWindow.hh"
#include "Tracker.hh"
#include "Tools.hh"
#include "RGB2int.hh"
#include "XConsole.hh"
#include "Video.hh"
#include <unistd.h>


#if (XV_OS == XV_IRIX) 
typedef int bool;
#define false 0
#define true 1
#endif 

int const default_length = 40;
int const cr_length = 5;
int const gp_rows = 10;

class XWindow : public CWindow
{
public:
  Display* getdisplay() {return c->display;};
  Drawable getdrawable() {return winid;};
  int getdepth() {return depth;};
  
private:

    //static XConsole* defaultConsole;
  XConsole* c;
  GC gc_clear;
  GC gc_draw;
  Video* video_device;  
  Pixmap pixmap;
  XPoint points1[3]; // vertice trios for cutout
  XPoint points2[3]; 
  XPoint points3[3]; 
  XPoint points4[3]; 


  int *show_grab_data;

  int depth;
  int width;
  int height;
  int winid;
  int CompletionType;
  int sent_image;

#ifndef noSHM
  int candoshm;
  XShmSegmentInfo IF;
#endif
  XImage *TrySharedImage();
  XImage *Xim;
  char *data;

    // These are here to make it simpler to make use of shared memory.

    //* This code contains a commented (unused) block which
    //* uses XPending to check for the status of the X display
  int ready_to_send_image();
    //* This is a utility function, used by XWindow::resize and
    //* XWindow::close to create an XImage, using a call to
    //* XCreateImage
  XImage *create_image(int width, int height);
    //* Seems that setting (height,width,&bytes_per_line) in
    //* the call to XPutImage suffices
    //* for getting images to show up right.  This is probably not the "right" 
    //* way to do it, but it works.
  int put_image(int *im,int x, int y, int width, int height, int rete = 0);
    //* Overload of put_image which allows the first arg to be
    //* an unsigned char *
  int put_image(u_char *im,int x, int y, int width, int height, int rete = 0);
    //* Member for getting rid of an image created by one of the
    //* other image utility functions
  int destroy_image(XImage *im);

public:
  // XWindow (); needs static XConsole defaultConsole to work
  XWindow (XConsole& c);
  XWindow (XConsole& c, char *name);
  ~XWindow ();

    // basic utilities
    //* Creates an X window  -- the function show is used to display it.
    //* Also initializes a lot of X variables & attributes, e.g. the Ximage
  void open (int width=0, int height=0, char *name = "Tracker", char* displayname = NULL); // displayname unused
    //* Closes an XWindow & removes it from the display
  void close ();
    //* Resizes the corresponding XWindow and XImage
  void resize (int NewHoriz, int NewVert, char *name = NULL);
    //* Sets the window title via the window manager
  void Set_Name (char *name);
    //* Displays an XWindow on the X display -- it needs to be "open"ed first
    //* similar to the following overloaded instances
  void show (const Image &image, char *name, int x = 0, int y = 0);
  void show (int *imag, int widim, char *name, int width_in, int height_in);
  void show (const Image &image,int x = 0, int y = 0);
  void show (int *imag, int widim, int width_in, int height_in);

  void show_grab(Video *v,float interval = 33.3);

    // drawing functions
    //* clear the window
  void clear(int pixel = 1);
    //* flush the window
  void flush(void);
    //* Draws a segment on the XWindow 
  void segment(int x1, int y1, int x2, int y2, int pixel);
    //* Draws a line on the XWindow at a specified angle with center (x,y)
  void line (int x, int y, int length, float angle,int pixel = -1);
    //* Draws a crossed pair of lines of specified lengths at the specified angles
  void cline (int x, int y, int length1, float lam1,
	      float angle1,int length2, float lam2, float angle2,
	      int pixel = -1);
  void clearline (int x, int y, int length, float angle);
  void rectangle(int x1, int x2, int y1, int y2, Video &v, int color=1);
  void rectangle(int x1, int y1, int width, int height, 
		 int color = -1 ,bool filled = false);
  void circle(int x, int y, int radius, int color=-1, bool filled = false);
  
    // functions to get mouse events
    //* Gets a point from a mouse click on an XWindow
    //* getpos() checks whether the video type is IMG_SEQ
    //* if so, grab_static() will be called instead of grab()
    //* consuming image sequence in getpos() is not only wasteful
    //* but will also mess up the console since getpos() grabs gp_rows at a time
  
  position getpos(Video &v, char *name = "Get position", 
		  int length = default_length, int dovidupdate=1);
  position get_corner_pos(Video &v, char *name = "Get position", 
		  int length = default_length, int dovidupdate=1);
  position* get_multi_pos(Video &v,int* count, 
  			char *name = "Get Multi Positions", 
  			int length = 1,int dovidupdate=1);
    //* Returns two positions: upper left and lower right in a position*
    //* Should be implemented to return a region class, in order that
    //* the caller not have to "delete" the pointer returned
    //* I believe some of the calls to this function currently do not
    //* delete it. The interface is point and drag
    //* It is based on a modified version of getpos()
  virtual position* get_region(Video &v, char *name = "Get Region", int dovidupdate = 1);
  virtual position* get_region(Video &v, int size_x, int size_y,
  		  char *name = "Get Region", int dovidupdate=1);		 		  

  // Short term hack by ADR to let me point to a region on an static Image.
  void XWindow::get_region(XVImage<int> &i, char *name, position &p1, position &p2);

  position* get_multi_pos(Video &v, char *name, int length,int dovidupdate=1);
};

#include "XWindow.icc"

#endif





