/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Christoher Cantor (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    This software is provided "as is" without express or
    implied warranty.
*/

// These make sure there are some default values for these symbols
// Drawing routines have to check for these values and make sure
// they change them to the proper values if they occur.  Basically,
// this means that every graphical device must implement a color
// mapping function.
//
// Note that the "no_color" definition is used by CompFeature and
// FExtension to allow for subsidiary features to choose their own
// display color if desired.


#ifndef XVColors_h
#define XVColors_h

typedef int Color;
Color const erase_color    = 0;  // these color definitions need to go away!!!!
Color const no_color       = -1; // these color definitions need to go away!!!!
Color const default_color  = -2; // these color definitions need to go away!!!!
Color const default_color2 = -3; // these color definitions need to go away!!!!
Color const default_color3 = -4; // these color definitions need to go away!!!!

// these should stay
Color const green_color    = -2;
Color const red_color      = -3;
Color const blue_color     = -4;
Color const yellow_color   = -5;
Color const purple_color   = -6;
Color const cyan_color     = -7;
Color const white_color    = -8;
Color const black_color    = -9;


#endif

