/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Christoher Cantor (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    This software is provided "as is" without express or
    implied warranty.
*/

// This struct encapsulates the information for display of image information.

#ifndef XVColorSchemes_h
#define XVColorSchemes_h

// hack, assumes 2's complement integers
#define MAX_INTEGER  0X7FFFFFFF
#define MAX_UINTEGER 0XFFFFFFFF

// for now we are treating image information as coming in either 3 bands, 
// or 1 band.  1 band is a monochrome image, three bands is a color image. 
// it doesnt matter what those bands are, they will be displayed as rgb

struct xv_color_scheme {
  int is_color;              // if you are monochrome, use only red band
                             // only bpp, redmax should be relevant 
  unsigned int bitsperpixel;
  unsigned int redmax;       // band resolution ranges from 0 to bandmax  
  unsigned int greenmax;
  unsigned int bluemax;
  unsigned int redmult;      // band is accessed by multiplying/dividing
  unsigned int greenmult;    // by these values after mask has been applied 
  unsigned int bluemult;
  unsigned long redmask;     // actual mask!
  unsigned long greenmask;
  unsigned long bluemask;
};

typedef struct xv_color_scheme src_color_scheme;
typedef struct xv_color_scheme dest_color_scheme;

inline int color_schemes_match(const src_color_scheme& s, 
			       const dest_color_scheme& d)
{
  if ((s.is_color == 0) && (d.is_color == 0))
    {
      return ((s.bitsperpixel == d.bitsperpixel) &&
	      (s.redmax == d.redmax));
    }
  else 
    {
      return ((s.is_color == d.is_color) &&
	      (s.bitsperpixel == d.bitsperpixel) &&
	      (s.redmask == d.redmask) && 
	      (s.greenmask == d.greenmask) && 
	      (s.bluemask == d.bluemask));
    }; 
};


// can have constant declarations here to make things easier
//const struct src_color_scheme 32bit_true_color_bgrx = 
//((struct xv_color_scheme){  bitsperpixel: 32,
//			    redmax:255,
//			    greenmax:255,
//			    bluemax:255,
//			    redmult:,  
//			    greenmult:,
//			    bluemult:,
//			    redmask:,
//			    greenmask:,
//			    bluemask:		    
//});


const src_color_scheme color_32bit_xrgb = 
((src_color_scheme){ is_color:     1,  
			    bitsperpixel: 32,
			    redmax:       255,
			    greenmax:     255,
			    bluemax:      255,
			    redmult:      65536,  
			    greenmult:    256,
			    bluemult:     1,
			    redmask:      0X00FF0000,
			    greenmask:    0X0000FF00,
			    bluemask:     0X000000FF		    
});

const src_color_scheme monochrome_32bit_int = 
((src_color_scheme){  is_color:     0,  
			     bitsperpixel: 32,
			     redmax:       MAX_INTEGER,
			     greenmax:     0,
			     bluemax:      0,
			     redmult:      0,  
			     greenmult:    0,
			     bluemult:     0,
			     redmask:      0,
			     greenmask:    0,
			     bluemask:	   0	    
});

const src_color_scheme monochrome_32bit_uint = 
((src_color_scheme){  is_color:     0,
			     bitsperpixel: 32,
			     redmax:       MAX_UINTEGER,
			     greenmax:     0,
			     bluemax:      0,
			     redmult:      0,  
			     greenmult:    0,
			     bluemult:     0,
			     redmask:      0,
			     greenmask:    0,
			     bluemask:	   0	    
});

const xv_color_scheme undefined_color_scheme = 
((xv_color_scheme){  
  is_color:     -1,
  bitsperpixel: 0XFFFFFFFF,
  redmax:       0XFFFFFFFF,
  greenmax:     0XFFFFFFFF,
  bluemax:      0XFFFFFFFF,
  redmult:      0XFFFFFFFF,  
  greenmult:    0XFFFFFFFF,
  bluemult:     0XFFFFFFFF,
  redmask:      0XFFFFFFFF,
  greenmask:    0XFFFFFFFF,
  bluemask:     0XFFFFFFFF	    
});

const src_color_scheme undefined_src_color_scheme = 
((src_color_scheme) undefined_color_scheme);

const dest_color_scheme undefined_dest_color_scheme = 
((dest_color_scheme) undefined_color_scheme);

inline int is_undefined_color_scheme(const src_color_scheme)
{
  return (color_schemes_match(undefined_src_color_scheme, undefined_dest_color_scheme));
};



#undef MAX_INTEGER

#endif











