/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//*  Class : XConsole
//*
//*  Definition of Console class.  This class provides an interface to the user,
//*  in this version through X windows.
//*
//*  Added color support.  Now a console can be opened as color or
//*  monochrome.  At the moment, however, all of the attached windows
//*  inherit this from the console, so mixed windows are not possible.
//*  Also if you try to display a monochrome image on a color window,
//*  you'll get a very blue looking image......... (GDH 7/25/96)
//*  Loring Holden (lsh@cs.brown.edu) added support for 24 bit color
//*  when 24 bit color is not default visual and fixed
//*  shared memory support so shared mem segments won't hang around.
//*
//  8/1/94   Gregory D. Hager
//  7/5/95   Jonathan Wang
//  7/25/96  Gregory D. Hager
//
//-----------------------------------------------------------------------------

#ifndef XConsole_h
#define XConsole_h

#include <site_config.h>
#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>
#include "Tracker.hh"
#include "Tools.hh"
#include "RGB2int.hh"

//-----------------------------------------------------------------------------
//  Default parameters
//-----------------------------------------------------------------------------

//int const default_length = 40;
//int const cr_length = 5;
//int const gp_rows = 10;

//-----------------------------------------------------------------------------
//  Console class declaration
//-----------------------------------------------------------------------------

class XConsole
{
private:
    //* This and the following are the X Window system's parameters
  friend class XWindowPlus;
  friend class XWindow;
  friend class XColorWindow;

  Display *display;
  int screen;
  Window root;
  Colormap colormap;
  GC gc;
  Visual *visual;
    /// this is the value of the pixel used to show saturated camera responses
  unsigned long redpixel;
    /// this is an array of pixel values which allow you to display the
    /// image on the screen. pixels[i] is the value needed in order that
    /// XPutImage will display the pixel in the desired color
  unsigned long *pixels;
    /// flag to specify whether a color or monochrome colormap is used
  int is_color;
  int depth;

  unsigned long GetPixel(Bool red, Bool green, Bool blue);
    //* Member which allocates the colors. This function determines what kind of
    //* display the current hardware supports (e.g. TrueColor, 8-bit, etc.)
    //* so that the best display gets created.
  void fill_color_map(int w_color, int depth);

public:
    //* Constructor for XConsole - makes the appropriate X calls
    //* to create the necessary data structures (the colormap, display, gc...)
  XConsole(int w_color = 0, int synced = 0);
    //* Helper function for getting a pixel of a higlight color
    //* which is usually something close to red
  XConsole(XConsole &x);
  ~XConsole();

  int color() {return is_color;};
  
  inline void close();
  void map(int *imdata, XImage* im, int n, int nbytes);
    //* Member which transforms image data into the format required by an XImage
    //* monochrome version
  void map_mono(int *imdata, XImage* im, int n, int nbytes);
    //* Member which transforms image data into the format required by an XImage
    //* color version
  void map_color(int *imdata, XImage* im, int n, int nbytes);
    //* Overload of map which allows the first argument to be an unsigned char*
    //* rather than an int* (i.e. a different XVision image representation)
  void map(u_char *imdata, XImage *im, int n, int nbytes);
};

#include "XConsole.icc"

#endif
