/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//* Class : CWindow.hh
//*
//* Definition of CWindow (Console Window) class.  This class provides a 
//* generic window based interface for initialization.
//* This is a virtual base class that defines the interface to the
//* interactive initialization device (usually a graphics window).
//*
//* This "position" structure is returned by the getpos function used to
//* initialize lines and corners.
//*
//* 8/1/94  Gregory D. Hager
//-----------------------------------------------------------------------------

#ifndef CWindow_hh
#define CWindow_hh

#include "Tracker.hh"
#include "Video.hh"

// when debugging
// #define DEBUGCOUT(txt) cout << txt << endl;
// when running
#define DEBUGCOUT(txt) 

struct position {
  int   x;
  int   y;
  float angle;
};

class CWindow
{
protected:
  int _is_open;

public:
  //* The constructor for the CWindow
  //* maintains only one data member: a flag (_is_open) which
  //* indicates the current state of the window.
  CWindow();

  virtual ~CWindow();

  //* The accessor function for the _is_open flag  
  int is_open();

  //* pure virtual definitions for window implementations 
  //* to override!

  virtual void open(int width, int height, 
		    char *window_title,
		    char *display_name) = 0;
  virtual void resize(int NewHoriz, int NewVert, char *name = NULL) = 0;
  virtual void close() = 0;
  virtual void show(const Image &image,int x = 0, int y = 0) = 0;
  virtual void line(int x, int y, int length, float angle,int pixel) = 0;
  virtual void clearline(int x, int y, int length, float angle) = 0;
  virtual void cline(int x, int y, int length1, float lam1,
		     float angle1,int length2, float lam2, 
		     float angle2,int pixel) = 0;

  virtual position getpos(Video &v, char *name, int length, int dovidupdate = 1) 
    {return ((position){0,0,0});};
  virtual position get_corner_pos(Video &v, char *name, int length, int dovidupdate = 1) 
    {return ((position){0,0,0});};
  virtual position* get_region(Video &v, char *name, int dovidupdate = 1) {return NULL;};
  virtual position* get_region(Video &v, int size_x, int size_y, char *name, int dovidupdate = 1) {return NULL;};
  virtual position* get_region_with_sampling(Video &v, 
					     int size_x, int size_y, 
					     int hs, int vs, char *name) {return NULL;};
  virtual position* get_multi_pos(Video &v, char *name, int length, int dovidupdate = 1) {return NULL;};
  virtual position* get_multi_pos(Video &v,int* count, char *name, int length, int dovidupdate = 1) {return NULL;};
  
};
#include "CWindow.icc"

#endif
