/*                                                                -*-c++-*-
    Copyright (C) 1996 Gregory D. Hager 
    (Yale Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Blob.hh
//
//  Declaration of the BlobThreshold object.
//
//  7 - 18 - 96
//  Greg Hager
//
//-----------------------------------------------------------------------------

#ifndef BlobThreshold_h
#define BlobThreshold_h

#include <stream.h>
#include <stdio.h>
#include "Tracker.hh"
#include "FTypes.hh"
#include "Image.hh"
#include "BasicBlob.hh"

class BlobThreshold: public BasicBlob
{

  // The only thing we add is a thresholding function

  int lower_threshold, upper_threshold;

  int member_test(int x) {return ((x > lower_threshold) &&
				  (x < upper_threshold));};

public:

  // Two ways of creating a BlobThreshold. 

  BlobThreshold (Video *v,
		 int height_in = default_Blob_height,
		 int width_in = default_Blob_width,
		 int lthresh_in = 100,int uthresh_in = 255,
		 int lsamp = 1, int usamp = 1,
		 float min_percent = default_Blob_percent);

  BlobThreshold (BlobThreshold &l);

  ~BlobThreshold() {};

  BasicFeature *dup() { return new BlobThreshold (*this); }

};

//-----------------------------------------------------------------------------
#endif
