/*
    Copyright (C) 1996 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  BlobThresh.cc
//
//  Definition of BlobThresh member functions.
//
//  7 - 18 -96
//  Greg Hager
//
//-----------------------------------------------------------------------------

#include <stdlib.h> // for exit()
#include "CWindow.hh"
#include "Video.hh"
#include "BlobThresh.hh"

  // Two ways of creating a BlobThreshold. 

BlobThreshold::BlobThreshold (Video *v,
			       int height_in,
			       int width_in,
			       int lthresh_in,int uthresh_in,
			       int lsamp, int usamp,
			       float min_procent) :
       BasicBlob(v,height_in, width_in, lsamp, usamp, min_procent) {
	 lower_threshold = lthresh_in;
	 upper_threshold = uthresh_in;
       }

BlobThreshold::BlobThreshold (BlobThreshold &l) :
  BasicBlob(l) {
	 lower_threshold = l.lower_threshold;
	 upper_threshold = l.upper_threshold;
  }
    













