/*                                                                -*-c++-*-
    Copyright (C) 1996 Gregory D. Hager 
    (Yale Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Blob.hh
//
//  Declaration of the BlobColor object based on Christopher Rasmussen's
//  Color tracking work.
//
//  7 - 18 - 96
//  Greg Hager
//
//-----------------------------------------------------------------------------

#ifndef BlobColor_h
#define BlobColor_h

#include <stream.h>
#include <stdio.h>
#include "Tracker.hh"
#include "FTypes.hh"
#include "Image.hh"
#include "BasicBlob.hh"
#include "Matrix.hh"

const float default_Blob_saturation_thresh = 0.5;

class BlobColor: public BasicBlob
{

  // Sample size

  int sample_size;
  
  // The only thing we add is a PCA matrix function and
  // threshold

  Matrix variance;
  ColVector pix;
  ColVector mean;

  float sd_threshold;
  float saturation_threshold;

  int member_test(int x);
  int pca_rgb(const Image &x, int npix);

public:

  // Two ways of creating a BlobColor. 

  BlobColor (Video *v,
	     int height_in = default_Blob_height,
	     int width_in = default_Blob_width,
	     float range_in = 2.0,
	     int hsamp = 1, int wsamp = 1,
	     float min_percent = default_Blob_percent,
	     float saturation_thresh = default_Blob_saturation_thresh);

  BlobColor (BlobColor &l);

  // Fix up the routines that initialize to compute pca

  int state_init(float *s) {return state_init(s[0],s[1]);};
  int state_init (float x_in, float y_in);
  int interactive_init (CWindow &w);

  ~BlobColor() {};

  BasicFeature *dup() { return new BlobColor (*this); }

};

//-----------------------------------------------------------------------------
#endif
