################################################################
# Standard End of Makefile definitions
################################################################

################################################################
# Flags (system defaults plus any site or system overrides)
################################################################

CCFLAGS		+= $(WARN_FLAGS) $(OPT_FLAGS)
CXXFLAGS        += $(CCFLAGS) -Wno-non-template-friend

################################################################
# Rules
################################################################

%.o     : %.cc
	@#echo making $@ from @<
	$(CCC) $(CCFLAGS) $(CCCINCLUDE) -c $< -o $@

################################################################
# Programs
################################################################

ifdef PROGRAM

PROG_OBJS  = $(addsuffix .o,$(basename $(SRC_FILES)))

$(PROGRAM): $(PROG_OBJS) $(XV_OBJS)
	$(CCC) $(CCFLAGS) $(PROG_OBJS) $(XV_OBJS) $(XLIBS) $(LIBS) -o $@
programs::	$(PROGRAM)
all	::	$(PROGRAM)
clean::
	$(RM) $(PROG_OBJS) 
veryclean::
	$(RM) $(PROGRAM)
endif

################################################################
# Libraries
################################################################

ifdef LIBNAME

LIB_OBJS  = $(addsuffix .o,$(basename $(SRC_FILES)))

$(LIBNAME): $(LIB_OBJS)
	$(RM) $(LIBNAME) # rebuild instead of just adding fresh stuff
	ar cru ${LIBNAME} ${LIB_OBJS}; ranlib ${LIBNAME} 
libraries::	$(LIBNAME)
all::		$(LIBNAME)
clean::
	$(RM) $(LIB_OBJS) 
veryclean::
	$(RM) $(LIBNAME)
endif

################################################################
# Clean, all, etc
################################################################

.PHONY: all libs libraries programs clean veryclean depend

all::	
programs::
	@#Nothing
libraries::
	@#Nothing

clean::
veryclean:: clean
	$(RM) *~

#progs:
#	make $(WHEESHT) --directory=$(TOP) libraries
#	make programs

################################################################
# Dependencies
################################################################

ifdef SRC_FILES

DEPS = .dependencies
DEP_FILES = $(CC_FILES:.cc=.d)

# We're not proud - if it looks like a dependency file, we'll use it
-include $(DEPS)
-include $(DEP_FILES)

veryclean::
	$(RM) $(DEPS)
	$(RM) $(DEP_FILES)

ifdef AUTODEPEND

# Copied from the gmake manual - builds a dependency file for every C++ file
%.d: %.cc
	@echo Making Dependencies for $<
	@$(SHELL) -ec 'g++ -M $(CCCINCLUDE) $< \
		| sed '\''s/\($*\)\.o[ :]*/\1.o $@ : /g'\'' > $@; \
		[ -s $@ ] || rm -f $@'

else

# Note: We use -M instead of -MM because the XVision sources
# use #include <..> and #include ".." interchangeably.
# Copied from the gmake manual - builds a dependency file for every directory
depend::
	@echo "Making dependency file $(DEPS)"
	@$(SHELL) -ec 'g++ -MG -M $(CCCINCLUDE) $(SRC_FILES) \
	 | sed '\''s/\($*\)\.o[ :]*/\1.o : /g'\'' > $(DEPS) \
	 ; [ -s $(DEPS) ] || rm -f $(DEPS)' \

endif

endif

################################################################
# Recursive invocations
################################################################

ifdef SUBDIRS

all::
	@for dir in $(SUBDIRS); do \
	  echo "Making all in $$dir"; \
	  make $(WHEESHT) --directory=$$dir all; \
	done

programs::
	@for dir in $(SUBDIRS); do \
	  echo "Making programs in $$dir"; \
	  make $(WHEESHT) --directory=$$dir programs; \
	done

libraries::
	@for dir in $(SUBDIRS); do \
	  echo "Making libraries in $$dir"; \
	  make $(WHEESHT) --directory=$$dir libraries; \
	done

depend::
	@for dir in $(SUBDIRS); do \
	  echo "Making dependencies in $$dir"; \
	  make $(WHEESHT) --directory=$$dir depend; \
	done

clean::
	@for dir in $(SUBDIRS); do \
	  echo "Making clean in $$dir"; \
	  make $(WHEESHT) --directory=$$dir clean; \
	done

veryclean::
	@for dir in $(SUBDIRS); do \
	  echo "Making veryclean in $$dir"; \
	  make $(WHEESHT) --directory=$$dir veryclean; \
	done

else

# This hack prevents Make from telling you there's nothing to do
all::
	@#Nothing
programs::
	@#Nothing
libraries::
	@#Nothing
depend::
	@#Nothing
clean::
	@#Nothing
veryclean::
	@#Nothing

endif

################################################################
# End
################################################################
