################################################################
# Standard Start of Makefile definitions
################################################################

# This goes first to make it the default
default:: all

include $(TOP)/config_files/site_config.mk

################################################################
# Directories
################################################################

LIBDIR	= $(TOP)/lib
PROGDIR	= $(TOP)/bin

################################################################
# Flags and options
################################################################

CCCINCLUDE      += -I$(TOP)/config_files
CCCINCLUDE      += -I$(TOP)/support/mpeg_lib
CCCINCLUDE      += -I$(TOP)/support/XVbttv/driver

CCCINCLUDE      += -I$(TOP)/src/Blobs
CCCINCLUDE      += -I$(TOP)/src/Consoles
CCCINCLUDE      += -I$(TOP)/src/Contours
CCCINCLUDE      += -I$(TOP)/src/Devices
CCCINCLUDE      += -I$(TOP)/src/Edges
CCCINCLUDE      += -I$(TOP)/src/Framework
CCCINCLUDE      += -I$(TOP)/src/Geometry
CCCINCLUDE      += -I$(TOP)/src/Pipe
CCCINCLUDE      += -I$(TOP)/src/SSD
CCCINCLUDE      += -I$(TOP)/src/Tools

CCCINCLUDE      += -I$(TOP)/examples/utils

# Note: the order of these decls matters a lot!
# Note too that we don't use -L and -l because we want to list
# These files as dependencies.
XV_OBJS		+= $(LIBDIR)/libXVPipe.a   
XV_OBJS		+= $(LIBDIR)/libXVSSD.a    
XV_OBJS		+= $(LIBDIR)/libXVBlobs.a  
XV_OBJS		+= $(LIBDIR)/libXVEdge.a   
XV_OBJS		+= $(LIBDIR)/libXVSnake.a
XV_OBJS		+= $(LIBDIR)/libXVCons.a   
XV_OBJS		+= $(LIBDIR)/libdeviceparse.a
XV_OBJS		+= $(LIBDIR)/libXVDevs.a   
XV_OBJS		+= $(LIBDIR)/libXVCons.a   # deliberate duplicate - blech!
XV_OBJS		+= $(LIBDIR)/libXVision.a
XV_OBJS		+= $(LIBDIR)/libXVTools.a
XV_OBJS		+= $(LIBDIR)/libmpeg.a

# This is a fairly complete list of gcc's warning flags
GCC_WARN_FLAGS	+= -Wall 
GCC_WARN_FLAGS	+= -Wno-unused 
GCC_WARN_FLAGS	+= -W
GCC_WARN_FLAGS	+= -Wstrict-prototypes 
GCC_WARN_FLAGS	+= -Wmissing-prototypes 
GCC_WARN_FLAGS	+= -Wmissing-declarations
#GCC_WARN_FLAGS	+= -Wredundant-decls 
GCC_WARN_FLAGS	+= -Wnested-externs
#GCC_WARN_FLAGS	+= -Wshadow
#GCC_WARN_FLAGS	+= -Winline
#GCC_WARN_FLAGS	+= -Waggregate-return
GCC_WARN_FLAGS	+= -Wpointer-arith
GCC_WARN_FLAGS	+= -Wbad-function-cast
GCC_WARN_FLAGS	+= -Wcast-qual
GCC_WARN_FLAGS	+= -Wcast-align
GCC_WARN_FLAGS	+= -Wconversion
GCC_WARN_FLAGS	+= -Wreorder
GCC_WARN_FLAGS	+= -Wtemplate-debugging
GCC_WARN_FLAGS	+= -Woverloaded-virtual
GCC_WARN_FLAGS	+= -Wsynth

# Default: often overridden
GCC_OPT_FLAGS += -O6


################################################################
# Files
################################################################

CC_FILES = $(wildcard *.cc)
C_FILES  = $(wildcard *.c)
S_FILES  = $(wildcard *.S)

################################################################
# Make control
################################################################

# If you want a bit of wheesht while you build, set some of these
# Note: --silent might be too quiet - not sure yet
WHEESHT += --no-print-directory 
#WHEESHT += --silent

################################################################
# End
################################################################

