----------------------------------------------------------------
-- Utilities
----------------------------------------------------------------

module XVUtilities
	( module XVUtilities
	) where

import IOExts

mapem_ :: Monad m => [a] -> (a -> m b) -> m ()
mapem_ as m = mapM_ m as

mapem :: Monad m => [a] -> (a -> m b) -> m [b]
mapem as m = mapM m as

repeatUntil :: Monad m => m Bool -> m ()
repeatUntil m = do { b <- m; if b then return () else repeatUntil m }

while :: Monad m => m Bool -> m () -> m ()
while tst body = do 
  { b <- tst
  ; if b 
    then do { body; while tst body } 
    else do { return () }
  }

mkLazyList :: IO a -> IO [a]
mkLazyList m = unsafeInterleaveIO $ do
	     x  <- m
	     xs <- mkLazyList m
	     return (x:xs)

mkLazyList' :: [IO a] -> IO [a]
mkLazyList' ms = unsafeInterleaveIO $ do
	     x  <- head ms
	     xs <- mkLazyList' (tail ms)
	     return (x:xs)

----------------------------------------------------------------
-- End
----------------------------------------------------------------
