
module XVBaseTypes where

import StaticTypesCore hiding (Color)

type ISize = (Int,Int)
type IPoint = (Int,Int)
type RGBtriple = (Int,Int,Int)
type Offset = (Double, Double, Double)
type Position = (Int,Int,Float)
type HSI = (Int,Int,Int)
type Error = RealVal

-- Make WithError strict in both values to avoid leaking matrices

-- Remove these "!"'s for more laziness:

data Eval a => WithError a =
  WithError !a !Error  deriving (Eq, Show)

type Unit   = RealVal -- unit of length (pixels)
-- Should be a real type ...
type Box = (Point2, Point2, Point2, Point2)


-- offsets to apply to Lines (of various kinds)
-- (raw data returned by Edge trackers)
type DeltaEdge = Vector2

-- A rectangle
data Size = Size RealVal RealVal deriving (Eq, Show)   -- width, height
                                                    -- or columns, rows

--  Make these real types someday
type Intersection = (Point2, Vector2, Vector2)

type Circle = (Point2, RealVal)

type Color = Int

data Region = Region {regionMiddle :: Point2,
                      regionSize :: Size,
                      regionAngle ::  Radians} deriving Show


data LineSegment2 = LineSegment2 Point2 Vector2 deriving Show

class Sized a where
  sizeOf :: a -> Size
  
