----------------------------------------------------------------
-- Video
----------------------------------------------------------------

module Video
	( openVideo, closeVideo
        , acquireImage
        , acquireRegion  -- Obsolete? 
        , forwardVideo
        , AOptions(..) 
        , vline
        , vbox
	) where

import XVision
	( Video
	, openVideo, closeVideo
	, imageVideo2
	, imageVideo3
        , forwardVideo
	, line
        , sizeVideo
	)

import Geometry
import XVTypes

----------------------------------------------------------------
-- Exports
----------------------------------------------------------------

acquireRegion :: Video -> Size -> Region -> IO ImageInt

----------------------------------------------------------------
-- Implementations
----------------------------------------------------------------

instance Sized Video      where sizeOf = toSize . sizeVideo

-- We could also have a descructive acquire function, passing in an
-- image to put the result in.

-- AOptions is ignored for now but could be used to parameterize
-- image acquisition. 

-- The translation maps a rectangle of size sz, centered at the origin,

-- onto the video coordinate system. 
data AOptions = NoOptions

acquireImage :: AOptions -> Video -> Size -> Transform2 -> 
     IO (ImageRGB, Transform2)
acquireImage opts vid sz t =
 case asUScale2 t of  
   Just (v,s,a) | isInt s -> acquireIntScaledRegion
                | otherwise -> acquireScaledRegion
    where 
     acquireIntScaledRegion =
       do image <- imageVideo2 vid isz (truncate s) (x,y,a)
          return (image,t)
     acquireScaledRegion = error "Can't do scaled regions yet"
     isz = toISize sz
     Vector2XY x y = v
   Nothing -> error "Acquired using complex transformation!"

isInt x = (fromInteger $ truncate x) == x


acquireRegion video sz r = do 
  { i <- imageVideo3 video (toISize sz) (w,h) (x,y,a)
  --; print (size,x',y',a')

  ; let 
        c = cos a
        s = sin a
        dx = 0.5 * (c*w - s*h)
        dy = 0.5 * (c*h + s*w)
        p1 = point2XY (x-dx) (y-dy)
        p2 = point2XY (x-dx) (y+dy)
        p3 = point2XY (x+dx) (y+dy)
        p4 = point2XY (x+dx) (y-dy)
    in vbox video (p1,p2,p3,p4)
  ; return i
  }
 where
  Point2XY x y = regionMiddle r
  a            = regionAngle r
  Size w h     = regionSize r

  x' = fromDouble x
  y' = fromDouble y
  a' = fromDouble a

vline :: Video -> Point2 -> Point2 -> IO ()
vline v p1 p2 = line v (point2ToIPoint p1) (point2ToIPoint p2)

vbox :: Video -> Box -> IO ()
vbox v (p1,p2,p3,p4) = do
  { vline v p1 p2
  ; vline v p2 p3
  ; vline v p3 p4
  ; vline v p4 p1
  }

----------------------------------------------------------------
-- End
----------------------------------------------------------------
