module Tg where


import XVision
import Prelude hiding (sum)
import IOExts

import Window
import XVUtilities
import Overload

m1 = "/home/hager/movies/mpeg_file.mpg"
m2 = "/home/hager/movies/lab_seq.mpg"
m_file = m2

t1 = do
  { m <- openMPEG m_file
  ; c <- openConsole True True 
  ; w <- createWindow c 
  ; openWindow w (size m) m_file
  ; while (return True) $ do
    { i <- currentImage m
    ; showImage w i
    ; moveForward m
    }
  ; closeWindow w
  ; destroyWindow w
  ; closeConsole c
  ; closeMPEG m
  }

--- Let's try to figure out some infrastructure; this 
--- is too simplistic tho, as we really need someone
--- to hand them a video source from which we acquire
--- the image

class PrimTrackable state where
   update	:: state -> Image_Int -> state

--- This is a basic segmentation primitive


--  ----------------------------------------------------------------
--  -- Greg's stuff
--  ----------------------------------------------------------------
--  
--  threshRGB :: Int -> (Int,Int,Int) -> Image_RGB -> Image_Int
--  threshRGB th rgb im = threshBW th 1 (clrproject rgb im) `multImage` colorToBW im
--  
--  --- This is one way to do some neighborhood voting --- need to factor
--  --- the convolution for any real use
--  
--  nCount :: Int -> Int -> Image_Int -> Image_Int
--  nCount wx wy im = convolve1 (imageToMask (ones wy wx)) im
--  
--  nbrHoodVote :: Int -> Int -> Int -> Image_Int -> Image_Int
--  nbrHoodVote wx wy thresh im = threshBW thresh 1 (nCount wx wy im)
--  
--  -- This is a simple way to check and see what a given rgb triple segments
--  checkrgb th rgb = do
--    { c <- openConsole True True 
--    ; (v,_) <- openVideo videoDevice
--    ; w1 <- createWindow c
--    ; w2 <- createWindow c
--    ; openWindow w1 (size v) "Video"
--    ; openWindow w2 (size v) "Segmented wing wang"
--    ; runPipe $
--  	  let 
--  	    im1 = liftIO0 (grabV v (size v) (0,0))
--  	    im2 = lift1 (threshRGB th rgb) im1
--  	    im3 = lift1 (nbrHoodVote 3 3 5) im2
--  	  in
--  	    --ptrace (lift1 avgcolor im2) $
--  	    lift2 (>>) (lift1 (showImage w1 ) im1)
--  		       (lift1 (showImage w2 . bwToColor) im3)
--    }
--  
--  grabV :: Video -> Sz -> Point -> IO Image_RGB
--  grabV v sz pos = imageVideo v pos (pos + sz) (1,1)



{-
threshrgb th rgb im = multImage (threshBW th 1 (clrproject rgb im)) im

--- This is one way to do some neighborhood voting --- need to factor
--- the convolution for any real use

ncount wx wy im = convolve1 (imageToMask (ones wy wx)) im
nhoodvote wx wy thresh im = threshBW thresh 1 (ncount wx wy im)

-- This is a simple way to check and see what a given rgb triple segments

checkrgb th rgb = do
  { c <- openConsole True True 
  ; m <- openMPEG m_file
  ; i0 <- currentImage m
  ; ims <- images m
  ; w <- createWindow c
  ; w1 <- createWindow c
  ; openWindow w (sizeMPEG m) m_file
  ; let im2 = threshrgb th rgb (head ims)
  ; let im3 = nhoodvote 3 3 5 im2
--  ; let im3 = im2
  ; openWindow w1 (size im3) m_file
  ; showImage w im2
  ; showImage w1 im3
  ; print (avgcolor im3)
  ; regions <- interactive_init c i0 1
  ; closeWindow w
  ; destroyWindow w
  ; closeConsole c
  ; closeMPEG m
  }

-}

t1 = do
  { m <- openMPEG m_file
  ; c <- openConsole True True 
  ; w <- createWindow c 
  ; openWindow w (sizeMPEG m) m_file
  ; while (return True) $ do
    { i <- currentImage m
    ; showImage w i
    ; moveForward m
    }
  ; closeWindow w
  ; destroyWindow w
  ; closeConsole c
  ; closeMPEG m
  }

t4 = do
  { m <- openMPEG m_file
  ; is <- images m
  ; c <- openConsole True True 
  ; let mask = gaussianMask (10,10) 0.01
  ; let iss = 
	 [ is
	 , map (bwToColor . colorToBW) is
	 , map (bwToColor . plusInt 50 . colorToBW) is
	 , map (bwToColor . plusInt (-50) . colorToBW) is
	 , map (bwToColor . (\ x -> plusImage x x) . colorToBW) is
--	 , map (subImage (20,20) (200,50)) is
--       , map (scale (0.5,0.5)) is
--	 , map (reduce_resolution (2,2)) is
--	 , map (magnify (2,2)) is
--	 , map (magnify (2,2) . subImage (50,50) (150,150)) is
--	 , map (convolve1 mask) is
--	 , repeat (maskToImage mask)
	 ]
  ; ws <- openWins c iss
  ; while (return True) $ do
    { prodWins ws
    }
  ; closeWins ws
  ; closeConsole c
  ; closeMPEG m
  }

----------------------------------------------------------------
-- SSD tests
----------------------------------------------------------------

-- check what a given bit of the image looks like
t5 x0 y0 = do
  { c <- openConsole True True 
  ; m <- openMPEG m_file
  ; ~(i0:_) <- images m
  ; let iss = 
	 [ [i0]
	 , [ bwToColor $ grab (w,h) (x0,y0) $ colorToBW i0 ]
	 ]
  ; ws <- openWins c iss
  ; while (return True) $ do
    { prodWins ws
    }
  ; closeWins ws
  ; closeConsole c
  ; closeMPEG m
  }
 where
  (w,h) = (60,60)  -- size of image

-- try to find that part of the image
t6 x0 y0 = do
--t6 x0 y0 dx dy = do
  { m <- openMPEG m_file
  ; ims <- images m
  ; let im0 = colorToBW (head ims)
        ref = grab' (w,h) (x0,y0) im0
  ; mapem_ ([-20,-10 .. 20] `cross` [-20,-10 .. 20]) $ \ (dx,dy) -> 
      print (take 20 (map round2 (approxs2 ref im0 (x0+dx,y0+dy))))

  --; print (take 10 (approxs2 ref im0 (x0+dx,y0+dy)))
  ; closeMPEG m
  }
 where
  round2 (x,y) = (round x, round y)
  (w,h) = (60,60)  -- size of image

-- try to follow an image round the room
track_xy x0 y0 = do
  { m <- openMPEG m_file
  ; ims <- images m
  ; let bws = map colorToBW ims
        ref = grab' (w,h) (x0,y0) (head bws)
        pts = scanl (find2 ref) (x0,y0) bws
  ; let iss = 
	 [ ims
	 , map bwToColor $ zipWith (grab' (w,h)) pts bws
	 ]
  -- everything above here is image processing

  -- everything below here is display
  ; c <- openConsole True True 
  ; ws <- openWins c iss
  ; while (return True) $ do
    { prodWins ws
    }
  ; closeWins ws
  ; closeConsole c
  ; closeMPEG m
  }
 where
  (w,h) = (60,60)  -- size of image


interactive_init :: Console -> Image_RGB -> Int -> IO [((Double,Double), (Int,Int))]
interactive_init c i0 n = do 
  { w <- createWindow c
  ; openWindow w (size i0) "Select Object"
  ; ps <- mapem [1..n] (\_ -> get w i0)
  ; closeWindow w
  ; destroyWindow w
-- SSD seems to flip out on non-square images
--  ; return ((fromInt x0, fromInt y0), (x1-x0, y1-y0))
  ; return ps
  }
 where
  fix x = abs (2 * (x `div` 2))  -- hack: must be +ve and even
  get w i0 = do
    { ((x0,y0,_),(x1,y1,_)) <- getRegion w "Object" i0
    ; return ((fromInt x0, fromInt y0), (fix(x1-x0), fix(y1-y0)))
    }

-- try to follow n images round the room
track fname n = do
  { c <- openConsole True True 
  ; m <- openMPEG fname

  ; i0 <- currentImage m
  ; regions <- interactive_init c i0 n


  ; ims <- images m
  ; display c $ 
      [ ims ] ++
      (map (\ r -> map bwToColor (track' r (map colorToBW ims))) regions)
  ; closeConsole c
  ; closeMPEG m
  }

scl   = 2        -- scale
iters = 10       -- iterations per frame

----------------------------------------------------------------
-- SSD in xy and theta directions
----------------------------------------------------------------

{-

ToDo: don't like the use of [Double]!  Use Vector class instead?

ssd :: Int -> Image_Int -> Image_Int -> [Double]
ssd s r0 = 
   \ r -> let dR = compressxy (scale_r0 `minusImage` scale r)
	      dv = map (innerProduct dR) v
	      o = m * dv
	  in
	  map (fromInt s *) o
 where
  scale x = reduce_resolution (s,s) x

  scale_r0 = scale r0

  dX   = smoothDx scale_r0
  dY   = smoothDy scale_r0
  dT   = (dX `multImage` cY) - (dY `multImage` cX)

  -- must be odd sized for orientation
  assert (odd width && odd height)
  x  = width  / 2
  y  = height / 2
  cX = mkColumn [-x .. x]           * row (replicate height 1)
  cY = mkColumn (replicate width 1) * mkColumn [-y .. y] 

  v = [dX,dY,dT]
  m = inverse (v `cross` v)

improve :: Image_Int -> Image_Int -> [Double] -> [Double]
improve ref i (x,y) = (x + dx, y + dy)
 where
  (dx,dy) = ssd scl ref (grab (w,h) (round x, round y) i)

approxs :: Image_Int -> Image_Int -> [Double] -> [[Double]]
approxs ref i pos = iterate (improve ref i) pos

-- ToDo: make this work
residual = sum (sqr (Dt - M0)) / (width * height)

-}

----------------------------------------------------------------
-- SSD in xy directions
----------------------------------------------------------------

ssd2 :: Int -> Image_Int -> Image_Int -> (Double,Double)
ssd2 s r0 = 
   \ r -> let dR = compressxy (fr0 `minusImage` f r)
	      dx = dR `innerProduct` dX
	      dy = dR `innerProduct` dY
	      ox = a*dx + b*dy
	      oy = c*dx + d*dy
	  in
	  (fromInt s * ox, fromInt s * oy)
 where
  f = reduce_resolution (s,s)

  fr0  = f r0

  dX   = smoothDx fr0
  dY   = smoothDy fr0

  dXdX = dX `innerProduct` dX
  dXdY = dX `innerProduct` dY
  dYdX = dY `innerProduct` dX
  dYdY = dY `innerProduct` dY

  (a,b,c,d) = inverse (dXdX, dXdY, dYdX, dYdY)

improve2 :: Image_Int -> Image_Int -> (Double,Double) -> (Double,Double)
improve2 ref i (x,y) = (x + dx, y + dy)
 where
  (dx,dy) = ssd2 scl ref (grab (size ref) (round x, round y) i)

approxs2 :: Image_Int -> Image_Int -> (Double,Double) -> [(Double,Double)]
approxs2 ref i pos = iterate (improve2 ref i) pos

-- find reference image in main image using ssd
-- ToDo: iterate until we converge
-- ToDo: ought to round its coordinates before it starts 
-- and round its final result - since that's the fundamental
-- accuracy of the image grabbing
find2 :: Image_Int -> (Double,Double) -> Image_Int -> (Double,Double)
find2 ref xy im = approxs2 ref im xy !! iters

track' :: ((Double,Double),(Int,Int)) -> [Image_Int] -> [Image_Int]
track' (p,sz) bws = zipWith (grab' sz) (track'' p sz bws) bws

track'' :: (Double,Double) -> (Int,Int) -> [Image_Int] -> [(Double,Double)]
track'' pos sz bws = scanl (find2 ref) pos bws
 where
  ref = grab' sz pos (head bws)

----------------------------------------------------------------
-- SSD in x direction
----------------------------------------------------------------

ssd_x :: Int -> Image_Int -> Image_Int -> Double
ssd_x s r0 = \ r -> fromInt s * (compressx (fr0 `minusImage` f r) `innerProduct` dX) / dXdX
 where
  fr0  = f  r0
  dX   = dx fr0
  dXdX = dX `innerProduct` dX

  f x = reduce_resolution (s,s) x

x_improve :: Image_Int -> Image_Int -> (Double,Double) -> (Double,Double)
x_improve ref i (x,y) = (x + ssd_x scl ref (grab (size ref) (round x, round y) i), y)

x_approxs :: Image_Int -> Image_Int -> (Double,Double) -> [(Double,Double)]
x_approxs ref i pos = iterate (x_improve ref i) pos

----------------------------------------------------------------
-- Utilities
----------------------------------------------------------------

inverse :: (Double,Double,Double,Double) -> (Double,Double,Double,Double)
inverse (a,b,c,d) = (d/det, -c/det, -b/det, a/det)
 where
  det = a*d - b*c


grab (w,h) (x,y) i = subImage (x,y) (x+w,y+h) i

grab' (w,h) (x,y) i = subImage (round x,     round y) 
                               (round x + w, round y + h) i

compressxy :: Image_Int -> Image_Int
compressxy = compressx . compressy

cross :: [a] -> [b] -> [(a,b)]
cross as bs = [ (a,b) | a <- as, b <- bs ]

----------------------------------------------------------------
-- Lazy mpeg read
----------------------------------------------------------------

images :: Mpeg -> IO [Image_RGB]
images m = mkLazyList $ do
  { i <- currentImage m
  ; moveForward m
  ; return i
  }

----------------------------------------------------------------
-- End
----------------------------------------------------------------
