
module Testers where


import XVTypes
import Pipe
import Geometry
import Window
import Video
import Matrix
import SSD
import Draw

-- Some basic vb

-- Tests for Gemoetry

-- Points

p0 = Point2XY 0 0
p1 = Point2XY 1 1
p23 = Point2XY 2 3

v0 = Vector2XY 0 0
v1 = Vector2XY 1 1
v23 = vector2XY 2 3

a45, a90 :: Radians
a45 = pi / 4  
a90 = pi / 2

s22 = Size 2 2
s33 = Size 3 3

tr90 = rotate2 a90
tp1 = translate2 v1
ts2 = uscale2 2
tbig = tr90 `compose2` tp1 `compose2` ts2

ls1 = mkSegment2PP p0 p1
ls2 = mkSegment2PP p1 p23


-- Geometry.hs

-- Test 2D Transforms since it's my code ...

gt1 = tr90 *% p1  -- -1, 0 
gt2 = tp1 *% p1   -- 2,2
gt3 = ts2 *% p1   -- 2,2
gt4 = tbig *% p1  -- -3, 3
gt5 = factorTransform2 tbig
gt6 = asUScale2 tbig
gt7 = mttl6 $ asAffine2 tbig

ttl6 :: (a,a,a,a,a,a)-> [a]
ttl6 (a,b,c,d,e,f) = [a,b,c,d,e,f]
mttl6 Nothing = []
mttl6 (Just x) = ttl6 x

-- Draw.hs

drawit f = do
  c <- openConsole False False
  w <- createWindow c
  openWindow w (Size 300 300) "Test"
  clearWindow w (-1)
  f w
  getLine
  closeWindow w
  destroyWindow w
  closeConsole c

-- This isn't working as far as I can tell -- jcp

td1 = drawit (\w -> drawColorCircle w (Point2XY 50 50, 30) 0)

-- Testing of basic Matrix code

m1 = listToMatrix [[1,2,3],[4,5,6]]
m2 = listToMatrix [[1,1,1],[2,2,2]]
m3 = listToMatrix [[1,2],[3,4],[5,6]]
  


-- Testing basic video features

-- General code for testing vision stuff
--- Select the video device to test with
myvideoDevice = "MPEG"
--videoDevice = "METEOR_COLOR16"
--videoDevice = "METEOR_COLOR24"
--myvideoDevice = "METEOR_MONO"


-- Run the video

showlive = 
   do 
     (vid,_) <- openVideo myvideoDevice
     runPipe $ lift0 (forwardVideo vid)
     
{-
forwardP m = liftIO1 (\x -> do {forwardVideo m;return x})
forwardPa m = 

--- this is the "simple" version of show live which assumes that
--- there is an external console which is display; this just
--- pulls on the source to update it.

grabV :: Video -> Sz -> Point -> IO ImageRGB
grabV v sz pos = imageVideo v pos (pos + sz) (1,1)

--- this version of show live also blits the images to the screen
--- note the unfortunate use for the forwarding function whic
--- obviously should be hidden in runPipe ....

showlive2 = 
   do 
     { (vid,_) <- openVideo myvideoDevice
     ; w <- newWindow "Live Display"
     ; runPipeFor (forwardVideo vid) 
                $ lift1 (showImage w) 
                $ liftIO0 (grabV vid (size vid) (0,0))
     ; closeWindow w
     ; destroyWindow w
      }

-}

-- Stolen from TestCorner.hs

----------------------------------------------------------------
-- Showlive
----------------------------------------------------------------
{-
showlive = do
  { c <- openConsole False False --True True
  ; (v,_) <- openVideo videoDevice
  ; w <- createWindow c
  ; runSP (draw w v) undefined
	  (sp1 undefined)
  }
	
 where
  draw w v _ = do
   { im <- XV.imageVideo v (0,0) (size v) (1,1)
   ; drawImage w (XV.colorToBW im)

   ; let r = Region (point2XY 190 99) (Size 10 10) (pi/4)
   ; pic   <- acquireRegion v (50,50) r
   ; drawImage w pic

   --; putChar '.'
   ; return ()
   }

-}