----------------------------------------------------------------
--
----------------------------------------------------------------

module TestCorner
	( module TestCorner
	) where

import XVTypes
import Draw( drawIntersection, drawImage, drawBox )
--import XVision as XV hiding (sum)
import qualified Intersect
import qualified Edge
import SP
import Pipe
import Geometry
import qualified Box
import Init(interactiveInitRect, interactiveInitBox)
import Video
import Image
import Window
import Draw

----------------------------------------------------------------


width = 20  -- width of tracker in pixels (?)
videoDevice = "MPEG"

----------------------------------------------------------------
-- Corner test
----------------------------------------------------------------

testCorner = do
   c <- openConsole False False --True True
   (v,_) <- openVideo videoDevice
   win <- createWindow c

   (p,Size w h) <- interactiveInitRect c v "Rectangle"
  -- fixed (?) ADR's initial intersections (appeared to use 3 points?)
   runSP (draw win v) (mkIntersection
                           p (w *^ xVector2) (h *^ yVector2))
	  (Intersect.corner (Edge.tracker v width) (Edge.tracker v width))

	
 where
  draw win v i = do
    (im,_) <- acquireImage NoOptions v (sizeOf v) identity2
    drawImage win (colorToBWImage im)
    drawIntersection win i
    forwardVideo v
--    print i
--    putChar '.'


----------------------------------------------------------------
-- Box test
----------------------------------------------------------------

testBox = do
   c <- openConsole False False --True True
   (v,_) <- openVideo videoDevice
   w <- createWindow c
   openWindow w (sizeOf v) "Tracking"
   box <- interactiveInitBox c v "Initialize a box"
   putStrLn ("Tracking box: " ++ show box)
   runSP (draw w v) box (Box.box v (iSize width 20))
  
	
 where
  draw w v b = do
    (im,_) <- acquireImage NoOptions v (sizeOf v) identity2
--    print b
    drawImage w (colorToBWImage im)
    drawBox w b
    forwardVideo v
--    putChar '.'


----------------------------------------------------------------
-- End
----------------------------------------------------------------
