module T where

import XVision
import Prelude hiding (sum)
import IOExts

import Window
import XVUtilities
import Overload
-- import Scout
import Monad
--import Posix hiding (read,write)

m_file = m1
m1 = "mpeg_file.mpg"
m2 = "mpeg2.mpg"
m3 = "/home/reid/adr.mpg"
m4 = "/home/reid/pen.mpg"
m5 = "/home/reid/truck.mpg"
m6 = "/home/reid/spanner.mpg"
m7 = "/home/reid/ball.mpg"
m8 = "/home/reid/face1.mpg"
m9 = "/home/reid/face2.mpg"

-- pick one
--videoDevice = "K2T_MONO"
--videoDevice = "K2T_COLOR"
--videoDevice = "IT_FG101"
--videoDevice = "DT3155"
--videoDevice = "METEOR_COLOR24"
--videoDevice = "METEOR_COLOR16"
--videoDevice = "METEOR_MONO"
videoDevice = "MPEG"
--videoDevice = "INDYCAM_MONO"
--videoDevice = "INDYCAM_COLOR"

t1 = do
  { m <- openMPEG m_file
  ; c <- openConsole True True 
  ; w <- createWindow c 
  ; openWindow w (size m) m_file
  ; while (return True) $ do
    { i <- currentImage m
    ; showImage w i
    ; moveForward m
    }
  ; closeWindow w
  ; destroyWindow w
  ; closeConsole c
  ; closeMPEG m
  }

live = do
  { (m,_) <- openVideo videoDevice
  ; c <- openConsole True True 
  ; w <- createWindow c 
  ; openWindow w (size m) "Video"
  ; while (return True) $ do
    { i <- imageVideo m (0,0) (size m) (1,1)
--    { i <- imageVideo m (0,0) (320,240) (2,2)  -- subsampling doesn't seem to work
    ; showImage w i
    }
  ; closeWindow w
  ; destroyWindow w
  ; closeConsole c
  ; closeVideo m
  }

-- Display 2 windows at once: one being brighter than the other
t2 x = do
  { m <- openMPEG m_file
  ; c <- openConsole True True 
  ; w1 <- createWindow c 
  ; w2 <- createWindow c 
  ; openWindow w1 (size m) m_file
  ; openWindow w2 (size m) ("brighter " ++ m_file)
  ; while (return True) $ do
    { i <- currentImage m
    ; showImage w1 i
    ; showImage w2 (bwToColor (plusInt x (colorToBW i)))
    ; moveForward m
    }
  ; closeWindow w1
  ; destroyWindow w1
  ; closeWindow w2
  ; destroyWindow w2
  ; closeConsole c
  ; closeMPEG m
  }

t3 = do
  { m <- openMPEG m_file
  ; is <- images m
  ; c <- openConsole True True 
  ; w <- createWindow c 
  ; openWindow w (size m) m_file
  ; mapem_ is (showImage w)
  ; closeWindow w
  ; destroyWindow w
  ; closeConsole c
  ; closeMPEG m
  }

t4 = do
  { m <- openMPEG m_file
  ; is <- images m
  ; c <- openConsole True True 
  ; let mask = gaussianMask (10,10) 0.01
  ; let iss = 
	 [ is
	 , map (bwToColor . colorToBW) is
	 , map (bwToColor . plusInt 50 . colorToBW) is
	 , map (bwToColor . plusInt (-50) . colorToBW) is
	 , map (bwToColor . (\ x -> plusImage x x) . colorToBW) is
--	 , map (subImage (20,20) (200,50)) is
--       , map (scale (0.5,0.5)) is
--	 , map (reduce_resolution (2,2)) is
--	 , map (magnify (2,2)) is
--	 , map (magnify (2,2) . subImage (50,50) (150,150)) is
--	 , map (convolve1 mask) is
--	 , repeat (maskToImage mask)
	 ]
  ; ws <- openWins c iss
  ; while (return True) $ do
    { prodWins ws
    }
  ; closeWins ws
  ; closeConsole c
  ; closeMPEG m
  }


----------------------------------------------------------------
-- Scout tests
----------------------------------------------------------------

-- not very useful - more of a cookbook of things to try
s1 = do
  { let timeout   = 1
        robotName = Just "128.36.17.232"
        port      = Just "65001"
  ; c <- openConsole True True 
  ; (m,_) <- openVideo videoDevice

  ; robotConnect (Just timeout) Nothing Nothing
  ; wait 1000000
  ; robotSetVelocity 1 (pi/8)
  ; wait 1000000
  ; robotSetVelocity 1 (-pi/8)
  ; wait 1000000
  ; robotSetWheelVelocity 1 (-1)
  ; wait 1000000
  ; robotSetWheelVelocity (-1) (1)
  ; wait 1000000
  }

----------------------------------------------------------------
-- SSD tests
----------------------------------------------------------------

scl   = 4       -- scale
iters = 5       -- iterations per frame



-- check what a given bit of the image looks like
t5 x0 y0 = do
  { c <- openConsole True True 
  ; m <- openMPEG m_file
  ; ~(i0:_) <- images m
  ; let iss = 
	 [ [i0]
	 , [ bwToColor $ grab (w,h) (x0,y0) $ colorToBW i0 ]
	 ]
  ; ws <- openWins c iss
  ; while (return True) $ do
    { prodWins ws
    }
  ; closeWins ws
  ; closeConsole c
  ; closeMPEG m
  }
 where
  (w,h) = (60,60)  -- size of image

-- try to find that part of the image
t6 x0 y0 = do
--t6 x0 y0 dx dy = do
  { m <- openMPEG m_file
  ; ims <- images m
  ; let im0 = colorToBW (head ims)
        ref = grab' (w,h) (x0,y0) im0
  ; mapem_ ([-20,-10 .. 20] `cross` [-20,-10 .. 20]) $ \ (dx,dy) -> 
      print (take 20 (map round2 (approxs2 ref im0 (x0+dx,y0+dy))))

  --; print (take 10 (approxs2 ref im0 (x0+dx,y0+dy)))
  ; closeMPEG m
  }
 where
  round2 (x,y) = (round x, round y)
  (w,h) = (60,60)  -- size of image

-- try to follow an image round the room
track_xy x0 y0 = do
  { m <- openMPEG m_file
  ; ims <- images m
  ; let bws = map colorToBW ims
        ref = grab' (w,h) (x0,y0) (head bws)
        pts = scanl (find2 ref) (x0,y0) bws
  ; let iss = 
	 [ ims
	 , map bwToColor $ zipWith (grab' (w,h)) pts bws
	 ]
  -- everything above here is image processing

  -- everything below here is display
  ; c <- openConsole True True 
  ; ws <- openWins c iss
  ; while (return True) $ do
    { prodWins ws
    }
  ; closeWins ws
  ; closeConsole c
  ; closeMPEG m
  }
 where
  (w,h) = (60,60)  -- size of image


interactive_init :: Console -> Image_RGB -> Int -> IO [((Double,Double), (Int,Int))]
interactive_init c i0 n = do 
  { w <- createWindow c
  ; openWindow w (size i0) "Select Object"
  ; ps <- mapem [1..n] (\_ -> get w i0)
  ; closeWindow w
  ; destroyWindow w
-- SSD seems to flip out on non-square images
--  ; return ((fromInt x0, fromInt y0), (x1-x0, y1-y0))
  ; return ps
  }
 where
  fudge = 4
  fix x = abs (fudge * (x `div` fudge))  -- hack: must be +ve and even
  get w i0 = do
    { ((x0,y0,_),(x1,y1,_)) <- getRegion w "Object" i0
--    ; return ((fromInt x0, fromInt y0), (fix(x1-x0), fix(y1-y0)))
    ; return ((fromInt x0, fromInt y0), (fix(x1-x0), fix(x1-x0))) -- hack - return square
    }

-- try to follow n images round the room
track fname n = do
  { c <- openConsole True True 
  ; m <- openMPEG fname

  ; i0 <- currentImage m
  ; regions <- interactive_init c i0 n

  ; ims <- images m
  ; display c $ 
      [ ims ] ++
      (map (\ r -> map bwToColor (track' r (map colorToBW ims))) regions)
  ; closeConsole c
  ; closeMPEG m
  }

-- try to follow n images round the room
track_live n = do
  { c <- openConsole True True 
  ; (m,_) <- openVideo videoDevice

  ; i0 <- imageVideo m ul lr (1,1) -- grab a few to init properly
  ; i0 <- imageVideo m ul lr (1,1)
  ; i0 <- imageVideo m ul lr (1,1)
  ; i0 <- imageVideo m ul lr (1,1)
  ; regions <- interactive_init c i0 n

  ; ims <- mkLazyList (imageVideo m ul lr (1,1))
  ; display c $ 
      --[ ims ] ++
      (map (\ r -> map bwToColor (track' r (map colorToBW ims))) regions)
      --(map (\ (p,sz) -> (map (grab' sz p) ims)) regions)
  ; closeConsole c
  ; closeVideo m
  }
 where
  ul = (160,120)
--  lr = (480,360)
--  ul = (0,0)
  lr = (320,240)
--  lr = (640,480)

-- this is like a little baby duck - it just follows the first thing
-- it sees.
duck = do
  { c <- openConsole True True 
  ; (m,_) <- openVideo videoDevice

  ; i0 <- imageVideo m ul lr (1,1) -- grab a few to init properly
  ; i0 <- imageVideo m ul lr (1,1)
  ; i0 <- imageVideo m ul lr (1,1)
  ; i0 <- imageVideo m ul lr (1,1)
  ; ~[(p,sz)] <- interactive_init c i0 1

  ; ref <- grabVideo m sz p
  ; let delta = ssd2 1 (colorToBW ref) . colorToBW

  ; robotConnect (Just 1) Nothing Nothing
  ; wait 1000000

  ; w <- createWindow c
  ; openWindow w (size ref) "Select Mommy"
  ; for p $ \ p0@(x,y) -> do
    { image <- grabVideo m sz p0
    ; showImage w image
    ; let (dx,dy) = delta image
    ; let r = 0.5 * move (x - 320)
    ; turn r
--    ; putChar '*'  -- hack to let me guesstimate frame rate
--    ; print (dx, dy)
--    ; print p0
--    ; print r
    ; return (x+dx,y+dy)
    }  
  ; closeWindow w
  ; destroyWindow w
  ; closeConsole c
  ; closeVideo m
  }
 where
  ul = (0,0)
  lr = (640,480)

  move x 
    | x >=  zone  = 1
    | x <= -zone  = -1
    | otherwise   = 0
  zone = 5

  turn r = do
    { t <- getTimeOfDay
    ; when ((t `div` 10000) `mod` 10 == 0) $ robotSetWheelVelocity (r) (-r)
    } 

grabVideo :: Video -> (Int,Int) -> (Double,Double) -> IO Image_RGB
grabVideo m (w,h) (x,y) = imageVideo m (round x,     round y) 
                                       (round x + w, round y + h)
                                       (1,1)

for :: (Monad m) => a -> (a -> m a) -> m ()
for x m = do { m x >>= \ x' -> for x' m }

----------------------------------------------------------------
-- SSD in xy and theta directions
----------------------------------------------------------------

{-

ToDo: don't like the use of [Double]!  Use Vector class instead?

ssd :: Int -> Image -> Image -> [Double]
ssd s r0 = 
   \ r -> let dR = compressxy (scale_r0 `minusImage` scale r)
	      dv = map (innerProduct dR) v
	      o = m * dv
	  in
	  map (fromInt s *) o
 where
  scale x = reduce_resolution (s,s) x

  scale_r0 = scale r0

  dX   = smoothDx scale_r0
  dY   = smoothDy scale_r0
  dT   = (dX `multImage` cY) - (dY `multImage` cX)

  -- must be odd sized for orientation
  assert (odd width && odd height)
  x  = width  / 2
  y  = height / 2
  cX = mkColumn [-x .. x]           * row (replicate height 1)
  cY = mkColumn (replicate width 1) * mkColumn [-y .. y] 

  v = [dX,dY,dT]
  m = inverse (v `cross` v)

improve :: Image -> Image -> [Double] -> [Double]
improve ref i (x,y) = (x + dx, y + dy)
 where
  (dx,dy) = ssd scl ref (grab (w,h) (round x, round y) i)

approxs :: Image -> Image -> [Double] -> [[Double]]
approxs ref i pos = iterate (improve ref i) pos

-- ToDo: make this work
-- residual = sum (sqr (Dt - M0)) / (width * height)



----------------------------------------------------------------
-- SSD in xy directions
----------------------------------------------------------------

ssd2 :: Int -> Image -> Image -> (Double,Double)
ssd2 s r0 = 
   \ r -> let dR = compressxy (fr0 `minusImage` f r)
	      dx = dR `innerProduct` dX
	      dy = dR `innerProduct` dY
	      ox = a*dx + b*dy
	      oy = c*dx + d*dy
	  in
	  (fromInt s * ox, fromInt s * oy)
 where
  f = reduce_resolution (s,s)

  fr0  = f r0

  dX   = smoothDx fr0
  dY   = smoothDy fr0

  dXdX = dX `innerProduct` dX
  dXdY = dX `innerProduct` dY
  dYdX = dY `innerProduct` dX
  dYdY = dY `innerProduct` dY

  (a,b,c,d) = inverse (dXdX, dXdY, dYdX, dYdY)

improve2 :: Image -> Image -> (Double,Double) -> (Double,Double)
improve2 ref i (x,y) = (x + dx, y + dy)
 where
  (dx,dy) = ssd2 scl ref (grab (size ref) (round x, round y) i)

approxs2 :: Image -> Image -> (Double,Double) -> [(Double,Double)]
approxs2 ref i pos = iterate (improve2 ref i) pos

-- find reference image in main image using ssd
-- ToDo: iterate until we converge
-- ToDo: ought to round its coordinates before it starts 
-- and round its final result - since that's the fundamental
-- accuracy of the image grabbing
-- ToDo: this definition loses sharing
find2 :: Image -> (Double,Double) -> Image -> (Double,Double)
find2 ref xy im = approxs2 ref im xy !! iters

track' :: ((Double,Double),(Int,Int)) -> [Image] -> [Image]
track' (p,sz) bws = zipWith (grab' sz) (track'' p sz bws) bws

track'' :: (Double,Double) -> (Int,Int) -> [Image] -> [(Double,Double)]
track'' pos sz bws = scanl (find2 ref) pos bws
 where
  ref = grab' sz pos (head bws)

----------------------------------------------------------------
-- SSD in x direction
----------------------------------------------------------------

ssd_x :: Int -> Image -> Image -> Double
ssd_x s r0 = \ r -> fromInt s * (compressx (fr0 `minusImage` f r) `innerProduct` dX) / dXdX
 where
  fr0  = f  r0
  dX   = dx fr0
  dXdX = dX `innerProduct` dX

  f x = reduce_resolution (s,s) x

x_improve :: Image -> Image -> (Double,Double) -> (Double,Double)
x_improve ref i (x,y) = (x + ssd_x scl ref (grab (size ref) (round x, round y) i), y)

x_approxs :: Image -> Image -> (Double,Double) -> [(Double,Double)]
x_approxs ref i pos = iterate (x_improve ref i) pos

----------------------------------------------------------------
-- Utilities
----------------------------------------------------------------

inverse :: (Double,Double,Double,Double) -> (Double,Double,Double,Double)
inverse (a,b,c,d) = (d/det, -c/det, -b/det, a/det)
 where
  det = a*d - b*c

grab (w,h) (x,y) i = subImage (x,y) (x+w,y+h) i

grab' (w,h) (x,y) i = subImage (round x,     round y) 
                               (round x + w, round y + h) i

compressxy :: Image -> Image
compressxy = compressx . compressy

cross :: [a] -> [b] -> [(a,b)]
cross as bs = [ (a,b) | a <- as, b <- bs ]

----------------------------------------------------------------
-- Lazy mpeg read
----------------------------------------------------------------

images :: Mpeg -> IO [Image_RGB]
images m = mkLazyList $ do
  { i <- currentImage m
  ; moveForward m
  ; return i
  }
-}
----------------------------------------------------------------
-- Wait for n micro seconds
----------------------------------------------------------------

--wait :: Integer -> IO ()
--wait n = do
--  { rds <- allocFdSet
--  ; fd_Zero rds
--  ; wds <- allocFdSet
--  ; fd_Zero wds
--  ; eds <- allocFdSet
--  ; fd_Zero eds
--  ; select rds wds eds n
--  ; freeFdSet rds
--  ; freeFdSet wds
--  ; freeFdSet eds
--  }

wait :: Integer -> IO ()
wait n | n > 0 = do
  { t1 <- getTimeOfDay 
  ; when (length [1..1000] /= 0) (return ())
  ; t2 <- getTimeOfDay 
  ; wait (n - abs (t2-t1))
  }
wait n = return ()

----------------------------------------------------------------
-- End
----------------------------------------------------------------
