----------------------------------------------------------------
-- SP test
----------------------------------------------------------------

module SPTest
	( module SPTest
	) where

import SP
import SSD

import XVision
import Prelude hiding(sum,or)

----------------------------------------------------------------
-- Clown
----------------------------------------------------------------

eye :: Video -> Sz -> Float -> Image_Int -> Image_Int -> SP Pos (Either Pos Pos, Error)
eye v sz s refa refb = ssdSP v sz s refa `best` ssdSP v sz s refb

eyes :: Video -> Sz -> Float -> Image_Int -> Image_Int -> SP Pos (Either Pos Pos, Error)
eyes = undefined

----------------------------------------------------------------
--
----------------------------------------------------------------

type Error = Double
type Pos = (Float,Float,Float)

-- Another useful operation would produce a weighted average
best :: SP a (b,Error) -> SP a (c,Error) -> SP a (Either b c, Error)
(f `best` g) = (f &&& g) >>> sp2 best'
 where
  best' (b,b') (c,c') = if b' < c' then (Left b,b') else (Right c,c')


ssdSP :: Video -> Sz -> Float -> Image_Int -> SP Pos (Pos, Error)
ssdSP v sz s ref0 = spIO1 ssd'
 where
  -- lifted out to share work of building matrix
  track = ssd ref0

  ssd' pos0 = do
    { pic <- grab v s sz pos0
    ; let (rawdelta, residual) = track pic
          delta = rotate' s pos0 rawdelta
    ; return (pos0 + delta, residual)
    }

edgeSP :: Video -> Sz -> SP Pos Offset
edgeSP v sz = statefulSP (mkEdgeTracker 1 0) step
 where
  step e pos = do
    { pic <- grab v 1 sz pos
    ; find_EdgeTracker e pic 
    }

-- -- a line through a position stretching to infinity in either direction
-- type InfLine = (Position,Angle)
-- 
-- edge :: Position -> Tracker InfLine
-- edge down_pose = ...
-- 
-- -- combine two line trackers into a position tracker
-- intersect :: Tracker InfLine -> Tracker InfLine -> Tracker Position
-- intersect t1 t2 down_posn = up_posn
--  where
--   line1 = t1 down1
--   line2 = t2 down2
--   up_posn = lift2 line_intersection line1 line2
--   down1 = lift2 combine_somehow line1 down_posn
--   down2 = lift2 combine_somehow line2 down_posn

----------------------------------------------------------------
-- End
----------------------------------------------------------------