
module Init(
             interactiveInitPoint2 -- Console -> Video -> String -> IO Point2
           , interactiveInitRect   -- Console -> Video -> String
                                   --      -> IO (Point2, Size)
           , interactiveInitBox    -- Console -> Video -> String -> IO Box
           ) where

import XVTypes
import Geometry
import XVUtilities( mapem )
import XVision(get_pos, get_region)
import Window
import Video

-- Interactive init and friends ....


interactiveInitPoint2 :: Console -> Video -> String -> IO Point2
interactiveInitPoint2 c v title = do 
   w <- createWindow c
   ps <- get_pos w v title
   closeWindow w
   destroyWindow w
   return (iPointToPoint2 ps)
  
interactiveInitRect :: Console -> Video -> String -> IO (Point2, Size)
interactiveInitRect c v title = do 
  w <- createWindow c
  openWindow w (sizeOf v) title
  (pt,sz) <- get_region w v title
  closeWindow w
  destroyWindow w
  return (iPointToPoint2 pt, toSize sz)


interactiveInitBox :: Console -> Video -> String -> IO Box
interactiveInitBox c v title =
  do 
   w <- createWindow c
   openWindow w (sizeOf v) title
   ~[p1,p2,p3,p4] <- mapem [1..4] $ \c -> do
       pt <- get_pos w v ("Select Corner " ++ show c)
       return (iPointToPoint2 pt)
   closeWindow w
   destroyWindow w
   return (p1,p2,p3,p4)


