module Draw
	( drawBox
        , drawCircle
        , drawColorCircle
        , drawDisk
        , drawColorDisk
	, drawLineSegment
	, drawIntersection
	, drawImage
	) where

import XVision as XV
import Geometry
import XVTypes

----------------------------------------------------------------
-- Exports
----------------------------------------------------------------

drawBox          :: Window -> Box             -> IO ()
drawLineSegment  :: Window -> LineSegment2    -> IO ()
drawIntersection :: Window -> Intersection    -> IO ()
drawCircle       :: Window -> Circle          -> IO ()
drawColorCircle  :: Window -> Circle -> Color -> IO ()
drawImage        :: Window -> ImageInt        -> IO ()

----------------------------------------------------------------
-- Implementation
----------------------------------------------------------------

drawBox w (a,b,c,d) = do
  { XV.lineW w (point2ToIPoint a) (point2ToIPoint b)
  ; XV.lineW w (point2ToIPoint b) (point2ToIPoint c)
  ; XV.lineW w (point2ToIPoint c) (point2ToIPoint d)
  ; XV.lineW w (point2ToIPoint d) (point2ToIPoint a)
  }

drawLineSegment w l =
   XV.lineW w (point2ToIPoint (end1 l)) (point2ToIPoint (end2 l))

drawIntersection w (pt,v1,v2) = do
  { drawLineSegment w (mkSegment2PV pt v1)
  ; drawLineSegment w (mkSegment2PV pt v2)
  }

-- Not filled
drawCircle w (center,rad) = XV.circleW w (round rad) (point2ToIPoint center)
drawColorCircle w (center,rad) color  = 
   XV.circleWc w (round rad) (point2ToIPoint center) color

-- filled
drawDisk w (center,rad) = XV.diskW w (round rad) (point2ToIPoint center)
drawColorDisk w (center,rad) color  = 
   XV.diskWc w (round rad) (point2ToIPoint center) color

drawImage w i = XV.showImage w (XV.bwToColorImage i)

clearWindow = clearW

----------------------------------------------------------------
-- End
----------------------------------------------------------------

