----------------------------------------------------------------
--
----------------------------------------------------------------

module ClownFace
	( module ClownFace
	) where

import Draw( drawIntersection, drawImage, drawBox )
import XVision as XV hiding (sum)
import qualified Intersect
import qualified Edge
import SP
import Pipe
import Geometry
import Overload(size)
import XVUtilities( mapem )
import qualified Box

import Video
----------------------------------------------------------------

width = 20
videoDevice = "MPEG"

----------------------------------------------------------------
-- Clown face types
----------------------------------------------------------------

type Clown = (Mouth,Eyes)
type Eyes  = (Eye,Eye)
type Mouth = (Bool,Pt)
type Eye   = (Bool,Pt)

type EyeRaw = (Bool,Pt,Angle)

-- types used to carry initialising data
type Best a    = (a,a)  -- a good one and a bad one
type Comp2 a b = (a,b)  -- a left one and a right one

----------------------------------------------------------------
-- Clown face tracker
----------------------------------------------------------------

trackClown :: Video -> Comp2 (Best Image) (Comp2 (Best Image) (Best Image) -> Tracker Clown
trackClown v (m,es) = Tracker.composite2 split join (trackMouth v m) (trackEyes v es)
 where
  split (mouth,eyes) = (mouth,eyes)   -- kinda trivial!
  join  (mouth,eyes) = (mouth,eyes)

trackEyes :: Video -> Comp2 (Best Image) (Best Image) -> Tracker Eyes
trackEyes v (l,r) = Tracker.composite2 split (trackEye v l) (trackEye v r)
 where
  split (eye1,eye2)  = ?? take angle into account
  join  (left,right) = ?? take angle into account

trackMouth :: Video -> Best Image -> Tracker Mouth 
trackMouth v (m1,m2) = Tracker.best (region v m1) (region v m2)

trackEye :: Video -> Best Image -> Tracker EyeRaw 
trackEye v (e1,e2) = Tracker.best (region v e1) (region v e2)

----------------------------------------------------------------
-- Clown face draw function
----------------------------------------------------------------

drawClown :: Animation Clown
drawClown = Animation.composite2 split drawMouth drawEyes
 where
  split (mouth,eyes) = (mouth,eyes)   -- kinda trivial!

drawEyes :: Animation Eyes
drawEyes = Animation.composite2 split drawEye drawEye
 where
  split (eye1,eye2) = ?? take angle into account

drawMouth :: Animation Mouth 
drawMouth = best drawOpenMouth drawClosedMouth

drawEye :: Animation EyeRaw 
drawEye = Animation.best drawOpenEye drawClosedEye

----------------------------------------------------------------
-- Clown face test harness
----------------------------------------------------------------

test = do
  { c <- openConsole False False --True True
  ; (v,_) <- openVideo videoDevice
  ; w <- createWindow c
  ; openWindow w (size v) "Tracking"

  -- not right
  ; let clown0 = ???
  ; runSP (draw w v) clown0 (trackClown v)
  }
 where

  -- very wrong
  draw w v c = do
   { im <- XV.imageVideo v (0,0) (size v) (1,1)
   ; drawImage w (XV.colorToBW im)
   ; drawClown w c
   ; forwardVideo v   -- for MPEG device
   }

----------------------------------------------------------------
-- End
----------------------------------------------------------------
