module Bounce
	( module Bounce
	) where

import Pipe
import IOExts
import XVision
import Prelude hiding(sum,or)
import Monad
import Maybe
import Overload
import XVUtilities

infixr 9 `or`

----------------------------------------------------------------
-- The main program
----------------------------------------------------------------

--device = "MPEG"
device = "METEOR_MONO"

bounce colour = do
  { c <- openConsole True True
  ; (v,_) <- openVideo device
  ; w <- createWindow c
  ; openWindow w (size v) "Bounce"
  ; let radius = 10  -- radius of ball
        sz     = (radius + 5, radius + 5)
        pos0   = (100,100)
        delta0 = (radius,0)
  ; runPipe
      $ let
          posn  = integral pos0 delta
          delta = delay delta0 (    lift1 (bounds (size v)) posn
                               `or` lift1 (move colour) image
                               `or` delta
                               )
          image = grabSquare v sz posn

          video = liftIO0 $ grab v (0,0) (size v)
          draw  = lift1 (showImage w) video 
        in
          --ptrace posn $ 
          --ptrace (lift1 (centroid colour) image) $
          lift2 (>>) (window c (sz + sz) "image" image) $
          lift2 (>>) draw $
          ball w radius posn
  }

move :: (HSI,HSI) -> Image_RGB -> Maybe Point
move col i
  | strength > 0.25 = Just (-c `scale'` 4)
  | otherwise       = Nothing
 where
  (c,strength) = centroid col i

bounds :: Sz -> Point -> Maybe Point
bounds (w,h) (x,y) 
  | x < 0     = Just (10,0)
  | y < 0     = Just (0,10)
  | x > w     = Just (-10,0)
  | y > h     = Just (0,-10)
  | otherwise = Nothing

-- not sure this is the right name for it
or :: Pipe (Maybe a) -> Pipe a -> Pipe a
or l r = lift2 fromMaybe r l

(x,y) `scale'` s = (x*s,y*s)

----------------------------------------------------------------
-- Colours
----------------------------------------------------------------

red :: (HSI,HSI)
red = ((340,120,0),(20,1000,250))

blue :: (HSI,HSI)
blue = ((220,120,0),(260,1000,250))

green :: (HSI,HSI)
green = ((100,120,0),(140,1000,250))

black :: (HSI,HSI)
black = ((0,0,0),(360,100000,100))

----------------------------------------------------------------
-- Video ops
----------------------------------------------------------------

ball :: Window -> Int -> Pipe Point -> Pipe (IO ())
ball w r = lift1 (circleW w r)

grabSquare :: Video -> Sz -> Pipe Point -> Pipe Image_RGB
grabSquare v sz = liftIO1 (\ p -> grab v (p - sz) (p + sz))

grab :: Video -> Point -> Point -> IO Image_RGB
grab v p1 p2 = imageVideo v p1 p2 (1,1)

----------------------------------------------------------------
-- End
----------------------------------------------------------------


