#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <math.h>
#include <rate.hh>
#include <site_config.h>
#include <XConsole.hh>
#include <XWindow.hh>
#include <sys/time.h>
#include <signal.h>
#include "big_window.h"



static XConsole c(0);
static XWindow *w;
static int xloc, yloc, xoff, yoff;
static int xlb,xub;
static int ylb,yub;

static int width = XWWIDTH, height = XWHEIGHT;
static int active = 0;

int inbounds()
{
  return 
    (xloc < xub) &&
    (xloc > xlb) &&
    (yloc < yub) &&
    (yloc > ylb);
}

void sigrun(int)
{
  if (active) {
    if (inbounds()) {
      pen(xloc+ xoff,yloc+ yoff);
    }
    else {
      active =0;
    }
  }
}

void pen(int x ,int y)
{
  w->circle(xloc,yloc,11,0);	
  xloc = x;
  yloc = y;
  w->circle(xloc,yloc,10);
  w->flush();
}
  
void movexy(int nx,int ny,
	    int lx,int ux,
	    int ly, int uy)
{

  xlb = lx;
  ylb = ly;
  xub = ux;
  yub = uy;
  xoff = nx; yoff = ny;
  pen(xloc + xoff, yloc+yoff);
  active = 1;
}

int finished()
{
  return (!active);
}

static struct sigaction sigact;

void init_window()
{
   w = new XWindow(c);
  struct itimerval setup; 
  struct timeval interval;

  /* Get everything set */

  w->open(width,height,"XVision Display");
  w->clear();

  xloc = width/2;
  yloc = height/2;

  /* set up the timer to do its thing. */
  //#define W_TIME
#ifdef W_TIME
  interval.tv_sec = 0;
  interval.tv_usec = 1000;

  setup.it_interval = interval;
  setup.it_value = interval;

  //  signal(SIGALRM,sigrun);

  sigact.sa_handler = sigrun;
  sigact.sa_flags = SA_RESTART;
  sigact.sa_restorer = 0;
  sigemptyset(&sigact.sa_mask);
  sigaddset(&sigact.sa_mask, SIGALRM);
  
  if (sigaction(SIGALRM, &sigact, NULL) ) {
    perror("sigaction failed");
    exit(1);
  }
   
  setitimer(ITIMER_REAL,&setup,NULL);
#endif
}
#ifdef 0
int
main(int argc, char *argv[]) {

  moveright(1,width);
  moveleft(1,0);
  moveright(1,width/2);
  moveup(1,height);
  movedown(1,0);
  
  //* technically, this will never happen, but we put it here anyway, 
  //* to show you how to get rid of windows if you want to be "clean" about it.

  w->close();
};






#endif
