/*
    Copyright (C) 1995 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
#include "Tracker.hh"
#include "XConsole.hh"
#include "Devices.hh"
#include "oldSSD.hh"
#include "SSD.hh"

#define SSD oldSSD

#ifndef K_ITERS
#define K_ITERS 2
#endif

#define ITERATIONS (1000*K_ITERS)

extern "C" {
#include <time.h>
}

#include <unistd.h>

void timeit(SSD &s,SSD &templ)
{

  int i;
  clock_t t, endt;

  s.state_init(templ.x(),templ.y());

  t = clock();

  for (i=0;i<ITERATIONS;i++) {
    s.set_state(templ);
    s.update();
  }

  endt = clock();

  cout << (((double) ((int)endt - (int)t))/CLOCKS_PER_SEC)/K_ITERS <<
    "ms." << endl;


}

main(int argc, char *argv[]) 
{
  Video *v = new DEFAULT_DECLARATION;
  v->set_grab_type(PIX_LUMINANCE);

  int width = 40, height = 40, reduction = 2;

  if (argc > 1) 
    width = height = atoi(argv[1]);

  if (argc > 2)
    height = atoi(argv[2]);

  if (argc > 3)
    reduction = atoi(argv[3]);

  SSD s(v,width,height,reduction),t(v,width,height,reduction);

  t.state_init(240,240);

  //  Log what we're doing

  cout << "SSDtiming: Width = " << width << " Height = " << height << " reduction = " 
    << reduction << endl << endl;

  // First, the raw thing

  cout << "Basic SSD with aligned images: ";

  timeit(s,t);

  // Now, scramble scale and rotation

  cout << endl << "Basic SSD with scaled and rotated images: " ;

  t.set_scale(.98);
  t.set_orientation(0.1);

  timeit(s,t);

  // Now, do rotation;

  s.compute_rotation();
  t.set_scale(1.00);
  t.set_orientation(0.1);

  cout << endl << "SSD with rotation: " ;

  timeit(s,t);

  // Now, do scale

  s.compute_rotation(0);
  s.compute_aspect_ratio();
  t.set_orientation(0.0);
  t.set_scale(.98);

  cout << endl << "SSD with scale: " ;

  timeit(s,t);


  // Now do them all

  s.compute_rotation();
  s.compute_aspect_ratio();
  t.set_orientation(.1);
  t.set_scale(0.98);

  cout << endl << "Doing everything: " ;

  timeit(s,t);


}




