/*
    Copyright (C) 1995 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
#include "Tracker.hh"
#include "XConsole.hh"
#include "Devices.hh"
#include "Image.hh"

#ifndef K_ITERS
#define K_ITERS 100
#endif

#define ITERATIONS (1000*K_ITERS)

extern "C" {
#include <time.h>
}

#include <unistd.h>
#include <stdlib.h>

void timeit(Image &im,Video &v,float *statevec)
{

  int i;
  clock_t t, endt;

  t = clock();

  for (i=0;i<ITERATIONS;i++) {
    v.grab(im,statevec[0],statevec[1],statevec[3],statevec[2]);
  }

  endt = clock();

  cout << (((double) ((int)endt - (int)t))/CLOCKS_PER_SEC)/K_ITERS <<
    "ms." << endl;

}

main(int argc, char *argv[]) 
{
  Video *v = new DEFAULT_DECLARATION;

  int height = 40, width = 40, sampling = 1;
  float statevec[4] = {200,200,1,0.0};

  if (argc > 1) 
    height = atoi(argv[1]);

  if (argc > 2)
    width = atoi(argv[2]);

  if (argc > 3) {
    statevec[2] = atoi(argv[3]);
  }

  Image i(width,height);

  //  Log what we're doing

  cout << "GrabImage: " <<
    " Width = " << width << " Height = " << height << " sampling = " 
    << statevec[2] << endl << endl;

  // First, the raw thing

  cout << "Image aligned: ";

  timeit(i,*v,statevec);

  statevec[3] = 0.5;

  cout << "Image nonaligned: "; 

  timeit(i,*v,statevec);

  exit(1);
}




