/*
    Copyright (C) 1995 Gregory D. Hager (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
#include "Tracker.hh"
#include "XConsole.hh"
#include "Devices.hh"
#include "Blob.hh"

#ifndef K_ITERS
#define K_ITERS 10
#endif

#define ITERATIONS (1000*K_ITERS)


extern "C" {
#include <time.h>
}

#include <unistd.h>
#include <stdlib.h>

void timeit(Blob &s,float *statevec)
{

  int i;
  clock_t t, endt;

  s.state_init(statevec);

  t = clock();

  for (i=0;i<ITERATIONS;i++) {
    s.set_x(statevec[0]);
    s.set_y(statevec[1]);
    s.update();
  }

  endt = clock();


  cout << (((double) ((int)endt - (int)t))/CLOCKS_PER_SEC)/K_ITERS <<
    "ms." << endl;

}

main(int argc, char *argv[]) 
{
  Video *v = new DEFAULT_DECLARATION;
  v->set_grab_type(PIX_LUMINANCE);


  int length = 40, width = 20, sampling = 1;

  if (argc > 1) 
    length = atoi(argv[1]);

  if (argc > 2)
    width = atoi(argv[2]);

  if (argc > 3)
    sampling = atoi(argv[3]);

  float statevec[3] = {200,200,0.0};

  Blob s(v,length,width,1);

  //  Log what we're doing

  cout << "Blobtiming: Width = " << width << " Length = " << length << " sampling = " 
    << sampling << endl<<endl;

  // First, the raw thing

  cout << "Basic Blob aligned: ";
  timeit(s,statevec);


}




