
/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
/* This is the Generalized Intersection Class
 * derived from Multitrack class and using the Line Class
 *
 * G. Hager  5/13/93
 */

#ifndef PLINES_H
#define PLINES_H

#include <math.h>
#include "Line.hh"
#include "CompFeature.hh"

extern "C" void sincos(double,double *,double *);


//======================== PLINES Class =========================



class PLines : public CompFeature, public LineFeature
{

private:
  
  LineSegment *line1, *line2;   // For convenience.

protected:

  LineSegment *lchild(int n) {return ptr_cast(LineSegment,child(n));};

public:

  // avoid using these two, use set_state
  float set_x(float xin)      {return state[0] = xin;};
  float set_y(float yin)      {return state[1] = yin;};
  float set_orientation(float ain) {return state[2] = ain;}
  float set_abstand(float ain) {return state[3] = ain;}

  PLines(LineSegment &l1, LineSegment &l2, Color color_in = default_color);
  PLines(Pattern *e, Video *v, 
	 int size = line_length, int sampling = 1, Color color_in = default_color);

  PLines(PLines &g) : CompFeature(g), LineFeature(this) {
    line1 = lchild(0);
    line2 = lchild(1);
  }

  ~PLines() {};

  virtual Thing *dup() {return new PLines (*this); };

  // state accessors

  float x() const {return state[0];};
  float y() const {return state[1];};
  float orientation() const {return state[2];};
  float abstand() const {return state[3];}

  LineSegment *Line1() {return line1;}
  LineSegment *Line2() {return line2;};

  int set_state(float x, float y, float o, float a);
  int set_state(int x, int y, float o, float a) {
	return set_state( (float)x, (float)y, o, a);
  }

  void move(float offx, float offy);
  int constraints();
  int compute_state();

  int interactive_init (CWindow &w);
  //  int interactive_init (CWindow &w, int direction, int rl);
  //  int search_init (int direction, int rl);

};

#endif
