/*
    Copyright (C) 1991 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
//-----------------------------------------------------------------------------
//
//  Pline.cc
//
//  Definition of Pline member functions.
//
//  9 - 1 - 93
//  Greg Hager
//
//-----------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include "PLine.hh"

PLines::PLines(LineSegment &l1, LineSegment &l2, Color color_in) : 
	       CompFeature(4,"PLines",color_in), LineFeature(this)
    {

      (*this) += l1;
      l2.set_orientation(l2.orientation());
      (*this) += l2;

      line1 = lchild(0);
      line2 = lchild(1);
      
    }

PLines::PLines(Pattern *e, Video *v, int size, 
	       int sampling, Color color_in) :
        CompFeature(4,"PLines",color_in), LineFeature(this)
{

      Line *ltemp = new Line(e,v,size);
      ltemp->length_sampling() = sampling;
      (*this) += *ltemp;
      ltemp->set_orientation(ltemp->orientation());
      (*this) += *ltemp;

      line1 = lchild(0);
      line2 = lchild(1);
    }

/*int PLines::interactive_init (CWindow &w, int direction, int rl) {

    cout<<"interactive_init: direction= "<<direction<<"(1 for forward)"<<endl;
    cout<<"                  turn     = "<<rl       <<"(1 for right)"  <<endl;

    (*line1)->interactive_init(w);
    return search_init(direction,rl);
  };
  */
int PLines::interactive_init (CWindow &w) {
    double ang;

    (*(*line1)).interactive_init(w);

    line2->set_orientation(line1->orientation());
    (*(*line2)).interactive_init(w);

    return compute_state();
  }

/*int PLines::search_init (int direction, int rl) {

  int count = 0;
  Line *lline1,*lline2;

  if ((lline1 = ptr_cast(Line,line1)) == NULL)
    panic("Cannot cast Line Segment as Line in search_init");

  if ((lline2 = ptr_cast(Line,line2)) == NULL)
    panic("Cannot cast Line Segment as Line in search_init");

  // flip orientation of line1 if direction  == 1
  // line moves BACKWARD to search.
  if (direction>0)
      lline1->set_orientation( lline1->orientation() + M_PI );

  double o1 = lline1->orientation();
  // right is positive
  lline2->set_orientation( o1 - signum(rl) * M_PI_2);
  double o2 = lline2->orientation();

  lline2->set_x(lline1->x() - cos(o1)*setpoint[0] + cos(o2)*setpoint[1]);
  lline2->set_y(lline1->y() - sin(o1)*setpoint[0] + sin(o2)*setpoint[1]);

  update();

  while ((fabs((lline1->strength() - lline2->strength())/
	       lline1->strength()) > 0.5) && count < 1000) {
      count ++;
      // line moves BACKWARD to search.
      move(-cos(lline1->orientation())*lline2->width()/6,
	   -sin(lline1->orientation())*lline2->width()/6);

      lline2->set_orientation(o1 - signum(rl) * M_PI_2);
      o2 = lline2->orientation();
      lline1->update();
      lline1->show();
      lline2->update();
      lline1->clear();
      compute_state();
      constraints();
    }
  //return (count < 1000);
  //cout<<"search_init: count="<<count<<endl;
  return count<1000;

}
*/
int PLines::set_state(float x, float y, float o, float a)
{

  set_x(x);
  set_y(y);
  set_orientation(o);
  set_abstand(a);
  return constraints();

}

void PLines::move(float offx, float offy) {
  set_state(x() + offx,y() + offy, orientation(), abstand() );
}
  
void sincos(double ang,double *s, double *c){
  *s = sin(ang);*c = cos(ang);
}

int PLines::compute_state()
{
  //  cout << "state " << *(this->line1) << endl;
  //  cout << "state " << *(this->line2) << endl;
  set_orientation((line1->orientation() + line2->orientation())/2.0);
  set_x((line1->x() + line2->x())/2.0);
  set_y((line1->y() + line2->y())/2.0);
  //  cout << set_abstand((x() - line1->x())*sin(orientation()) - 
  //		      (y() - line1->y())*cos(orientation())) << endl;

  //  cout << "after state " << *this <<endl;
  return 1;
}

int PLines::constraints()
{

  //  cout << "Before const " << *this << endl;
  float dist = -((x() - line1->x())*cos(orientation()) + 
		 (y() - line1->y())*sin(orientation()));

  // Orientations are easy. 

  float o =  line1->set_orientation(orientation());
  line2->set_orientation(orientation());

  // Positions aren't too much harder

  line1->set_x(x() + dist * cos(o));
  line1->set_y(y() + dist * sin(o));

  line2->set_x(x() - dist * cos(o));
  line2->set_y(y() - dist * sin(o));

  //  cout << "After const " << *(this->line1) << endl;
  //  cout << "After const " << *(this->line2) << endl;

  return 1;
}


