
/*                                                                -*-c++-*-
    Copyright (C) 1993 Gregory D. Hager and Sidd Puri (Yale
    Computer Science Robotics and Vision Laboratory)

    Permission is granted to any individual or institution to use, copy, 
    modify, and distribute this software, provided that this complete 
    copyright and permission notice is maintained, intact, in all copies 
    and supporting documentation.  Authors of papers that describe software 
    systems using this software package are asked to acknowledge such use
    by a brief statement in the paper.

    Gregory D. Hager provides this software "as is" without express or
    implied warranty.

*/
/* This is the Generalized Intersection Class
 * derived from Multitrack class and using the Line Class
 *
 * G. Hager  5/13/93
 */

#ifndef PLINES_H
#define PLINES_H

#include <math.h>
#include "Line.hh"
#include "CompFeature.hh"
#include "IntersectingLines.hh"

extern "C" void sincos(double,double *,double *);


//======================== PLINES Class =========================



class PLines : public CompFeature, public LineFeature
{

private:
  
  LineSegment *line1, *line2;   // For convenience.

protected:

  LineSegment *lchild(int n) {return ptr_cast(LineSegment,child(n));};

public:

  // avoid using these two, use set_state
  float set_x(float xin)      {float t= state[0] = xin;constraints();return t;}
  float set_y(float yin)      {float t= state[1] = yin;constraints();return t;}
  float set_orientation(float ain) {float t= state[2] = ain;constraints(); return t;}
  float set_abstand(float abstin) {float t= state[3] = ain;constraints();return t;}

  Plines(LineSegment &l1, float s1, LineSegment &l2, float s2, Color color_in = default_color);
  Plines(Pattern *e, Video *v, float s1, float s2, 
	 int size = line_length, int sampling = 1, Color color_in = default_color);

  Plines(Plines &g) : CompFeature(g), LineFeature(this) {
    line1 = lchild(0);
    line2 = lchild(1);
  }

  ~Plines() {};

  virtual Thing *dup() {return new Plines (*this); };

  // state accessors

  float x() const {return state[0];};
  float y() const {return state[1];};
  float orientation() const {return state[2];};
  float abstand() const {return state[3];}

  LineSegment *Line1() {return line1;}
  LineSegment *Line2() {return line2;};

  int set_state(float x, float y, float o, float a);
  int set_state(int x, int y, float o, float a) {
	return set_state( (float)x, (float)y, o, a);
  }

  void move(float offx, float offy);
  int constraints();
  int compute_state();

  int interactive_init (CWindow &w);
  int interactive_init (CWindow &w, int direction, int rl);
  int search_init (int direction, int rl);

};

