#include <stdio.h>
#include <stdlib.h>
#include <site_config.h>
#include <Devices.hh>
#include "deviceparse.hh"


//* this precompiles constructors so that 
//* one can use argument parsing to create Device interfaces 
//* for device types that may vary from system to system.
//* when the user configures the system according to 
//* their specifications in "site_config.h", this
//* file will compile to fill in appropriate error 
//* messages or constructors. 
Video* make_device(int *is_color_device, char *arg)
{
  if (strcmp(arg, "K2T_MONO") == 0) {	
    //* preprocessor directives generate either this code...
#ifndef USE_K2T_MONO
	cerr << "You have tried to use device 'K2T_V300_Mono' but have not compiled to use this device.   Have a look at the USE_K2T_MONO flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	return new K2T_V300_Mono;		
#endif
      };

      if (strcmp(arg, "K2T_COLOR") == 0) {
#ifndef USE_K2T_COLOR
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'K2T_V300_Color' but have not set compile flags to use this device.  Have a look at the USE_K2T_COLOR flag andrecompile." << endl;
	exit(-1);
#else	
	//* ...or this code
	*is_color_device = 1;
	return new K2T_V300_Color;
#endif
      };

      if (strcmp(arg, "INDYCAM_MONO") == 0) {
#ifndef USE_INDYCAM_MONO
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'IndyCam_Mono' but have not compiled to use this device.  Have a look at the USE_INDYCAM_MONO  flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	return new IndyCam_Mono;
#endif
      };

      if (strcmp(arg, "INDYCAM_COLOR") == 0) {
#ifndef USE_INDYCAM_COLOR
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'Indycam_Color' but have not compiled to use this device.  Have a look at the USE_INDYCAM_COLOR  flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	*is_color_device = 1;
	return new IndyCam_Color();
#endif	
      };
      
#ifdef IT_FG101_MONO_SOLARIS
#define USE_IT_FG101
#else
#ifdef IT_FG101_MONO_SUNOS
#define USE_IT_FG101    
#endif
#endif
 
      if (strcmp(arg, "IT_FG101") == 0) {
#ifndef USE_IT_FG101
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'IT_FG101' but have not compiled to use this device.  Have a look at the USE_IT_FG101  flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	return new IT_FG101(0,0);
#endif	
      };

      if (strcmp(arg, "METEOR_COLOR24") == 0) {
#ifndef USE_METEOR
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'Meteor' but have not compiled to use this device.  Have a look at the USE_INDYCAM_COLOR  flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	*is_color_device = 1;
	return new Meteor(4,192,144);
	//	return new Meteor(4);
#endif	
      };


      if (strcmp(arg, "METEOR_COLOR16") == 0) {
#ifndef USE_METEOR
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'Meteor' but have not compiled to use this device.  Have a look at the USE_INDYCAM_COLOR  flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	*is_color_device = 1;
	return new Meteor(2);
#endif	
      };

      if (strcmp(arg, "METEOR_MONO") == 0) {
#ifndef USE_METEOR
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'Meteor' but have not compiled to use this device.  Have a look at the USE_INDYCAM_COLOR  flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	return new Meteor(1);
#endif	
      };

      if (strcmp(arg, "DT3155") == 0) {
#ifndef USE_DT3155
	//* preprocessor directives generate either this code...
	cerr << "You have tried to use device 'DT3155' but have not compiled to use this device.  Have a look at the USE_INDYCAM_COLOR  flag and recompile." << endl;
	exit(-1);
#else
	//* ...or this code
	*is_color_device = 1;
	return new DT3155();
#endif	
      };
      
      return (Video*)NULL;
}

