# The sed script below attempts to make the depend output portable.
# It cleans up the dependency information generated by cpp.
# It replaces instances of $(srcdir)/ by the string '$(srcdir)/'.
# It removes remain absolute files names (such as /usr/include/stdio.h).
# It the removes lines containing only "\\".
# The awk script removes a continuation marker that is followed by
# a blank line, since that may confuse make.

    sed -e 's|$(srcdir)/|$$(srcdir)/|g' \
        -e 's| /[^ ]*[.]hh*||g' \
        -e 's| /[^ ]*[.]cci||g' \
        -e '/^[   ]*\\$$/d' -e 's/^[      ]*$$//' \
  | awk 'BEGIN   { prev = "" } \
	/:$/ {next;} \
        /^( )*$$/ { if (prev ~ /\\$$/) \
                        { prev = substr(prev,1,length(prev)-1); next } } \
                     { print prev; prev = $$0 } \
          END { if (prev !~ /^( )*$$/) print prev }'
