#include "PipeModules1.hh"
#include <stream.h>

static int cnt = 0;
int Prand()
{
  return cnt++;
}

int add(const int &x, const int &y)
{
  return x + y;
}

main()

{
  PipeModuleLift0<int>           randP(Prand);
  PipeModuleLift2<int, int, int> addP(add);

  // Here's one version of adding

  PipeModule<int> &adderpipe =   addP(randP(),randP());

  // Here's a different version

  PipeModule<int> &input = randP();
  PipeModule<int> &doublerpipe = addP(input,input);

  // Let's try lifting a constant -- causes trouble!!

  PipeModule<int> add3pipe =   addP(randP(),3);

  int i = 0;

  while (1) {
    cout << adderpipe.get_value(i) << " " <<
         doublerpipe.get_value(i) << endl;
    i++;
  }
}

