#define MAX_INPUTS 10

// PipeModuleBase is a generic pipe upon which
// all generic updating functions are defined.  We
// need this in order to be able to store the graph.

class PipeModuleBase {

protected:

  // For bookeeping what data has passed through

  int frame_count;

  // For storing the graph

  int input_count;
  PipeModuleBase *previous[MAX_INPUTS];

  // Basic setup

public:

  PipeModuleBase() {frame_count = input_count = 0;};

  void add_prec(PipeModuleBase *x) {
    previous[input_count] = x;
    input_count++;
  };
};


// PipeModule is a basic typed unit of storage

template <class Tout>
class PipeModule : public PipeModuleBase{

  Tout value;

  // This'll be filled in later when we lift things
  // For now, its a placeholder for constants

  virtual Tout compute_local_fn(int) {return value;};

  // This is the generic updating algorithm ...

protected:
  
  void *fn;

public:

  PipeModule(void *fnin) : PipeModuleBase(), fn(fnin) {};
  PipeModule(Tout x) : PipeModuleBase() {value = x;};

  virtual Tout get_value(int fcin) {

    if (fcin > frame_count) {
      value = compute_local_fn(fcin);
      frame_count = fcin;
    }

    return value;
  }

};

// The remainder of these are "lifting" operations
// on functions

template <class Tout>
class PipeModuleLift0: public PipeModule<Tout> {
  
typedef  Tout (*fnT)();

public:

  PipeModuleLift0(Tout (*fnin)()): PipeModule<Tout>(fn) {};

  PipeModuleLift0 &operator () ()
    {
      return *(new PipeModuleLift0((fnT)fn));
    }

  Tout compute_local_fn(int fc) 
    {
      Tout (*fnl)() =	(Tout (*)())fn;
      (*((fnT)fn))();
    };
};

template <class Tin,class Tout>
class PipeModuleLift1: public PipeModule<Tout> {
  
  //  Tout (*fn)(const Tin&);   

public:

  PipeModuleLift1(Tout (*fnin)(const Tin&)): fn(fnin) {};

  PipeModuleLift1 &operator () (const PipeModule<Tin> &x)  
    {
      PipeModuleLift1<Tin, Tout> *temp = new PipeModuleLift1<Tin, Tout>(fn);
      temp -> add_prec(&x);
      return *temp;
    }

  Tout compute_local_fn(int fc) 
    {
      Tout (*fnl)(const Tin&) =	(Tout (*)(const Tin&))fn;

      return fnl(((PipeModule<Tin> *)previous[0])->get_value(fc));
    }
};


template <class Tin1, class Tin2, class Tout>
class PipeModuleLift2: public PipeModule<Tout> {
  
typedef  Tout (*fnT)(const Tin1&, const Tin2&);   

public:

  PipeModuleLift2(Tout (*fnin)(const Tin1&, const Tin2&)): 
    PipeModule<Tout>((void *)fnin) {};

  PipeModuleLift2 &operator () (PipeModule<Tin1> &x, 
			        PipeModule<Tin2> &y)  
    {
      PipeModuleLift2<Tin1, Tin2, Tout> *temp =
	new PipeModuleLift2<Tin1, Tin2, Tout> ((fnT)fn);
      temp->add_prec(&x);
      temp->add_prec(&y);
      return *temp;
    }

  Tout compute_local_fn(int fc) 
    {
      Tout (*fnl)(const Tin1&, const Tin2&) =
	(Tout (*)(const Tin1&, const Tin2&))fn;

      return fnl(((PipeModule<Tin1> *)previous[0])->get_value(fc),
		((PipeModule<Tin2> *)previous[1])->get_value(fc));
    }
};


#ifdef BLBL

OpenInputs(inp1) = Integrate(Init,Pipe)
OpenInputs(inp2) = Integrate(Init,Pipe)

PipeModule  operator = (class Input<T> x, class PipeModule<T> y) {
  x.connect(y);
};

#endif

