#include "Tracker.hh"
#include "XConsole.hh"
#include "Devices.hh"
#include "GlobalVelocity.hh"
#include "SSD.hh"
#include <time.h>
#include <stdlib.h>
#include <fstream.h>
#include "deviceparse.hh"
#include <XVImage.hh>
#include <Image.hh>

#define LIVE

//#include "motion_estimation.icc"

main(int argc, char *argv[]) 
{
  //* creates an XConsole to manage display of images...
  XConsole c;
 
  //* interactive initialization happens in this window
  XWindow init_win(c); 

  //* live display of the tracked region happens in this window
  XWindow win_live(c); 

#ifndef LIVE
  MPEG v("hallway.mpg");
  v.set_grab_type(PIX_INTENSITY);
  v.auto_step(0);
#else
  Meteor v;
#endif

  GlobalVelocity gv(&v,10,30,1);
  SSD t(&v,20,20,4);
  XVImage<int> gim(40,40);
  int tracking = 1;
  int rollover;
  int display_subsample;

#ifndef LIVE
  display_subsample = 1;
#else
    display_subsample = 5;
#endif

  t.check_match(.90,10);
  t.interactive_init(init_win);
  t.set_oiter(3);
  t.init_timing(300, 1);

  float x = t.x();
  float y = t.y();

#ifndef LIVE
  while (v.forward()) {
#else
 while (1) {
#endif

   // Here is the feedforward part of the loop

   gv.track();

   t.set_x(t.x()+gv.vx());
   if (tracking)
     t.set_y(t.y()+gv.vy());

   // Now track

   tracking = t.track();

   // Do some display

   if (rollover++ % display_subsample == 0) {
     init_win.clear();
     if (tracking) {
       cout << "++++" << t.x() << " " << t.y() << " " << t.correlation() << endl;
       v.grab(gim,t.x(),t.y());
       //	init_win.show((t.live_image()).magnify(4),t.x(),t.y());
       init_win.show(gim,t.x()-gim.width()/2,t.y()-gim.height()/2);
     }
     else {
       cout << "---" << t.x() << " " << t.y() << endl;
       init_win.circle(t.x(),t.y(),20,red_color);
     }

     init_win.flush();
   }

  }
}



