#ifndef GRID_INCLUDED
#define GRID_INCLUDED

#ifndef PI
#define PI 3.1415926535897932384
#endif 

// This class represents a set of regular samples of a real-valued, periodic, function in 2D
template<class Real=float>
class SquareGrid{
protected:
	Real* values;
	int res;
public:
	SquareGrid(void);
	~SquareGrid(void);

	// Returns the dimension of the array
	int resolution(void) const;
	// Allocates memory for the array
	int resize(const int& resolution);

	// Clears the values of the array to 0
	void clear(void);

	// Returns a reference to the indexed  array element
	Real& operator() (const int& x,const int& y);
	Real operator() (const int& x,const int& y) const;
	Real* operator[] (const int& x);
	// Returns the linear interpolation of the value at the spedified index
	Real operator() (const double& x,const double& y);
	Real operator() (const double& x,const double& y) const;

	// Returns the square of the L2-norm of the array elements
	Real squareNorm(void) const;

	// Reads in an array from the specified file
	int read(const char* fileName);
	int read(FILE* fp);

	// Writes out the array to the specified file
	int write(const char* fileName) const;
	int write(FILE* fp) const;

	// Returns the square of the L2-difference between two arrays
	static Real SquareDifference(const SquareGrid& g1,const SquareGrid& g2);

	// Returns the dot-product of two arrays
	static Real Dot(const SquareGrid& g1,const SquareGrid& g2);
};
#include "SquareGrid.inl"
#endif // GRID_INCLUDED
