#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "FFTW/fftw3.h"
#include <math.h>

//////////////////
// FourierKey1D //
//////////////////
template<class Real> FourierKey1D<Real>::FourierKey1D(void){
	dim=res=0;
	values=NULL;
}
template<class Real> FourierKey1D<Real>::~FourierKey1D(void){
	if(values){delete[] values;}
	values=NULL;
	dim=res=0;
}
template<class Real> int FourierKey1D<Real>::read(const char* fileName){
	FILE* fp=fopen(fileName,"rb");
	if(!fp){return 0;}
	int r=read(fp);
	fclose(fp);
	return r;
}
template<class Real> int FourierKey1D<Real>::write(const char* fileName) const{
	FILE* fp=fopen(fileName,"wb");
	if(!fp){return 0;}
	int w=write(fp);
	fclose(fp);
	return w;
}
template<class Real> int FourierKey1D<Real>::read(FILE* fp){
	int resolution,r;
	r=int(fread(&resolution,sizeof(int),1,fp));
	if(!r){return 0;}
	resize(resolution);
	r=int(fread(values,sizeof(Complex<Real>),dim,fp));
	if(r==dim){return 1;}
	else{return 0;}
}
template<class Real> int FourierKey1D<Real>::write(FILE* fp) const {
	int w;
	w=int(fwrite(&res,sizeof(int),1,fp));
	if(!w){return 0;}
	w=int(fwrite(values,sizeof(Complex<Real>),dim,fp));
	if(w==dim){return 1;}
	else{return 0;}
}
template<class Real> int FourierKey1D<Real>::size(void) const{return dim;}
template<class Real> int FourierKey1D<Real>::resolution(void) const{return res;}
template<class Real> int FourierKey1D<Real>::resize(const int& resolution,const int& clr){
	int d=FourierTransform<Real>::BandWidth(resolution);
	if(resolution<0){return 0;}
	else if(d!=dim){
		if(values){delete[] values;}
		values=NULL;
		dim=0;
		res=0;
		if(d){
			values=new Complex<Real>[d];
			if(!values){return 0;}
			else{dim=d;}
		}
	}
	res=resolution;
	if(clr){clear();}
	return 1;
}
template<class Real> void FourierKey1D<Real>::clear(void){if(dim){memset(values,0,sizeof(Complex<Real>)*dim);}}
template<class Real> Complex<Real>& FourierKey1D<Real>::operator() (const int& i){return values[i];}
template<class Real> Complex<Real> FourierKey1D<Real>::operator() (const int& i) const {return values[i];}
template<class Real> Real FourierKey1D<Real>::squareNorm(void) const{return Dot(*this,*this).r;}
template<class Real> Real FourierKey1D<Real>::SquareDifference(const FourierKey1D& g1,const FourierKey1D& g2){return g1.squareNorm()+g2.squareNorm()-2*Dot(g1,g2).r;}
template<class Real> Complex<Real> FourierKey1D<Real>::Dot(const FourierKey1D& g1,const FourierKey1D& g2){
	Complex<Real> d;
	if(g1.res != g2.res){
		fprintf(stderr,"Could not compare arrays of different sizes: %d != %d\n",g1.dim,g2.dim);
		exit(0);
	}
	Real n=Real(1.0/(2.0*PI));
	d+=g1.values[0]*g2.values[0].conjugate();
	for(int i=1;i<g1.dim-1;i++){d+=(g1.values[i]*g2.values[i].conjugate())*2;}
	if(g1.res & 1)	{d+=g1.values[g1.dim-1]*g2.values[g1.dim-1].conjugate()*2;}
	else			{d+=g1.values[g1.dim-1]*g2.values[g1.dim-1].conjugate();}
	return d*n;
}

//////////////////////
// FourierTransform //
//////////////////////
int FourierTransform<float>::ForwardFourier(CircularArray<float>& g,FourierKey1D<float>& key){
	if(key.resolution()!=g.resolution()){key.resize(g.resolution());}
	fftwf_plan plan=fftwf_plan_dft_r2c_1d(g.resolution(),&g(0),(fftwf_complex*)(&key(0)),FFTW_PRESERVE_INPUT | FFTW_ESTIMATE);
	fftwf_execute(plan);
	fftwf_destroy_plan(plan);
	float n=float(1.0/(2.0*PI))*g.resolution();
	for(int i=0;i<key.size();i++){key(i)/=n;}
	return 1;
}
int FourierTransform<double>::ForwardFourier(CircularArray<double>& g,FourierKey1D<double>& key){
	if(key.resolution()!=g.resolution()){key.resize(g.resolution(),1);}
	fftw_plan plan=fftw_plan_dft_r2c_1d(g.resolution(),&g(0),(fftw_complex*)(&key(0)),FFTW_PRESERVE_INPUT | FFTW_ESTIMATE);
	fftw_execute(plan);
	fftw_destroy_plan(plan);
	double n=1.0/(2.0*PI)*g.resolution();
	for(int i=0;i<key.size();i++){key(i)/=n;}
	return 1;
}
template<class Real>
int FourierTransform<Real>::ForwardFourier(CircularArray<Real>& g,FourierKey1D<Real>& key){
	fprintf(stderr,"Only float and double precision FFTs suppored\n");
	return 0;
}
int FourierTransform<float>::InverseFourier(FourierKey1D<float>& key,CircularArray<float>& g){
	if(key.resolution()!=g.resolution()){g.resize(key.resolution());}
	fftwf_plan plan=fftwf_plan_dft_c2r_1d(g.resolution(),(fftwf_complex*)(&key(0)),&g(0),FFTW_PRESERVE_INPUT | FFTW_ESTIMATE);
	fftwf_execute(plan);
	fftwf_destroy_plan(plan);
	float n=float(2.0*PI);
	for(int i=0;i<g.resolution();i++){g(i)/=n;}
	return 1;
}
int FourierTransform<double>::InverseFourier(FourierKey1D<double>& key,CircularArray<double>& g){
	if(key.resolution()!=g.resolution()){g.resize(key.resolution());}
	fftw_plan plan=fftw_plan_dft_c2r_1d(g.resolution(),(fftw_complex*)(&key(0)),&g(0),FFTW_PRESERVE_INPUT | FFTW_ESTIMATE);
	fftw_execute(plan);
	fftw_destroy_plan(plan);
	double n=2.0*PI;
	for(int i=0;i<g.resolution();i++){g(i)/=n;}
	return 1;
}
template<class Real>
int FourierTransform<Real>::InverseFourier(FourierKey1D<Real>& key,CircularArray<Real>& g){
	fprintf(stderr,"Only float and double precision FFTs suppored\n");
	return 0;
}
