template<class Real> Complex<Real>::Complex(const Real& r,const Real& i){this->r=r;this->i=i;}
template<class Real> Complex<Real> Complex<Real>::operator - (void) const{
	Complex<Real> c;
	c.r=-r;
	c.i=-i;
	return c;
}
template<class Real> Complex<Real> Complex<Real>::conjugate(void) const{
	Complex<Real> c;
	c.r=r;
	c.i=-i;
	return c;
}
template<class Real> Real Complex<Real>::squareNorm(void) const {return r*r+i*i;}
template<class Real> Complex<Real> Complex<Real>::operator + (const Real& r) const {
	Complex<Real> c;
	c.r=this->r+r;
	c.i=i;
	return c;
}
template<class Real> Complex<Real> Complex<Real>::operator - (const Real& r) const {
	Complex<Real> c;
	c.r=this->r-r;
	c.i=i;
	return c;
}
template<class Real> Complex<Real> Complex<Real>::operator * (const Real& r) const {
	Complex<Real> c;
	c.r=this->r*r;
	c.i=this->i*r;
	return c;
}
template<class Real> Complex<Real> Complex<Real>::operator / (const Real& r) const {
	Complex<Real> c;
	c.r=this->r/r;
	c.i=this->i/r;
	return c;
}
template<class Real> Complex<Real>& Complex<Real>::operator = (const Real& r){
	this->r=r;
	this->i=0;
	return *this;
}
template<class Real> Complex<Real>& Complex<Real>::operator += (const Real& r){
	this->r+=r;
	return *this;
}
template<class Real> Complex<Real>& Complex<Real>::operator -= (const Real& r){
	this->r-=r;
	return *this;
}
template<class Real> Complex<Real>& Complex<Real>::operator *= (const Real& r){
	this->r*=r;
	this->i*=r;
	return *this;
}
template<class Real> Complex<Real>& Complex<Real>::operator /= (const Real& r){
	this->r/=r;
	this->i/=r;
	return *this;
}
template<class Real> Complex<Real> Complex<Real>::operator + (const Complex<Real>& c) const {
	Complex<Real> out;
	out.r=r+c.r;
	out.i=i+c.i;
	return out;
}
template<class Real> Complex<Real> Complex<Real>::operator - (const Complex<Real>& c) const {
	Complex<Real> out;
	out.r=r-c.r;
	out.i=i-c.i;
	return out;
}
template<class Real> Complex<Real> Complex<Real>::operator * (const Complex<Real>& c) const {
	Complex<Real> out;
	out.r=r*c.r-i*c.i;
	out.i=r*c.i+i*c.r;
	return out;
}
template<class Real> Complex<Real> Complex<Real>::operator / (const Complex<Real>& c) const {
	Complex<Real> recip=c.conjugate()/c.squareNorm();
	return (*this)*recip;
}
template<class Real> Complex<Real>& Complex<Real>::operator = (const Complex<Real>& c){
	r=c.r;
	i=c.i;
	return *this;
}
template<class Real> Complex<Real>& Complex<Real>::operator += (const Complex<Real>& c){
	r+=c.r;
	i+=c.i;
	return *this;
}
template<class Real> Complex<Real>& Complex<Real>::operator -= (const Complex<Real>& c){
	r-=c.r;
	i-=c.i;
	return *this;
}
template<class Real> Complex<Real>& Complex<Real>::operator *= (const Complex<Real>& c){return ((*this)=((*this)*c));}
template<class Real> Complex<Real>& Complex<Real>::operator /= (const Complex<Real>& c){return ((*this)=((*this)/c));}
