#ifndef CIRCULAR_ARRAY_INCLUDED
#define CIRCULAR_ARRAY_INCLUDED

#ifndef PI
#define PI 3.1415926535897932384
#endif 

// This templated class represents a set of regular samples of a real-valued function on the unit-circle
template<class Real=float>
class CircularArray{
protected:
	int res;
	Real* values;
public:
	CircularArray(void);
	~CircularArray(void);

	// Returns the dimension of the array
	int resolution(void) const;
	// Allocates memory for the array
	int resize(const int& resolution);

	// Clears the values of the array to 0
	void clear(void);

	// Returns a reference to the indexed array element
	Real& operator() (const int& x);
	Real operator() (const int& x) const;
	// Returns the linear interpolation of the value at the spedified index
	Real operator() (const double& x);
	Real operator() (const double& x) const;

	// Returns the square of the L2-norm of the array elements
	Real squareNorm(void) const;

	// Reads in an array from the specified file
	int read(const char* fileName);
	int read(FILE* fp);

	// Writes out the array to the specified file
	int write(const char* fileName) const;
	int write(FILE* fp) const;

	// Returns the square of the L2-difference between two arrays
	static Real SquareDifference(const CircularArray& g1,const CircularArray& g2);

	// Returns the dot-product of two arrays
	static Real Dot(const CircularArray& g1,const CircularArray& g2);
};
#include "CircularArray.inl"
#endif // CIRCULAR_ARRAY_INCLUDED
