#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "image.h"


Pixel32::Pixel32(void){
	r=g=b=0;
	a=255;
}

Image32::Image32(void){
	w=h=0;
	pixels=NULL;
}
Image32::~Image32(void){
	if(pixels){delete[] pixels;}
	pixels=NULL;
	w=h=0;
}
int Image32::setSize(const int& width,const int& height){
	if(w!=width || h!=height){
		if(pixels){delete[] pixels;}
		pixels=NULL;
		w=h=0;
		if(!width*height){return 0;}
		pixels=new Pixel32[width*height];
		if(!pixels){
			fprintf(stderr,"Failed to allocate memory for image: %dx%d\n",width,height);
			exit(0);
		}
	}
	w=width;
	h=height;
	memset(pixels,0,sizeof(Pixel32)*w*h);
	return width*height;
}
Image32& Image32::operator = (const Image32& img){
	setSize(img.width(),img.height());
	memcpy(pixels,img.pixels,sizeof(Pixel32)*w*h);
	return *this;
}

Pixel32& Image32::operator() (const int& x,const int& y){
	if(x<0 || x>=w || y<0 || y>=h){
		fprintf(stderr,"Pixel index out of range: (%d,%d) not in [0,%d]x[0,%d]\n",x,y,w,h);
		exit(0);
	}
	return pixels[x+y*w];
}
const Pixel32& Image32::operator() (const int& x,const int& y) const{
	if(x<0 || x>=w || y<0 || y>=h){
		fprintf(stderr,"Pixel index out of range: (%d,%d) not in [0,%d]x[0,%d]\n",x,y,w,h);
		exit(0);
	}
	return pixels[x+y*w];
}
Pixel32& Image32::pixel(const int& x,const int& y){
	if(x<0 || x>=w || y<0 || y>=h){
		fprintf(stderr,"Pixel index out of range: (%d,%d) not in [0,%d]x[0,%d]\n",x,y,w,h);
		exit(0);
	}
	return pixels[x+y*w];
}
const Pixel32& Image32::pixel(const int& x,const int& y) const{
	if(x<0 || x>=w || y<0 || y>=h){
		fprintf(stderr,"Pixel index out of range: (%d,%d) not in [0,%d]x[0,%d]\n",x,y,w,h);
		exit(0);
	}
	return pixels[x+y*w];
}
int Image32::width(void) const {return w;}
int Image32::height(void) const {return h;}
