
/***************************************************************************
  **************************************************************************
  
                Spherical Harmonic Transform Kit 2.6
  
   Sean Moore, Dennis Healy, Dan Rockmore, Peter Kostelec
   smoore@bbn.com, {healy,rockmore,geelong}@cs.dartmouth.edu
  
   Contact: Peter Kostelec
            geelong@cs.dartmouth.edu
  
  
   Copyright 1997-2003  Sean Moore, Dennis Healy,
                        Dan Rockmore, Peter Kostelec
  
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
  
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
  
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  
   Commercial use is absolutely prohibited.
  
   See the accompanying LICENSE file for details.
  
  ************************************************************************
  ************************************************************************/

/* these are the bit-reverse, 4096 roots of unity, and by subrecursion,
   contains all Nth roots of unity (N < 4096) in bit-reversed order */

#if !USE_CPP
const double r4096[8192] =
{1.000000000000000, 0, -1.000000000000000, 0, 0, 
 1.000000000000000, 0, -1.000000000000000, 
  0.707106781186548, 0.707106781186547, -0.707106781186547, 
  -0.707106781186548, -0.707106781186547, 0.707106781186548, 
  0.707106781186548, -0.707106781186547, 0.923879532511287, 
  0.382683432365090, -0.923879532511287, -0.382683432365090, 
  -0.382683432365090, 0.923879532511287, 0.382683432365090, 
  -0.923879532511287, 0.382683432365090, 0.923879532511287, 
  -0.382683432365090, -0.923879532511287, -0.923879532511287, 
  0.382683432365090, 0.923879532511287, -0.382683432365090, 
  0.980785280403230, 0.1950903220161282, -0.980785280403230, 
  -0.1950903220161286, -0.1950903220161282, 0.980785280403230, 
  0.1950903220161283, -0.980785280403230, 0.555570233019602, 
  0.831469612302545, -0.555570233019602, -0.831469612302545, 
  -0.831469612302545, 0.555570233019602, 0.831469612302545, 
  -0.555570233019602, 0.831469612302545, 0.555570233019602, 
  -0.831469612302545, -0.555570233019602, -0.555570233019602, 
  0.831469612302545, 0.555570233019602, -0.831469612302545, 
  0.1950903220161283, 0.980785280403230, -0.1950903220161282, 
  -0.980785280403230, -0.980785280403230, 0.1950903220161286, 
  0.980785280403230, -0.1950903220161282, 0.995184726672197, 
  0.0980171403295606, -0.995184726672197, -0.0980171403295608, 
  -0.0980171403295607, 0.995184726672197, 0.0980171403295608, 
  -0.995184726672197, 0.634393284163646, 0.773010453362737, 
  -0.634393284163645, -0.773010453362737, -0.773010453362737, 
  0.634393284163645, 0.773010453362737, -0.634393284163645, 
  0.881921264348355, 0.471396736825998, -0.881921264348355, 
  -0.471396736825998, -0.471396736825998, 0.881921264348355, 
  0.471396736825998, -0.881921264348355, 0.290284677254462, 
  0.956940335732209, -0.290284677254462, -0.956940335732209, 
  -0.956940335732209, 0.290284677254462, 0.956940335732209, 
  -0.290284677254462, 0.956940335732209, 0.290284677254462, 
  -0.956940335732209, -0.290284677254462, -0.290284677254462, 
  0.956940335732209, 0.290284677254462, -0.956940335732209, 
  0.471396736825998, 0.881921264348355, -0.471396736825998, 
  -0.881921264348355, -0.881921264348355, 0.471396736825998, 
  0.881921264348355, -0.471396736825998, 0.773010453362737, 
  0.634393284163645, -0.773010453362737, -0.634393284163645, 
  -0.634393284163645, 0.773010453362737, 0.634393284163646, 
  -0.773010453362737, 0.0980171403295608, 0.995184726672197, 
  -0.0980171403295607, -0.995184726672197, -0.995184726672197, 
  0.0980171403295608, 0.995184726672197, -0.0980171403295606, 
  0.998795456205172, 0.04906767432741802, -0.998795456205172, 
  -0.04906767432741798, -0.04906767432741801, 0.998795456205172, 
  0.04906767432741814, -0.998795456205172, 0.671558954847018, 
  0.740951125354959, -0.671558954847018, -0.740951125354959, 
  -0.740951125354959, 0.671558954847019, 0.740951125354959, 
  -0.671558954847018, 0.903989293123443, 0.427555093430282, 
  -0.903989293123443, -0.427555093430282, -0.427555093430282, 
  0.903989293123443, 0.427555093430282, -0.903989293123443, 
  0.336889853392220, 0.941544065183021, -0.336889853392220, 
  -0.941544065183021, -0.941544065183021, 0.336889853392220, 
  0.941544065183021, -0.336889853392220, 0.970031253194544, 
  0.2429801799032639, -0.970031253194544, -0.242980179903264, 
  -0.2429801799032639, 0.970031253194544, 0.242980179903264, 
  -0.970031253194544, 0.514102744193222, 0.857728610000272, 
  -0.514102744193222, -0.857728610000272, -0.857728610000272, 
  0.514102744193222, 0.857728610000272, -0.514102744193222, 
  0.803207531480645, 0.595699304492433, -0.803207531480645, 
  -0.595699304492433, -0.595699304492433, 0.803207531480645, 
  0.595699304492433, -0.803207531480645, 0.1467304744553617, 
  0.989176509964781, -0.1467304744553616, -0.989176509964781, 
  -0.989176509964781, 0.1467304744553618, 0.989176509964781, 
  -0.1467304744553617, 0.989176509964781, 0.1467304744553617, 
  -0.989176509964781, -0.1467304744553618, -0.1467304744553616, 
  0.989176509964781, 0.1467304744553617, -0.989176509964781, 
  0.595699304492433, 0.803207531480645, -0.595699304492433, 
  -0.803207531480645, -0.803207531480645, 0.595699304492433, 
  0.803207531480645, -0.595699304492433, 0.857728610000272, 
  0.514102744193222, -0.857728610000272, -0.514102744193222, 
  -0.514102744193222, 0.857728610000272, 0.514102744193222, 
  -0.857728610000272, 0.242980179903264, 0.970031253194544, 
  -0.2429801799032639, -0.970031253194544, -0.970031253194544, 
  0.242980179903264, 0.970031253194544, -0.2429801799032639, 
  0.941544065183021, 0.336889853392220, -0.941544065183021, 
  -0.336889853392220, -0.336889853392220, 0.941544065183021, 
  0.336889853392220, -0.941544065183021, 0.427555093430282, 
  0.903989293123443, -0.427555093430282, -0.903989293123443, 
  -0.903989293123443, 0.427555093430282, 0.903989293123443, 
  -0.427555093430282, 0.740951125354959, 0.671558954847018, 
  -0.740951125354959, -0.671558954847019, -0.671558954847018, 
  0.740951125354959, 0.671558954847018, -0.740951125354959, 
  0.04906767432741814, 0.998795456205172, -0.04906767432741801, 
  -0.998795456205172, -0.998795456205172, 0.04906767432741798, 
  0.998795456205172, -0.04906767432741802, 0.999698818696204, 
  0.02454122852291229, -0.999698818696204, -0.02454122852291233, 
  -0.02454122852291214, 0.999698818696204, 0.02454122852291227, 
  -0.999698818696204, 0.689540544737067, 0.724247082951467, 
  -0.689540544737067, -0.724247082951467, -0.724247082951467, 
  0.689540544737067, 0.724247082951467, -0.689540544737067, 
  0.914209755703531, 0.405241314004990, -0.914209755703531, 
  -0.405241314004990, -0.405241314004990, 0.914209755703531, 
  0.405241314004990, -0.914209755703531, 0.359895036534988, 
  0.932992798834739, -0.359895036534988, -0.932992798834739, 
  -0.932992798834739, 0.359895036534988, 0.932992798834739, 
  -0.359895036534988, 0.975702130038529, 0.2191012401568698, 
  -0.975702130038528, -0.21910124015687, -0.2191012401568697, 
  0.975702130038529, 0.2191012401568698, -0.975702130038529, 
  0.534997619887097, 0.844853565249707, -0.534997619887097, 
  -0.844853565249707, -0.844853565249707, 0.534997619887097, 
  0.844853565249707, -0.534997619887097, 0.817584813151584, 
  0.575808191417845, -0.817584813151583, -0.575808191417845, 
  -0.575808191417845, 0.817584813151584, 0.575808191417845, 
  -0.817584813151584, 0.1709618887603014, 0.985277642388941, 
  -0.1709618887603012, -0.985277642388941, -0.985277642388941, 
  0.1709618887603012, 0.985277642388941, -0.1709618887603012, 
  0.992479534598710, 0.1224106751992162, -0.992479534598710, 
  -0.1224106751992164, -0.1224106751992162, 0.992479534598710, 
  0.1224106751992163, -0.992479534598710, 0.615231590580627, 
  0.788346427626606, -0.615231590580627, -0.788346427626606, 
  -0.788346427626606, 0.615231590580627, 0.788346427626606, 
  -0.615231590580627, 0.870086991108711, 0.492898192229784, 
  -0.870086991108711, -0.492898192229784, -0.492898192229784, 
  0.870086991108711, 0.492898192229784, -0.870086991108711, 
  0.266712757474898, 0.963776065795440, -0.266712757474898, 
  -0.963776065795440, -0.963776065795440, 0.266712757474898, 
  0.963776065795440, -0.266712757474898, 0.949528180593037, 
  0.313681740398892, -0.949528180593037, -0.313681740398891, 
  -0.313681740398891, 0.949528180593037, 0.313681740398892, 
  -0.949528180593037, 0.449611329654607, 0.893224301195515, 
  -0.449611329654607, -0.893224301195515, -0.893224301195515, 
  0.449611329654607, 0.893224301195515, -0.449611329654607, 
  0.757208846506485, 0.653172842953777, -0.757208846506485, 
  -0.653172842953777, -0.653172842953777, 0.757208846506485, 
  0.653172842953777, -0.757208846506485, 0.07356456359966746, 
  0.997290456678690, -0.07356456359966735, -0.997290456678690, 
  -0.997290456678690, 0.07356456359966775, 0.997290456678690, 
  -0.07356456359966744, 0.997290456678690, 0.07356456359966744, 
  -0.997290456678690, -0.07356456359966775, -0.07356456359966735, 
  0.997290456678690, 0.07356456359966746, -0.997290456678690, 
  0.653172842953777, 0.757208846506485, -0.653172842953777, 
  -0.757208846506485, -0.757208846506485, 0.653172842953777, 
  0.757208846506485, -0.653172842953777, 0.893224301195515, 
  0.449611329654607, -0.893224301195515, -0.449611329654607, 
  -0.449611329654607, 0.893224301195515, 0.449611329654607, 
  -0.893224301195515, 0.313681740398892, 0.949528180593037, 
  -0.313681740398891, -0.949528180593037, -0.949528180593037, 
  0.313681740398891, 0.949528180593037, -0.313681740398892, 
  0.963776065795440, 0.266712757474898, -0.963776065795440, 
  -0.266712757474898, -0.266712757474898, 0.963776065795440, 
  0.266712757474898, -0.963776065795440, 0.492898192229784, 
  0.870086991108711, -0.492898192229784, -0.870086991108711, 
  -0.870086991108711, 0.492898192229784, 0.870086991108711, 
  -0.492898192229784, 0.788346427626606, 0.615231590580627, 
  -0.788346427626606, -0.615231590580627, -0.615231590580627, 
  0.788346427626606, 0.615231590580627, -0.788346427626606, 
  0.1224106751992163, 0.992479534598710, -0.1224106751992162, 
  -0.992479534598710, -0.992479534598710, 0.1224106751992164, 
  0.992479534598710, -0.1224106751992162, 0.985277642388941, 
  0.1709618887603012, -0.985277642388941, -0.1709618887603012, 
  -0.1709618887603012, 0.985277642388941, 0.1709618887603014, 
  -0.985277642388941, 0.575808191417845, 0.817584813151584, 
  -0.575808191417845, -0.817584813151584, -0.817584813151583, 
  0.575808191417845, 0.817584813151584, -0.575808191417845, 
  0.844853565249707, 0.534997619887097, -0.844853565249707, 
  -0.534997619887097, -0.534997619887097, 0.844853565249707, 
  0.534997619887097, -0.844853565249707, 0.2191012401568698, 
  0.975702130038529, -0.2191012401568697, -0.975702130038529, 
  -0.975702130038528, 0.21910124015687, 0.975702130038529, 
  -0.2191012401568698, 0.932992798834739, 0.359895036534988, 
  -0.932992798834739, -0.359895036534988, -0.359895036534988, 
  0.932992798834739, 0.359895036534988, -0.932992798834739, 
  0.405241314004990, 0.914209755703531, -0.405241314004990, 
  -0.914209755703531, -0.914209755703531, 0.405241314004990, 
  0.914209755703531, -0.405241314004990, 0.724247082951467, 
  0.689540544737067, -0.724247082951467, -0.689540544737067, 
  -0.689540544737067, 0.724247082951467, 0.689540544737067, 
  -0.724247082951467, 0.02454122852291227, 0.999698818696204, 
  -0.02454122852291214, -0.999698818696204, -0.999698818696204, 
  0.02454122852291233, 0.999698818696204, -0.02454122852291229, 
  0.999924701839145, 0.01227153828571992, -0.999924701839145, 
  -0.01227153828572001, -0.01227153828571982, 0.999924701839145, 
  0.01227153828571994, -0.999924701839145, 0.698376249408973, 
  0.715730825283819, -0.698376249408973, -0.715730825283819, 
  -0.715730825283818, 0.698376249408973, 0.715730825283819, 
  -0.698376249408973, 0.919113851690058, 0.393992040061048, 
  -0.919113851690058, -0.393992040061048, -0.393992040061048, 
  0.919113851690058, 0.393992040061048, -0.919113851690058, 
  0.371317193951838, 0.928506080473215, -0.371317193951838, 
  -0.928506080473216, -0.928506080473215, 0.371317193951838, 
  0.928506080473215, -0.371317193951838, 0.978317370719628, 
  0.2071113761922186, -0.978317370719628, -0.2071113761922188, 
  -0.2071113761922184, 0.978317370719628, 0.2071113761922186, 
  -0.978317370719628, 0.545324988422047, 0.838224705554838, 
  -0.545324988422046, -0.838224705554838, -0.838224705554838, 
  0.545324988422046, 0.838224705554838, -0.545324988422046, 
  0.824589302785025, 0.565731810783613, -0.824589302785025, 
  -0.565731810783613, -0.565731810783613, 0.824589302785025, 
  0.565731810783613, -0.824589302785025, 0.183039887955141, 
  0.983105487431216, -0.1830398879551409, -0.983105487431216, 
  -0.983105487431216, 0.1830398879551409, 0.983105487431216, 
  -0.1830398879551409, 0.993906970002356, 0.1102222072938831, 
  -0.993906970002356, -0.1102222072938833, -0.1102222072938831, 
  0.993906970002356, 0.1102222072938832, -0.993906970002356, 
  0.624859488142386, 0.780737228572094, -0.624859488142386, 
  -0.780737228572095, -0.780737228572094, 0.624859488142386, 
  0.780737228572094, -0.624859488142386, 0.876070094195406, 
  0.482183772079123, -0.876070094195406, -0.482183772079123, 
  -0.482183772079123, 0.876070094195407, 0.482183772079123, 
  -0.876070094195406, 0.278519689385053, 0.960430519415566, 
  -0.278519689385053, -0.960430519415566, -0.960430519415566, 
  0.278519689385053, 0.960430519415566, -0.278519689385053, 
  0.953306040354194, 0.302005949319228, -0.953306040354194, 
  -0.302005949319228, -0.302005949319228, 0.953306040354194, 
  0.302005949319228, -0.953306040354194, 0.460538710958240, 
  0.887639620402854, -0.460538710958240, -0.887639620402854, 
  -0.887639620402854, 0.460538710958240, 0.887639620402854, 
  -0.460538710958240, 0.765167265622459, 0.643831542889791, 
  -0.765167265622459, -0.643831542889791, -0.643831542889791, 
  0.765167265622459, 0.643831542889791, -0.765167265622459, 
  0.0857973123444399, 0.996312612182778, -0.0857973123444398, 
  -0.996312612182778, -0.996312612182778, 0.0857973123444402, 
  0.996312612182778, -0.0857973123444399, 0.998118112900149, 
  0.06132073630220858, -0.998118112900149, -0.06132073630220849, 
  -0.06132073630220854, 0.998118112900149, 0.06132073630220866, 
  -0.998118112900149, 0.662415777590172, 0.749136394523459, 
  -0.662415777590172, -0.749136394523459, -0.749136394523459, 
  0.662415777590172, 0.749136394523459, -0.662415777590172, 
  0.898674465693954, 0.438616238538528, -0.898674465693954, 
  -0.438616238538528, -0.438616238538527, 0.898674465693954, 
  0.438616238538528, -0.898674465693954, 0.325310292162263, 
  0.945607325380521, -0.325310292162263, -0.945607325380521, 
  -0.945607325380521, 0.325310292162263, 0.945607325380521, 
  -0.325310292162263, 0.966976471044852, 0.254865659604515, 
  -0.966976471044852, -0.254865659604515, -0.254865659604515, 
  0.966976471044852, 0.254865659604515, -0.966976471044852, 
  0.503538383725718, 0.863972856121587, -0.503538383725717, 
  -0.863972856121587, -0.863972856121587, 0.503538383725718, 
  0.863972856121587, -0.503538383725718, 0.795836904608884, 
  0.605511041404326, -0.795836904608883, -0.605511041404326, 
  -0.605511041404325, 0.795836904608884, 0.605511041404326, 
  -0.795836904608884, 0.1345807085071262, 0.990902635427780, 
  -0.1345807085071261, -0.990902635427780, -0.990902635427780, 
  0.1345807085071263, 0.990902635427780, -0.1345807085071262, 
  0.987301418157858, 0.1588581433338614, -0.987301418157858, 
  -0.1588581433338614, -0.1588581433338613, 0.987301418157858, 
  0.1588581433338614, -0.987301418157858, 0.585797857456439, 
  0.810457198252595, -0.585797857456439, -0.810457198252595, 
  -0.810457198252595, 0.585797857456439, 0.810457198252595, 
  -0.585797857456439, 0.851355193105265, 0.524589682678469, 
  -0.851355193105265, -0.524589682678469, -0.524589682678469, 
  0.851355193105265, 0.524589682678469, -0.851355193105265, 
  0.2310581082806713, 0.972939952205560, -0.2310581082806711, 
  -0.972939952205560, -0.972939952205560, 0.2310581082806713, 
  0.972939952205560, -0.2310581082806711, 0.937339011912575, 
  0.348418680249435, -0.937339011912575, -0.348418680249435, 
  -0.348418680249434, 0.937339011912575, 0.348418680249435, 
  -0.937339011912575, 0.416429560097637, 0.909167983090522, 
  -0.416429560097637, -0.909167983090522, -0.909167983090522, 
  0.416429560097637, 0.909167983090522, -0.416429560097637, 
  0.732654271672413, 0.680600997795453, -0.732654271672413, 
  -0.680600997795453, -0.680600997795453, 0.732654271672413, 
  0.680600997795453, -0.732654271672413, 0.03680722294135899, 
  0.999322384588349, -0.03680722294135887, -0.999322384588349, 
  -0.999322384588349, 0.03680722294135883, 0.999322384588349, 
  -0.03680722294135883, 0.999322384588349, 0.03680722294135883, 
  -0.999322384588349, -0.03680722294135883, -0.03680722294135887, 
  0.999322384588349, 0.03680722294135899, -0.999322384588349, 
  0.680600997795453, 0.732654271672413, -0.680600997795453, 
  -0.732654271672413, -0.732654271672413, 0.680600997795453, 
  0.732654271672413, -0.680600997795453, 0.909167983090522, 
  0.416429560097637, -0.909167983090522, -0.416429560097637, 
  -0.416429560097637, 0.909167983090522, 0.416429560097637, 
  -0.909167983090522, 0.348418680249435, 0.937339011912575, 
  -0.348418680249434, -0.937339011912575, -0.937339011912575, 
  0.348418680249435, 0.937339011912575, -0.348418680249435, 
  0.972939952205560, 0.2310581082806711, -0.972939952205560, 
  -0.2310581082806713, -0.2310581082806711, 0.972939952205560, 
  0.2310581082806713, -0.972939952205560, 0.524589682678469, 
  0.851355193105265, -0.524589682678469, -0.851355193105265, 
  -0.851355193105265, 0.524589682678469, 0.851355193105265, 
  -0.524589682678469, 0.810457198252595, 0.585797857456439, 
  -0.810457198252595, -0.585797857456439, -0.585797857456439, 
  0.810457198252595, 0.585797857456439, -0.810457198252595, 
  0.1588581433338614, 0.987301418157858, -0.1588581433338613, 
  -0.987301418157858, -0.987301418157858, 0.1588581433338614, 
  0.987301418157858, -0.1588581433338614, 0.990902635427780, 
  0.1345807085071262, -0.990902635427780, -0.1345807085071263, 
  -0.1345807085071261, 0.990902635427780, 0.1345807085071262, 
  -0.990902635427780, 0.605511041404326, 0.795836904608884, 
  -0.605511041404325, -0.795836904608884, -0.795836904608883, 
  0.605511041404326, 0.795836904608884, -0.605511041404326, 
  0.863972856121587, 0.503538383725718, -0.863972856121587, 
  -0.503538383725718, -0.503538383725717, 0.863972856121587, 
  0.503538383725718, -0.863972856121587, 0.254865659604515, 
  0.966976471044852, -0.254865659604515, -0.966976471044852, 
  -0.966976471044852, 0.254865659604515, 0.966976471044852, 
  -0.254865659604515, 0.945607325380521, 0.325310292162263, 
  -0.945607325380521, -0.325310292162263, -0.325310292162263, 
  0.945607325380521, 0.325310292162263, -0.945607325380521, 
  0.438616238538528, 0.898674465693954, -0.438616238538527, 
  -0.898674465693954, -0.898674465693954, 0.438616238538528, 
  0.898674465693954, -0.438616238538528, 0.749136394523459, 
  0.662415777590172, -0.749136394523459, -0.662415777590172, 
  -0.662415777590172, 0.749136394523459, 0.662415777590172, 
  -0.749136394523459, 0.06132073630220866, 0.998118112900149, 
  -0.06132073630220854, -0.998118112900149, -0.998118112900149, 
  0.06132073630220849, 0.998118112900149, -0.06132073630220858, 
  0.996312612182778, 0.0857973123444399, -0.996312612182778, 
  -0.0857973123444402, -0.0857973123444398, 0.996312612182778, 
  0.0857973123444399, -0.996312612182778, 0.643831542889791, 
  0.765167265622459, -0.643831542889791, -0.765167265622459, 
  -0.765167265622459, 0.643831542889791, 0.765167265622459, 
  -0.643831542889791, 0.887639620402854, 0.460538710958240, 
  -0.887639620402854, -0.460538710958240, -0.460538710958240, 
  0.887639620402854, 0.460538710958240, -0.887639620402854, 
  0.302005949319228, 0.953306040354194, -0.302005949319228, 
  -0.953306040354194, -0.953306040354194, 0.302005949319228, 
  0.953306040354194, -0.302005949319228, 0.960430519415566, 
  0.278519689385053, -0.960430519415566, -0.278519689385053, 
  -0.278519689385053, 0.960430519415566, 0.278519689385053, 
  -0.960430519415566, 0.482183772079123, 0.876070094195406, 
  -0.482183772079123, -0.876070094195407, -0.876070094195406, 
  0.482183772079123, 0.876070094195406, -0.482183772079123, 
  0.780737228572094, 0.624859488142386, -0.780737228572094, 
  -0.624859488142386, -0.624859488142386, 0.780737228572095, 
  0.624859488142386, -0.780737228572094, 0.1102222072938832, 
  0.993906970002356, -0.1102222072938831, -0.993906970002356, 
  -0.993906970002356, 0.1102222072938833, 0.993906970002356, 
  -0.1102222072938831, 0.983105487431216, 0.1830398879551409, 
  -0.983105487431216, -0.1830398879551409, -0.1830398879551409, 
  0.983105487431216, 0.183039887955141, -0.983105487431216, 
  0.565731810783613, 0.824589302785025, -0.565731810783613, 
  -0.824589302785025, -0.824589302785025, 0.565731810783613, 
  0.824589302785025, -0.565731810783613, 0.838224705554838, 
  0.545324988422046, -0.838224705554838, -0.545324988422046, 
  -0.545324988422046, 0.838224705554838, 0.545324988422047, 
  -0.838224705554838, 0.2071113761922186, 0.978317370719628, 
  -0.2071113761922184, -0.978317370719628, -0.978317370719628, 
  0.2071113761922188, 0.978317370719628, -0.2071113761922186, 
  0.928506080473215, 0.371317193951838, -0.928506080473215, 
  -0.371317193951838, -0.371317193951838, 0.928506080473216, 
  0.371317193951838, -0.928506080473215, 0.393992040061048, 
  0.919113851690058, -0.393992040061048, -0.919113851690058, 
  -0.919113851690058, 0.393992040061048, 0.919113851690058, 
  -0.393992040061048, 0.715730825283819, 0.698376249408973, 
  -0.715730825283818, -0.698376249408973, -0.698376249408973, 
  0.715730825283819, 0.698376249408973, -0.715730825283819, 
  0.01227153828571994, 0.999924701839145, -0.01227153828571982, 
  -0.999924701839145, -0.999924701839145, 0.01227153828572001, 
  0.999924701839145, -0.01227153828571992, 0.999981175282601, 
  0.006135884649154475, -0.999981175282601, -0.0061358846491548, 
  -0.006135884649154394, 0.999981175282601, 0.006135884649154516, 
  -0.999981175282601, 0.702754744457225, 0.711432195745216, 
  -0.702754744457225, -0.711432195745217, -0.711432195745216, 
  0.702754744457225, 0.711432195745216, -0.702754744457225, 
  0.921514039342042, 0.388345046698826, -0.921514039342042, 
  -0.388345046698827, -0.388345046698826, 0.921514039342042, 
  0.388345046698826, -0.921514039342042, 0.377007410216418, 
  0.926210242138311, -0.377007410216418, -0.926210242138311, 
  -0.926210242138311, 0.377007410216418, 0.926210242138311, 
  -0.377007410216418, 0.979569765685441, 0.2011046348420919, 
  -0.979569765685441, -0.201104634842092, -0.2011046348420918, 
  0.979569765685441, 0.2011046348420919, -0.979569765685441, 
  0.550457972936605, 0.834862874986380, -0.550457972936605, 
  -0.834862874986380, -0.834862874986380, 0.550457972936605, 
  0.834862874986380, -0.550457972936605, 0.828045045257756, 
  0.560661576197336, -0.828045045257756, -0.560661576197336, 
  -0.560661576197336, 0.828045045257756, 0.560661576197336, 
  -0.828045045257756, 0.1890686641498063, 0.981963869109555, 
  -0.1890686641498062, -0.981963869109555, -0.981963869109555, 
  0.1890686641498063, 0.981963869109555, -0.1890686641498062, 
  0.994564570734255, 0.1041216338720546, -0.994564570734255, 
  -0.1041216338720546, -0.1041216338720546, 0.994564570734255, 
  0.1041216338720547, -0.994564570734255, 0.629638238914927, 
  0.776888465673232, -0.629638238914927, -0.776888465673232, 
  -0.776888465673232, 0.629638238914927, 0.776888465673232, 
  -0.629638238914927, 0.879012226428634, 0.476799230063322, 
  -0.879012226428634, -0.476799230063322, -0.476799230063322, 
  0.879012226428634, 0.476799230063322, -0.879012226428633, 
  0.284407537211272, 0.958703474895872, -0.284407537211272, 
  -0.958703474895872, -0.958703474895872, 0.284407537211272, 
  0.958703474895872, -0.284407537211272, 0.955141168305771, 
  0.296150888243624, -0.955141168305771, -0.296150888243624, 
  -0.296150888243624, 0.955141168305771, 0.296150888243624, 
  -0.955141168305771, 0.465976495767966, 0.884797098430938, 
  -0.465976495767966, -0.884797098430938, -0.884797098430938, 
  0.465976495767966, 0.884797098430938, -0.465976495767966, 
  0.769103337645580, 0.639124444863776, -0.769103337645579, 
  -0.639124444863776, -0.639124444863776, 0.769103337645580, 
  0.639124444863776, -0.769103337645580, 0.0919089564971327, 
  0.995767414467660, -0.0919089564971326, -0.995767414467660, 
  -0.995767414467660, 0.0919089564971328, 0.995767414467660, 
  -0.0919089564971327, 0.998475580573295, 0.05519524434968993, 
  -0.998475580573295, -0.0551952443496901, -0.05519524434968992, 
  0.998475580573295, 0.05519524434969004, -0.998475580573295, 
  0.666999922303638, 0.745057785441466, -0.666999922303637, 
  -0.745057785441466, -0.745057785441466, 0.666999922303638, 
  0.745057785441466, -0.666999922303637, 0.901348847046022, 
  0.433093818853152, -0.901348847046022, -0.433093818853152, 
  -0.433093818853152, 0.901348847046022, 0.433093818853152, 
  -0.901348847046022, 0.331106305759876, 0.943593458161960, 
  -0.331106305759876, -0.943593458161960, -0.943593458161960, 
  0.331106305759876, 0.943593458161960, -0.331106305759876, 
  0.968522094274417, 0.2489276057457201, -0.968522094274417, 
  -0.2489276057457201, -0.2489276057457201, 0.968522094274417, 
  0.2489276057457203, -0.968522094274417, 0.508830142543107, 
  0.860866938637767, -0.508830142543107, -0.860866938637767, 
  -0.860866938637767, 0.508830142543107, 0.860866938637767, 
  -0.508830142543107, 0.799537269107905, 0.600616479383869, 
  -0.799537269107905, -0.600616479383869, -0.600616479383869, 
  0.799537269107905, 0.600616479383869, -0.799537269107905, 
  0.1406582393328492, 0.990058210262297, -0.1406582393328491, 
  -0.990058210262297, -0.990058210262297, 0.1406582393328495, 
  0.990058210262297, -0.1406582393328492, 0.988257567730749, 
  0.1527971852584434, -0.988257567730749, -0.1527971852584437, 
  -0.1527971852584433, 0.988257567730749, 0.1527971852584434, 
  -0.988257567730749, 0.590759701858874, 0.806847553543799, 
  -0.590759701858874, -0.806847553543799, -0.806847553543799, 
  0.590759701858874, 0.806847553543799, -0.590759701858874, 
  0.854557988365400, 0.519355990165590, -0.854557988365400, 
  -0.519355990165590, -0.519355990165590, 0.854557988365401, 
  0.519355990165590, -0.854557988365401, 0.2370236059943673, 
  0.971503890986252, -0.2370236059943672, -0.971503890986252, 
  -0.971503890986252, 0.2370236059943672, 0.971503890986252, 
  -0.2370236059943672, 0.939459223602190, 0.342660717311994, 
  -0.939459223602190, -0.342660717311994, -0.342660717311994, 
  0.939459223602190, 0.342660717311994, -0.939459223602190, 
  0.422000270799800, 0.906595704514915, -0.422000270799800, 
  -0.906595704514915, -0.906595704514915, 0.422000270799800, 
  0.906595704514915, -0.422000270799800, 0.736816568877370, 
  0.676092703575316, -0.736816568877370, -0.676092703575316, 
  -0.676092703575316, 0.736816568877370, 0.676092703575316, 
  -0.736816568877370, 0.04293825693494096, 0.999077727752645, 
  -0.04293825693494084, -0.999077727752645, -0.999077727752645, 
  0.04293825693494103, 0.999077727752645, -0.04293825693494082, 
  0.999529417501093, 0.03067480317663663, -0.999529417501093, 
  -0.03067480317663687, -0.03067480317663646, 0.999529417501093, 
  0.03067480317663658, -0.999529417501093, 0.685083667772700, 
  0.728464390448225, -0.685083667772700, -0.728464390448225, 
  -0.728464390448225, 0.685083667772700, 0.728464390448225, 
  -0.685083667772700, 0.911706032005430, 0.410843171057904, 
  -0.911706032005430, -0.410843171057904, -0.410843171057904, 
  0.911706032005430, 0.410843171057904, -0.911706032005430, 
  0.354163525420491, 0.935183509938947, -0.354163525420490, 
  -0.935183509938948, -0.935183509938948, 0.354163525420490, 
  0.935183509938948, -0.354163525420490, 0.974339382785576, 
  0.2250839113597928, -0.974339382785576, -0.2250839113597928, 
  -0.2250839113597927, 0.974339382785576, 0.2250839113597927, 
  -0.974339382785576, 0.529803624686295, 0.848120344803297, 
  -0.529803624686295, -0.848120344803297, -0.848120344803297, 
  0.529803624686295, 0.848120344803297, -0.529803624686295, 
  0.814036329705948, 0.580813958095765, -0.814036329705948, 
  -0.580813958095765, -0.580813958095764, 0.814036329705948, 
  0.580813958095765, -0.814036329705948, 0.1649131204899701, 
  0.986308097244599, -0.1649131204899699, -0.986308097244599, 
  -0.986308097244599, 0.1649131204899701, 0.986308097244599, 
  -0.1649131204899699, 0.991709753669100, 0.1284981107937932, 
  -0.991709753669100, -0.128498110793793, -0.1284981107937931, 
  0.991709753669100, 0.1284981107937932, -0.991709753669100, 
  0.610382806276309, 0.792106577300212, -0.610382806276309, 
  -0.792106577300212, -0.792106577300212, 0.610382806276310, 
  0.792106577300212, -0.610382806276309, 0.867046245515693, 
  0.498227666972782, -0.867046245515693, -0.498227666972782, 
  -0.498227666972782, 0.867046245515693, 0.498227666972782, 
  -0.867046245515693, 0.260794117915276, 0.965394441697689, 
  -0.260794117915275, -0.965394441697689, -0.965394441697689, 
  0.260794117915276, 0.965394441697689, -0.260794117915276, 
  0.947585591017741, 0.319502030816016, -0.947585591017741, 
  -0.319502030816016, -0.319502030816016, 0.947585591017741, 
  0.319502030816016, -0.947585591017741, 0.444122144570429, 
  0.895966249756185, -0.444122144570429, -0.895966249756185, 
  -0.895966249756185, 0.444122144570429, 0.895966249756185, 
  -0.444122144570429, 0.753186799043613, 0.657806693297079, 
  -0.753186799043612, -0.657806693297079, -0.657806693297079, 
  0.753186799043613, 0.657806693297079, -0.753186799043612, 
  0.06744391956366412, 0.997723066644192, -0.067443919563664, 
  -0.997723066644192, -0.997723066644192, 0.06744391956366418, 
  0.997723066644192, -0.06744391956366405, 0.996820299291166, 
  0.07968243797143014, -0.996820299291166, -0.0796824379714302, 
  -0.07968243797143002, 0.996820299291166, 0.07968243797143014, 
  -0.996820299291166, 0.648514401022113, 0.761202385484262, 
  -0.648514401022112, -0.761202385484262, -0.761202385484262, 
  0.648514401022113, 0.761202385484262, -0.648514401022112, 
  0.890448723244758, 0.455083587126344, -0.890448723244758, 
  -0.455083587126344, -0.455083587126344, 0.890448723244758, 
  0.455083587126344, -0.890448723244758, 0.307849640041535, 
  0.951435020969008, -0.307849640041535, -0.951435020969008, 
  -0.951435020969008, 0.307849640041535, 0.951435020969008, 
  -0.307849640041535, 0.962121404269042, 0.272621355449949, 
  -0.962121404269042, -0.272621355449949, -0.272621355449949, 
  0.962121404269042, 0.272621355449949, -0.962121404269042, 
  0.487550160148436, 0.873094978418290, -0.487550160148436, 
  -0.873094978418290, -0.873094978418290, 0.487550160148436, 
  0.873094978418290, -0.487550160148436, 0.784556597155575, 
  0.620057211763289, -0.784556597155575, -0.620057211763289, 
  -0.620057211763289, 0.784556597155575, 0.620057211763289, 
  -0.784556597155575, 0.1163186309119049, 0.993211949234795, 
  -0.1163186309119047, -0.993211949234795, -0.993211949234795, 
  0.1163186309119047, 0.993211949234795, -0.1163186309119047, 
  0.984210092386929, 0.1770042204121487, -0.984210092386929, 
  -0.1770042204121489, -0.1770042204121487, 0.984210092386929, 
  0.1770042204121489, -0.984210092386929, 0.570780745886967, 
  0.821102514991105, -0.570780745886967, -0.821102514991105, 
  -0.821102514991105, 0.570780745886967, 0.821102514991105, 
  -0.570780745886967, 0.841554977436898, 0.540171472729893, 
  -0.841554977436898, -0.540171472729893, -0.540171472729893, 
  0.841554977436898, 0.540171472729893, -0.841554977436898, 
  0.2131103199160913, 0.977028142657754, -0.2131103199160913, 
  -0.977028142657754, -0.977028142657754, 0.2131103199160914, 
  0.977028142657754, -0.2131103199160913, 0.930766961078984, 
  0.365612997804774, -0.930766961078984, -0.365612997804774, 
  -0.365612997804774, 0.930766961078984, 0.365612997804774, 
  -0.930766961078984, 0.399624199845647, 0.916679059921043, 
  -0.399624199845647, -0.916679059921043, -0.916679059921043, 
  0.399624199845647, 0.916679059921043, -0.399624199845647, 
  0.720002507961382, 0.693971460889654, -0.720002507961382, 
  -0.693971460889654, -0.693971460889654, 0.720002507961382, 
  0.693971460889654, -0.720002507961382, 0.01840672990580482, 
  0.999830581795823, -0.01840672990580469, -0.999830581795824, 
  -0.999830581795823, 0.0184067299058051, 0.999830581795823, 
  -0.01840672990580482, 0.999830581795823, 0.01840672990580482, 
  -0.999830581795823, -0.0184067299058051, -0.01840672990580469, 
  0.999830581795824, 0.01840672990580482, -0.999830581795823, 
  0.693971460889654, 0.720002507961382, -0.693971460889654, 
  -0.720002507961382, -0.720002507961382, 0.693971460889654, 
  0.720002507961382, -0.693971460889654, 0.916679059921043, 
  0.399624199845647, -0.916679059921043, -0.399624199845647, 
  -0.399624199845647, 0.916679059921043, 0.399624199845647, 
  -0.916679059921043, 0.365612997804774, 0.930766961078984, 
  -0.365612997804774, -0.930766961078984, -0.930766961078984, 
  0.365612997804774, 0.930766961078984, -0.365612997804774, 
  0.977028142657754, 0.2131103199160913, -0.977028142657754, 
  -0.2131103199160914, -0.2131103199160913, 0.977028142657754, 
  0.2131103199160913, -0.977028142657754, 0.540171472729893, 
  0.841554977436898, -0.540171472729893, -0.841554977436898, 
  -0.841554977436898, 0.540171472729893, 0.841554977436898, 
  -0.540171472729893, 0.821102514991105, 0.570780745886967, 
  -0.821102514991105, -0.570780745886967, -0.570780745886967, 
  0.821102514991105, 0.570780745886967, -0.821102514991105, 
  0.1770042204121489, 0.984210092386929, -0.1770042204121487, 
  -0.984210092386929, -0.984210092386929, 0.1770042204121489, 
  0.984210092386929, -0.1770042204121487, 0.993211949234795, 
  0.1163186309119047, -0.993211949234795, -0.1163186309119047, 
  -0.1163186309119047, 0.993211949234795, 0.1163186309119049, 
  -0.993211949234795, 0.620057211763289, 0.784556597155575, 
  -0.620057211763289, -0.784556597155575, -0.784556597155575, 
  0.620057211763289, 0.784556597155575, -0.620057211763289, 
  0.873094978418290, 0.487550160148436, -0.873094978418290, 
  -0.487550160148436, -0.487550160148436, 0.873094978418290, 
  0.487550160148436, -0.873094978418290, 0.272621355449949, 
  0.962121404269042, -0.272621355449949, -0.962121404269042, 
  -0.962121404269042, 0.272621355449949, 0.962121404269042, 
  -0.272621355449949, 0.951435020969008, 0.307849640041535, 
  -0.951435020969008, -0.307849640041535, -0.307849640041535, 
  0.951435020969008, 0.307849640041535, -0.951435020969008, 
  0.455083587126344, 0.890448723244758, -0.455083587126344, 
  -0.890448723244758, -0.890448723244758, 0.455083587126344, 
  0.890448723244758, -0.455083587126344, 0.761202385484262, 
  0.648514401022112, -0.761202385484262, -0.648514401022113, 
  -0.648514401022112, 0.761202385484262, 0.648514401022113, 
  -0.761202385484262, 0.07968243797143014, 0.996820299291166, 
  -0.07968243797143002, -0.996820299291166, -0.996820299291166, 
  0.0796824379714302, 0.996820299291166, -0.07968243797143014, 
  0.997723066644192, 0.06744391956366405, -0.997723066644192, 
  -0.06744391956366418, -0.067443919563664, 0.997723066644192, 
  0.06744391956366412, -0.997723066644192, 0.657806693297079, 
  0.753186799043612, -0.657806693297079, -0.753186799043613, 
  -0.753186799043612, 0.657806693297079, 0.753186799043613, 
  -0.657806693297079, 0.895966249756185, 0.444122144570429, 
  -0.895966249756185, -0.444122144570429, -0.444122144570429, 
  0.895966249756185, 0.444122144570429, -0.895966249756185, 
  0.319502030816016, 0.947585591017741, -0.319502030816016, 
  -0.947585591017741, -0.947585591017741, 0.319502030816016, 
  0.947585591017741, -0.319502030816016, 0.965394441697689, 
  0.260794117915276, -0.965394441697689, -0.260794117915276, 
  -0.260794117915275, 0.965394441697689, 0.260794117915276, 
  -0.965394441697689, 0.498227666972782, 0.867046245515693, 
  -0.498227666972782, -0.867046245515693, -0.867046245515693, 
  0.498227666972782, 0.867046245515693, -0.498227666972782, 
  0.792106577300212, 0.610382806276309, -0.792106577300212, 
  -0.610382806276310, -0.610382806276309, 0.792106577300212, 
  0.610382806276309, -0.792106577300212, 0.1284981107937932, 
  0.991709753669100, -0.1284981107937931, -0.991709753669100, 
  -0.991709753669100, 0.128498110793793, 0.991709753669100, 
  -0.1284981107937932, 0.986308097244599, 0.1649131204899699, 
  -0.986308097244599, -0.1649131204899701, -0.1649131204899699, 
  0.986308097244599, 0.1649131204899701, -0.986308097244599, 
  0.580813958095765, 0.814036329705948, -0.580813958095764, 
  -0.814036329705948, -0.814036329705948, 0.580813958095765, 
  0.814036329705948, -0.580813958095765, 0.848120344803297, 
  0.529803624686295, -0.848120344803297, -0.529803624686295, 
  -0.529803624686295, 0.848120344803297, 0.529803624686295, 
  -0.848120344803297, 0.2250839113597927, 0.974339382785576, 
  -0.2250839113597927, -0.974339382785576, -0.974339382785576, 
  0.2250839113597928, 0.974339382785576, -0.2250839113597928, 
  0.935183509938948, 0.354163525420490, -0.935183509938948, 
  -0.354163525420490, -0.354163525420490, 0.935183509938948, 
  0.354163525420491, -0.935183509938947, 0.410843171057904, 
  0.911706032005430, -0.410843171057904, -0.911706032005430, 
  -0.911706032005430, 0.410843171057904, 0.911706032005430, 
  -0.410843171057904, 0.728464390448225, 0.685083667772700, 
  -0.728464390448225, -0.685083667772700, -0.685083667772700, 
  0.728464390448225, 0.685083667772700, -0.728464390448225, 
  0.03067480317663658, 0.999529417501093, -0.03067480317663646, 
  -0.999529417501093, -0.999529417501093, 0.03067480317663687, 
  0.999529417501093, -0.03067480317663663, 0.999077727752645, 
  0.04293825693494082, -0.999077727752645, -0.04293825693494103, 
  -0.04293825693494084, 0.999077727752645, 0.04293825693494096, 
  -0.999077727752645, 0.676092703575316, 0.736816568877370, 
  -0.676092703575316, -0.736816568877370, -0.736816568877370, 
  0.676092703575316, 0.736816568877370, -0.676092703575316, 
  0.906595704514915, 0.422000270799800, -0.906595704514915, 
  -0.422000270799800, -0.422000270799800, 0.906595704514915, 
  0.422000270799800, -0.906595704514915, 0.342660717311994, 
  0.939459223602190, -0.342660717311994, -0.939459223602190, 
  -0.939459223602190, 0.342660717311994, 0.939459223602190, 
  -0.342660717311994, 0.971503890986252, 0.2370236059943672, 
  -0.971503890986252, -0.2370236059943672, -0.2370236059943672, 
  0.971503890986252, 0.2370236059943673, -0.971503890986252, 
  0.519355990165590, 0.854557988365401, -0.519355990165590, 
  -0.854557988365401, -0.854557988365400, 0.519355990165590, 
  0.854557988365400, -0.519355990165590, 0.806847553543799, 
  0.590759701858874, -0.806847553543799, -0.590759701858874, 
  -0.590759701858874, 0.806847553543799, 0.590759701858874, 
  -0.806847553543799, 0.1527971852584434, 0.988257567730749, 
  -0.1527971852584433, -0.988257567730749, -0.988257567730749, 
  0.1527971852584437, 0.988257567730749, -0.1527971852584434, 
  0.990058210262297, 0.1406582393328492, -0.990058210262297, 
  -0.1406582393328495, -0.1406582393328491, 0.990058210262297, 
  0.1406582393328492, -0.990058210262297, 0.600616479383869, 
  0.799537269107905, -0.600616479383869, -0.799537269107905, 
  -0.799537269107905, 0.600616479383869, 0.799537269107905, 
  -0.600616479383869, 0.860866938637767, 0.508830142543107, 
  -0.860866938637767, -0.508830142543107, -0.508830142543107, 
  0.860866938637767, 0.508830142543107, -0.860866938637767, 
  0.2489276057457203, 0.968522094274417, -0.2489276057457201, 
  -0.968522094274417, -0.968522094274417, 0.2489276057457201, 
  0.968522094274417, -0.2489276057457201, 0.943593458161960, 
  0.331106305759876, -0.943593458161960, -0.331106305759876, 
  -0.331106305759876, 0.943593458161960, 0.331106305759876, 
  -0.943593458161960, 0.433093818853152, 0.901348847046022, 
  -0.433093818853152, -0.901348847046022, -0.901348847046022, 
  0.433093818853152, 0.901348847046022, -0.433093818853152, 
  0.745057785441466, 0.666999922303637, -0.745057785441466, 
  -0.666999922303638, -0.666999922303637, 0.745057785441466, 
  0.666999922303638, -0.745057785441466, 0.05519524434969004, 
  0.998475580573295, -0.05519524434968992, -0.998475580573295, 
  -0.998475580573295, 0.0551952443496901, 0.998475580573295, 
  -0.05519524434968993, 0.995767414467660, 0.0919089564971327, 
  -0.995767414467660, -0.0919089564971328, -0.0919089564971326, 
  0.995767414467660, 0.0919089564971327, -0.995767414467660, 
  0.639124444863776, 0.769103337645580, -0.639124444863776, 
  -0.769103337645580, -0.769103337645579, 0.639124444863776, 
  0.769103337645580, -0.639124444863776, 0.884797098430938, 
  0.465976495767966, -0.884797098430938, -0.465976495767966, 
  -0.465976495767966, 0.884797098430938, 0.465976495767966, 
  -0.884797098430938, 0.296150888243624, 0.955141168305771, 
  -0.296150888243624, -0.955141168305771, -0.955141168305771, 
  0.296150888243624, 0.955141168305771, -0.296150888243624, 
  0.958703474895872, 0.284407537211272, -0.958703474895872, 
  -0.284407537211272, -0.284407537211272, 0.958703474895872, 
  0.284407537211272, -0.958703474895872, 0.476799230063322, 
  0.879012226428633, -0.476799230063322, -0.879012226428634, 
  -0.879012226428634, 0.476799230063322, 0.879012226428634, 
  -0.476799230063322, 0.776888465673232, 0.629638238914927, 
  -0.776888465673232, -0.629638238914927, -0.629638238914927, 
  0.776888465673232, 0.629638238914927, -0.776888465673232, 
  0.1041216338720547, 0.994564570734255, -0.1041216338720546, 
  -0.994564570734255, -0.994564570734255, 0.1041216338720546, 
  0.994564570734255, -0.1041216338720546, 0.981963869109555, 
  0.1890686641498062, -0.981963869109555, -0.1890686641498063, 
  -0.1890686641498062, 0.981963869109555, 0.1890686641498063, 
  -0.981963869109555, 0.560661576197336, 0.828045045257756, 
  -0.560661576197336, -0.828045045257756, -0.828045045257756, 
  0.560661576197336, 0.828045045257756, -0.560661576197336, 
  0.834862874986380, 0.550457972936605, -0.834862874986380, 
  -0.550457972936605, -0.550457972936605, 0.834862874986380, 
  0.550457972936605, -0.834862874986380, 0.2011046348420919, 
  0.979569765685441, -0.2011046348420918, -0.979569765685441, 
  -0.979569765685441, 0.201104634842092, 0.979569765685441, 
  -0.2011046348420919, 0.926210242138311, 0.377007410216418, 
  -0.926210242138311, -0.377007410216418, -0.377007410216418, 
  0.926210242138311, 0.377007410216418, -0.926210242138311, 
  0.388345046698826, 0.921514039342042, -0.388345046698826, 
  -0.921514039342042, -0.921514039342042, 0.388345046698827, 
  0.921514039342042, -0.388345046698826, 0.711432195745216, 
  0.702754744457225, -0.711432195745216, -0.702754744457225, 
  -0.702754744457225, 0.711432195745217, 0.702754744457225, 
  -0.711432195745216, 0.006135884649154516, 0.999981175282601, 
  -0.006135884649154394, -0.999981175282601, -0.999981175282601, 
  0.0061358846491548, 0.999981175282601, -0.006135884649154475, 
  0.999995293809576, 0.003067956762965976, -0.999995293809576, 
  -0.003067956762965977, -0.003067956762966015, 0.999995293809576, 
  0.003067956762966138, -0.999995293809576, 0.704934080375905, 
  0.709272826438866, -0.704934080375905, -0.709272826438866, 
  -0.709272826438865, 0.704934080375905, 0.709272826438866, 
  -0.704934080375905, 0.922701128333879, 0.385516053843919, 
  -0.922701128333879, -0.385516053843919, -0.385516053843919, 
  0.922701128333879, 0.385516053843919, -0.922701128333879, 
  0.379847208924051, 0.925049240782678, -0.379847208924051, 
  -0.925049240782678, -0.925049240782677, 0.379847208924051, 
  0.925049240782677, -0.379847208924051, 0.980182135968117, 
  0.1980984107179535, -0.980182135968117, -0.1980984107179538, 
  -0.1980984107179536, 0.980182135968117, 0.1980984107179537, 
  -0.980182135968117, 0.553016705580028, 0.833170164701913, 
  -0.553016705580027, -0.833170164701913, -0.833170164701913, 
  0.553016705580027, 0.833170164701913, -0.553016705580027, 
  0.829761233794523, 0.558118531220556, -0.829761233794523, 
  -0.558118531220556, -0.558118531220556, 0.829761233794523, 
  0.558118531220556, -0.829761233794523, 0.1920803970498924, 
  0.981379193313755, -0.1920803970498923, -0.981379193313755, 
  -0.981379193313755, 0.1920803970498924, 0.981379193313755, 
  -0.1920803970498924, 0.994879330794806, 0.1010698627548278, 
  -0.994879330794806, -0.1010698627548279, -0.1010698627548277, 
  0.994879330794806, 0.1010698627548278, -0.994879330794806, 
  0.632018735939809, 0.774953106594874, -0.632018735939809, 
  -0.774953106594874, -0.774953106594874, 0.632018735939809, 
  0.774953106594874, -0.632018735939809, 0.880470889052161, 
  0.474100214650550, -0.880470889052161, -0.474100214650550, 
  -0.474100214650550, 0.880470889052161, 0.474100214650550, 
  -0.880470889052161, 0.287347459544730, 0.957826413027533, 
  -0.287347459544729, -0.957826413027533, -0.957826413027533, 
  0.287347459544730, 0.957826413027533, -0.287347459544730, 
  0.956045251349996, 0.293219162694259, -0.956045251349996, 
  -0.293219162694259, -0.293219162694259, 0.956045251349996, 
  0.293219162694259, -0.956045251349996, 0.468688822035828, 
  0.883363338665732, -0.468688822035828, -0.883363338665732, 
  -0.883363338665732, 0.468688822035828, 0.883363338665732, 
  -0.468688822035828, 0.771060524261814, 0.636761861236284, 
  -0.771060524261813, -0.636761861236284, -0.636761861236284, 
  0.771060524261814, 0.636761861236284, -0.771060524261814, 
  0.0949634953296391, 0.995480755491927, -0.0949634953296389, 
  -0.995480755491927, -0.995480755491927, 0.0949634953296389, 
  0.995480755491927, -0.094963495329639, 0.998640218180265, 
  0.05213170468028333, -0.998640218180265, -0.0521317046802836, 
  -0.05213170468028319, 0.998640218180265, 0.05213170468028333, 
  -0.998640218180265, 0.669282588346636, 0.743007952135122, 
  -0.669282588346636, -0.743007952135122, -0.743007952135122, 
  0.669282588346636, 0.743007952135122, -0.669282588346636, 
  0.902673318237259, 0.430326481340083, -0.902673318237259, 
  -0.430326481340083, -0.430326481340083, 0.902673318237259, 
  0.430326481340083, -0.902673318237259, 0.333999651442009, 
  0.942573197601447, -0.333999651442009, -0.942573197601447, 
  -0.942573197601447, 0.333999651442009, 0.942573197601447, 
  -0.333999651442009, 0.969281235356549, 0.2459550503357946, 
  -0.969281235356549, -0.2459550503357947, -0.2459550503357945, 
  0.969281235356549, 0.2459550503357946, -0.969281235356549, 
  0.511468850437971, 0.859301818357008, -0.511468850437970, 
  -0.859301818357008, -0.859301818357008, 0.511468850437971, 
  0.859301818357008, -0.511468850437970, 0.801376171723140, 
  0.598160706996342, -0.801376171723140, -0.598160706996342, 
  -0.598160706996342, 0.801376171723140, 0.598160706996342, 
  -0.801376171723140, 0.1436950331502946, 0.989622017463201, 
  -0.1436950331502945, -0.989622017463201, -0.989622017463201, 
  0.1436950331502946, 0.989622017463201, -0.1436950331502945, 
  0.988721691960324, 0.1497645346773215, -0.988721691960324, 
  -0.1497645346773214, -0.1497645346773215, 0.988721691960324, 
  0.1497645346773216, -0.988721691960324, 0.593232295039800, 
  0.805031331142964, -0.593232295039800, -0.805031331142964, 
  -0.805031331142963, 0.593232295039800, 0.805031331142964, 
  -0.593232295039800, 0.856147328375194, 0.516731799017650, 
  -0.856147328375195, -0.516731799017650, -0.516731799017650, 
  0.856147328375195, 0.516731799017650, -0.856147328375194, 
  0.2400030224487415, 0.970772140728950, -0.2400030224487414, 
  -0.970772140728950, -0.970772140728950, 0.2400030224487418, 
  0.970772140728950, -0.2400030224487415, 0.940506070593268, 
  0.339776884406827, -0.940506070593268, -0.339776884406827, 
  -0.339776884406827, 0.940506070593268, 0.339776884406827, 
  -0.940506070593268, 0.424779681209109, 0.905296759318119, 
  -0.424779681209109, -0.905296759318119, -0.905296759318119, 
  0.424779681209109, 0.905296759318119, -0.424779681209109, 
  0.738887324460615, 0.673829000378756, -0.738887324460615, 
  -0.673829000378756, -0.673829000378756, 0.738887324460615, 
  0.673829000378756, -0.738887324460615, 0.04600318213091465, 
  0.998941293186857, -0.04600318213091452, -0.998941293186857, 
  -0.998941293186857, 0.04600318213091471, 0.998941293186857, 
  -0.04600318213091463, 0.999618822495179, 0.02760814577896574, 
  -0.999618822495179, -0.02760814577896565, -0.02760814577896569, 
  0.999618822495179, 0.02760814577896582, -0.999618822495179, 
  0.687315340891759, 0.726359155084346, -0.687315340891759, 
  -0.726359155084346, -0.726359155084346, 0.687315340891759, 
  0.726359155084346, -0.687315340891759, 0.912962190428398, 
  0.408044162864979, -0.912962190428398, -0.408044162864979, 
  -0.408044162864979, 0.912962190428398, 0.408044162864979, 
  -0.912962190428398, 0.357030961233430, 0.934092550404259, 
  -0.357030961233430, -0.934092550404259, -0.934092550404259, 
  0.357030961233430, 0.934092550404259, -0.357030961233430, 
  0.975025345066994, 0.2220936209732035, -0.975025345066994, 
  -0.2220936209732037, -0.2220936209732035, 0.975025345066994, 
  0.2220936209732036, -0.975025345066994, 0.532403127877198, 
  0.846490938774052, -0.532403127877198, -0.846490938774052, 
  -0.846490938774052, 0.532403127877198, 0.846490938774052, 
  -0.532403127877198, 0.815814410806734, 0.578313796411656, 
  -0.815814410806734, -0.578313796411656, -0.578313796411655, 
  0.815814410806734, 0.578313796411656, -0.815814410806734, 
  0.1679382949747312, 0.985797509167567, -0.1679382949747311, 
  -0.985797509167567, -0.985797509167567, 0.1679382949747312, 
  0.985797509167567, -0.1679382949747312, 0.992099313142192, 
  0.1254549834115462, -0.992099313142192, -0.1254549834115463, 
  -0.1254549834115461, 0.992099313142192, 0.1254549834115462, 
  -0.992099313142192, 0.612810082429410, 0.790230221437310, 
  -0.612810082429410, -0.790230221437310, -0.790230221437310, 
  0.612810082429410, 0.790230221437310, -0.612810082429410, 
  0.868570705971341, 0.495565261825773, -0.868570705971341, 
  -0.495565261825773, -0.495565261825772, 0.868570705971341, 
  0.495565261825773, -0.868570705971341, 0.263754678974832, 
  0.964589793289813, -0.263754678974831, -0.964589793289813, 
  -0.964589793289813, 0.263754678974832, 0.964589793289813, 
  -0.263754678974831, 0.948561349915730, 0.316593375556166, 
  -0.948561349915730, -0.316593375556166, -0.316593375556166, 
  0.948561349915730, 0.316593375556166, -0.948561349915730, 
  0.446868840162374, 0.894599485631383, -0.446868840162374, 
  -0.894599485631383, -0.894599485631383, 0.446868840162374, 
  0.894599485631383, -0.446868840162374, 0.755201376896537, 
  0.655492852999615, -0.755201376896536, -0.655492852999616, 
  -0.655492852999615, 0.755201376896536, 0.655492852999615, 
  -0.755201376896536, 0.07050457338961401, 0.997511456140303, 
  -0.07050457338961391, -0.997511456140303, -0.997511456140303, 
  0.07050457338961386, 0.997511456140303, -0.07050457338961386, 
  0.997060070339483, 0.0766238613920315, -0.997060070339483, 
  -0.07662386139203169, -0.0766238613920315, 0.997060070339483, 
  0.07662386139203161, -0.997060070339483, 0.650846684996381, 
  0.759209188978388, -0.650846684996381, -0.759209188978388, 
  -0.759209188978388, 0.650846684996381, 0.759209188978388, 
  -0.650846684996381, 0.891840709392343, 0.452349587233771, 
  -0.891840709392343, -0.452349587233771, -0.452349587233771, 
  0.891840709392343, 0.452349587233771, -0.891840709392343, 
  0.310767152749611, 0.950486073949482, -0.310767152749611, 
  -0.950486073949482, -0.950486073949482, 0.310767152749612, 
  0.950486073949482, -0.310767152749611, 0.962953266873684, 
  0.269668325572915, -0.962953266873684, -0.269668325572915, 
  -0.269668325572915, 0.962953266873684, 0.269668325572915, 
  -0.962953266873684, 0.490226483288291, 0.871595086655951, 
  -0.490226483288291, -0.871595086655951, -0.871595086655951, 
  0.490226483288291, 0.871595086655951, -0.490226483288291, 
  0.786455213599086, 0.617647307937804, -0.786455213599086, 
  -0.617647307937804, -0.617647307937804, 0.786455213599086, 
  0.617647307937804, -0.786455213599086, 0.1193652148109913, 
  0.992850414459865, -0.1193652148109912, -0.992850414459865, 
  -0.992850414459865, 0.1193652148109916, 0.992850414459865, 
  -0.1193652148109914, 0.984748501801904, 0.1739838733874638, 
  -0.984748501801904, -0.1739838733874641, -0.1739838733874637, 
  0.984748501801904, 0.1739838733874639, -0.984748501801904, 
  0.573297166698042, 0.819347520076797, -0.573297166698042, 
  -0.819347520076797, -0.819347520076797, 0.573297166698042, 
  0.819347520076797, -0.573297166698042, 0.843208239641845, 
  0.537587076295645, -0.843208239641845, -0.537587076295646, 
  -0.537587076295646, 0.843208239641845, 0.537587076295646, 
  -0.843208239641845, 0.2161067970762196, 0.976369731330021, 
  -0.2161067970762195, -0.976369731330021, -0.976369731330021, 
  0.2161067970762194, 0.976369731330021, -0.2161067970762195, 
  0.931884265581668, 0.362755724367397, -0.931884265581668, 
  -0.362755724367397, -0.362755724367397, 0.931884265581668, 
  0.362755724367397, -0.931884265581668, 0.402434650859418, 
  0.915448716088268, -0.402434650859418, -0.915448716088268, 
  -0.915448716088268, 0.402434650859419, 0.915448716088268, 
  -0.402434650859418, 0.722128193929215, 0.691759258364158, 
  -0.722128193929215, -0.691759258364158, -0.691759258364158, 
  0.722128193929215, 0.691759258364158, -0.722128193929215, 
  0.02147408027546961, 0.999769405351215, -0.02147408027546948, 
  -0.999769405351215, -0.999769405351215, 0.02147408027546967, 
  0.999769405351215, -0.02147408027546951, 0.999882347454212, 
  0.0153392062849881, -0.999882347454212, -0.01533920628498806, 
  -0.0153392062849881, 0.999882347454212, 0.01533920628498822, 
  -0.999882347454212, 0.696177131491463, 0.717870045055732, 
  -0.696177131491463, -0.717870045055732, -0.717870045055731, 
  0.696177131491463, 0.717870045055732, -0.696177131491463, 
  0.917900775621390, 0.396809987416710, -0.917900775621390, 
  -0.396809987416710, -0.396809987416710, 0.917900775621390, 
  0.396809987416710, -0.917900775621390, 0.368466829953372, 
  0.929640895843181, -0.368466829953372, -0.929640895843181, 
  -0.929640895843181, 0.368466829953373, 0.929640895843181, 
  -0.368466829953372, 0.977677357824510, 0.2101118368804696, 
  -0.977677357824510, -0.2101118368804698, -0.2101118368804696, 
  0.977677357824510, 0.2101118368804697, -0.977677357824510, 
  0.542750784864516, 0.839893794195999, -0.542750784864516, 
  -0.839893794196000, -0.839893794195999, 0.542750784864516, 
  0.839893794196000, -0.542750784864516, 0.822849781375826, 
  0.568258952670131, -0.822849781375826, -0.568258952670132, 
  -0.568258952670131, 0.822849781375826, 0.568258952670132, 
  -0.822849781375826, 0.1800229014056995, 0.983662419211730, 
  -0.1800229014056994, -0.983662419211730, -0.983662419211730, 
  0.1800229014056996, 0.983662419211730, -0.1800229014056995, 
  0.993564135520595, 0.1132709521775643, -0.993564135520595, 
  -0.1132709521775644, -0.1132709521775642, 0.993564135520595, 
  0.1132709521775643, -0.993564135520595, 0.622461279374150, 
  0.782650596166576, -0.622461279374150, -0.782650596166576, 
  -0.782650596166576, 0.622461279374150, 0.782650596166576, 
  -0.622461279374150, 0.874586652278176, 0.484869248000791, 
  -0.874586652278176, -0.484869248000791, -0.484869248000791, 
  0.874586652278176, 0.484869248000791, -0.874586652278176, 
  0.275571819310958, 0.961280485811321, -0.275571819310958, 
  -0.961280485811321, -0.961280485811321, 0.275571819310958, 
  0.961280485811321, -0.275571819310958, 0.952375012719766, 
  0.304929229735402, -0.952375012719766, -0.304929229735403, 
  -0.304929229735402, 0.952375012719766, 0.304929229735402, 
  -0.952375012719766, 0.457813303598877, 0.889048355854664, 
  -0.457813303598877, -0.889048355854665, -0.889048355854665, 
  0.457813303598877, 0.889048355854664, -0.457813303598877, 
  0.763188417263381, 0.646176012983316, -0.763188417263381, 
  -0.646176012983317, -0.646176012983316, 0.763188417263381, 
  0.646176012983316, -0.763188417263381, 0.0827402645493758, 
  0.996571145790555, -0.0827402645493757, -0.996571145790555, 
  -0.996571145790555, 0.0827402645493757, 0.996571145790555, 
  -0.0827402645493757, 0.997925286198596, 0.06438263092985747, 
  -0.997925286198596, -0.0643826309298577, -0.06438263092985731, 
  0.997925286198596, 0.06438263092985741, -0.997925286198596, 
  0.660114342067420, 0.751165131909686, -0.660114342067420, 
  -0.751165131909687, -0.751165131909686, 0.660114342067420, 
  0.751165131909686, -0.660114342067420, 0.897324580705418, 
  0.441371268731717, -0.897324580705418, -0.441371268731717, 
  -0.441371268731717, 0.897324580705418, 0.441371268731717, 
  -0.897324580705418, 0.322407678801070, 0.946600913083284, 
  -0.322407678801070, -0.946600913083284, -0.946600913083284, 
  0.322407678801070, 0.946600913083284, -0.322407678801070, 
  0.966190003445413, 0.257831102162159, -0.966190003445413, 
  -0.257831102162159, -0.257831102162159, 0.966190003445413, 
  0.257831102162159, -0.966190003445413, 0.500885382611241, 
  0.865513624090569, -0.500885382611241, -0.865513624090569, 
  -0.865513624090569, 0.500885382611241, 0.865513624090569, 
  -0.500885382611241, 0.793975477554337, 0.607949784967774, 
  -0.793975477554337, -0.607949784967774, -0.607949784967774, 
  0.793975477554337, 0.607949784967774, -0.793975477554337, 
  0.1315400287028833, 0.991310859846115, -0.1315400287028831, 
  -0.991310859846115, -0.991310859846115, 0.1315400287028833, 
  0.991310859846115, -0.1315400287028831, 0.986809401814185, 
  0.1618863937801118, -0.986809401814186, -0.1618863937801117, 
  -0.1618863937801118, 0.986809401814186, 0.1618863937801119, 
  -0.986809401814185, 0.583308652937698, 0.812250586585204, 
  -0.583308652937698, -0.812250586585204, -0.812250586585204, 
  0.583308652937699, 0.812250586585204, -0.583308652937698, 
  0.849741768000852, 0.527199134781901, -0.849741768000853, 
  -0.527199134781901, -0.527199134781901, 0.849741768000853, 
  0.527199134781901, -0.849741768000852, 0.2280720831708858, 
  0.973644249650812, -0.2280720831708857, -0.973644249650812, 
  -0.973644249650812, 0.228072083170886, 0.973644249650812, 
  -0.2280720831708857, 0.936265667170278, 0.351292756085567, 
  -0.936265667170278, -0.351292756085567, -0.351292756085567, 
  0.936265667170278, 0.351292756085567, -0.936265667170278, 
  0.413638312238435, 0.910441292258067, -0.413638312238435, 
  -0.910441292258067, -0.910441292258067, 0.413638312238435, 
  0.910441292258067, -0.413638312238435, 0.730562769227828, 
  0.682845546385248, -0.730562769227827, -0.682845546385248, 
  -0.682845546385248, 0.730562769227828, 0.682845546385248, 
  -0.730562769227827, 0.03374117185137764, 0.999430604555462, 
  -0.03374117185137751, -0.999430604555462, -0.999430604555462, 
  0.0337411718513777, 0.999430604555462, -0.03374117185137758, 
  0.999204758618364, 0.03987292758773981, -0.999204758618364, 
  -0.03987292758774013, -0.03987292758773972, 0.999204758618364, 
  0.03987292758773985, -0.999204758618364, 0.678350043129862, 
  0.734738878095963, -0.678350043129861, -0.734738878095964, 
  -0.734738878095963, 0.678350043129861, 0.734738878095963, 
  -0.678350043129861, 0.907886116487666, 0.419216888363224, 
  -0.907886116487666, -0.419216888363224, -0.419216888363224, 
  0.907886116487666, 0.419216888363224, -0.907886116487666, 
  0.345541324963989, 0.938403534063108, -0.345541324963989, 
  -0.938403534063108, -0.938403534063108, 0.345541324963989, 
  0.938403534063108, -0.345541324963989, 0.972226497078936, 
  0.2340419585835434, -0.972226497078936, -0.2340419585835435, 
  -0.2340419585835433, 0.972226497078936, 0.2340419585835435, 
  -0.972226497078936, 0.521975292937154, 0.852960604930364, 
  -0.521975292937154, -0.852960604930364, -0.852960604930364, 
  0.521975292937154, 0.852960604930364, -0.521975292937154, 
  0.808656181588175, 0.588281548222645, -0.808656181588175, 
  -0.588281548222645, -0.588281548222645, 0.808656181588175, 
  0.588281548222645, -0.808656181588175, 0.1558283976542653, 
  0.987784141644572, -0.1558283976542652, -0.987784141644572, 
  -0.987784141644572, 0.1558283976542654, 0.987784141644572, 
  -0.1558283976542652, 0.990485084256457, 0.137620121586486, 
  -0.990485084256457, -0.137620121586486, -0.1376201215864861, 
  0.990485084256457, 0.1376201215864862, -0.990485084256457, 
  0.603066598540348, 0.797690840943391, -0.603066598540348, 
  -0.797690840943391, -0.797690840943391, 0.603066598540348, 
  0.797690840943391, -0.603066598540348, 0.862423956111041, 
  0.506186645345155, -0.862423956111041, -0.506186645345155, 
  -0.506186645345155, 0.862423956111041, 0.506186645345155, 
  -0.862423956111041, 0.251897818154217, 0.967753837093476, 
  -0.251897818154217, -0.967753837093476, -0.967753837093476, 
  0.251897818154217, 0.967753837093476, -0.251897818154217, 
  0.944604837261480, 0.328209843579092, -0.944604837261480, 
  -0.328209843579093, -0.328209843579093, 0.944604837261480, 
  0.328209843579093, -0.944604837261480, 0.435857079922255, 
  0.900015892016160, -0.435857079922255, -0.900015892016160, 
  -0.900015892016160, 0.435857079922255, 0.900015892016160, 
  -0.435857079922255, 0.747100605980180, 0.664710978203345, 
  -0.747100605980180, -0.664710978203345, -0.664710978203345, 
  0.747100605980180, 0.664710978203345, -0.747100605980180, 
  0.05825826450043574, 0.998301544933893, -0.05825826450043561, 
  -0.998301544933893, -0.998301544933893, 0.0582582645004358, 
  0.998301544933893, -0.05825826450043575, 0.996044700901252, 
  0.0888535525825246, -0.996044700901252, -0.0888535525825248, 
  -0.0888535525825246, 0.996044700901252, 0.0888535525825247, 
  -0.996044700901252, 0.641481012808583, 0.767138911935820, 
  -0.641481012808583, -0.767138911935821, -0.767138911935820, 
  0.641481012808583, 0.767138911935821, -0.641481012808583, 
  0.886222530148881, 0.463259783551860, -0.886222530148881, 
  -0.463259783551860, -0.463259783551860, 0.886222530148881, 
  0.463259783551860, -0.886222530148881, 0.299079826308040, 
  0.954228095109106, -0.299079826308040, -0.954228095109106, 
  -0.954228095109106, 0.299079826308041, 0.954228095109106, 
  -0.299079826308040, 0.959571513081985, 0.281464937925758, 
  -0.959571513081985, -0.281464937925758, -0.281464937925758, 
  0.959571513081985, 0.281464937925758, -0.959571513081985, 
  0.479493757660153, 0.877545290207261, -0.479493757660153, 
  -0.877545290207261, -0.877545290207261, 0.479493757660153, 
  0.877545290207261, -0.479493757660153, 0.778816512381476, 
  0.627251815495144, -0.778816512381476, -0.627251815495144, 
  -0.627251815495144, 0.778816512381476, 0.627251815495144, 
  -0.778816512381476, 0.1071724249568089, 0.994240449453188, 
  -0.1071724249568088, -0.994240449453188, -0.994240449453188, 
  0.1071724249568092, 0.994240449453188, -0.1071724249568088, 
  0.982539302287441, 0.1860551516634466, -0.982539302287441, 
  -0.1860551516634469, -0.1860551516634465, 0.982539302287441, 
  0.1860551516634466, -0.982539302287441, 0.563199344013834, 
  0.826321062845663, -0.563199344013834, -0.826321062845664, 
  -0.826321062845663, 0.563199344013834, 0.826321062845664, 
  -0.563199344013834, 0.836547727223512, 0.547894059173100, 
  -0.836547727223512, -0.547894059173100, -0.547894059173100, 
  0.836547727223512, 0.547894059173100, -0.836547727223512, 
  0.204108966092817, 0.978948175319062, -0.2041089660928169, 
  -0.978948175319062, -0.978948175319062, 0.2041089660928169, 
  0.978948175319062, -0.2041089660928169, 0.927362525650401, 
  0.374164062971458, -0.927362525650401, -0.374164062971458, 
  -0.374164062971458, 0.927362525650401, 0.374164062971458, 
  -0.927362525650401, 0.391170384302254, 0.920318276709110, 
  -0.391170384302254, -0.920318276709111, -0.920318276709110, 
  0.391170384302254, 0.920318276709110, -0.391170384302254, 
  0.713584868780794, 0.700568793943248, -0.713584868780794, 
  -0.700568793943248, -0.700568793943248, 0.713584868780794, 
  0.700568793943248, -0.713584868780794, 0.00920375478205996, 
  0.999957644551964, -0.00920375478205984, -0.999957644551964, 
  -0.999957644551964, 0.00920375478206002, 0.999957644551964, 
  -0.00920375478205982, 0.999957644551964, 0.00920375478205982, 
  -0.999957644551964, -0.00920375478206002, -0.00920375478205984, 
  0.999957644551964, 0.00920375478205996, -0.999957644551964, 
  0.700568793943248, 0.713584868780794, -0.700568793943248, 
  -0.713584868780794, -0.713584868780794, 0.700568793943248, 
  0.713584868780794, -0.700568793943248, 0.920318276709110, 
  0.391170384302254, -0.920318276709110, -0.391170384302254, 
  -0.391170384302254, 0.920318276709111, 0.391170384302254, 
  -0.920318276709110, 0.374164062971458, 0.927362525650401, 
  -0.374164062971458, -0.927362525650401, -0.927362525650401, 
  0.374164062971458, 0.927362525650401, -0.374164062971458, 
  0.978948175319062, 0.2041089660928169, -0.978948175319062, 
  -0.2041089660928169, -0.2041089660928169, 0.978948175319062, 
  0.204108966092817, -0.978948175319062, 0.547894059173100, 
  0.836547727223512, -0.547894059173100, -0.836547727223512, 
  -0.836547727223512, 0.547894059173100, 0.836547727223512, 
  -0.547894059173100, 0.826321062845664, 0.563199344013834, 
  -0.826321062845663, -0.563199344013834, -0.563199344013834, 
  0.826321062845664, 0.563199344013834, -0.826321062845663, 
  0.1860551516634466, 0.982539302287441, -0.1860551516634465, 
  -0.982539302287441, -0.982539302287441, 0.1860551516634469, 
  0.982539302287441, -0.1860551516634466, 0.994240449453188, 
  0.1071724249568088, -0.994240449453188, -0.1071724249568092, 
  -0.1071724249568088, 0.994240449453188, 0.1071724249568089, 
  -0.994240449453188, 0.627251815495144, 0.778816512381476, 
  -0.627251815495144, -0.778816512381476, -0.778816512381476, 
  0.627251815495144, 0.778816512381476, -0.627251815495144, 
  0.877545290207261, 0.479493757660153, -0.877545290207261, 
  -0.479493757660153, -0.479493757660153, 0.877545290207261, 
  0.479493757660153, -0.877545290207261, 0.281464937925758, 
  0.959571513081985, -0.281464937925758, -0.959571513081985, 
  -0.959571513081985, 0.281464937925758, 0.959571513081985, 
  -0.281464937925758, 0.954228095109106, 0.299079826308040, 
  -0.954228095109106, -0.299079826308041, -0.299079826308040, 
  0.954228095109106, 0.299079826308040, -0.954228095109106, 
  0.463259783551860, 0.886222530148881, -0.463259783551860, 
  -0.886222530148881, -0.886222530148881, 0.463259783551860, 
  0.886222530148881, -0.463259783551860, 0.767138911935821, 
  0.641481012808583, -0.767138911935820, -0.641481012808583, 
  -0.641481012808583, 0.767138911935821, 0.641481012808583, 
  -0.767138911935820, 0.0888535525825247, 0.996044700901252, 
  -0.0888535525825246, -0.996044700901252, -0.996044700901252, 
  0.0888535525825248, 0.996044700901252, -0.0888535525825246, 
  0.998301544933893, 0.05825826450043575, -0.998301544933893, 
  -0.0582582645004358, -0.05825826450043561, 0.998301544933893, 
  0.05825826450043574, -0.998301544933893, 0.664710978203345, 
  0.747100605980180, -0.664710978203345, -0.747100605980180, 
  -0.747100605980180, 0.664710978203345, 0.747100605980180, 
  -0.664710978203345, 0.900015892016160, 0.435857079922255, 
  -0.900015892016160, -0.435857079922255, -0.435857079922255, 
  0.900015892016160, 0.435857079922255, -0.900015892016160, 
  0.328209843579093, 0.944604837261480, -0.328209843579093, 
  -0.944604837261480, -0.944604837261480, 0.328209843579093, 
  0.944604837261480, -0.328209843579092, 0.967753837093476, 
  0.251897818154217, -0.967753837093476, -0.251897818154217, 
  -0.251897818154217, 0.967753837093476, 0.251897818154217, 
  -0.967753837093476, 0.506186645345155, 0.862423956111041, 
  -0.506186645345155, -0.862423956111041, -0.862423956111041, 
  0.506186645345155, 0.862423956111041, -0.506186645345155, 
  0.797690840943391, 0.603066598540348, -0.797690840943391, 
  -0.603066598540348, -0.603066598540348, 0.797690840943391, 
  0.603066598540348, -0.797690840943391, 0.1376201215864862, 
  0.990485084256457, -0.1376201215864861, -0.990485084256457, 
  -0.990485084256457, 0.137620121586486, 0.990485084256457, 
  -0.137620121586486, 0.987784141644572, 0.1558283976542652, 
  -0.987784141644572, -0.1558283976542654, -0.1558283976542652, 
  0.987784141644572, 0.1558283976542653, -0.987784141644572, 
  0.588281548222645, 0.808656181588175, -0.588281548222645, 
  -0.808656181588175, -0.808656181588175, 0.588281548222645, 
  0.808656181588175, -0.588281548222645, 0.852960604930364, 
  0.521975292937154, -0.852960604930364, -0.521975292937154, 
  -0.521975292937154, 0.852960604930364, 0.521975292937154, 
  -0.852960604930364, 0.2340419585835435, 0.972226497078936, 
  -0.2340419585835433, -0.972226497078936, -0.972226497078936, 
  0.2340419585835435, 0.972226497078936, -0.2340419585835434, 
  0.938403534063108, 0.345541324963989, -0.938403534063108, 
  -0.345541324963989, -0.345541324963989, 0.938403534063108, 
  0.345541324963989, -0.938403534063108, 0.419216888363224, 
  0.907886116487666, -0.419216888363224, -0.907886116487666, 
  -0.907886116487666, 0.419216888363224, 0.907886116487666, 
  -0.419216888363224, 0.734738878095963, 0.678350043129861, 
  -0.734738878095963, -0.678350043129861, -0.678350043129861, 
  0.734738878095964, 0.678350043129862, -0.734738878095963, 
  0.03987292758773985, 0.999204758618364, -0.03987292758773972, 
  -0.999204758618364, -0.999204758618364, 0.03987292758774013, 
  0.999204758618364, -0.03987292758773981, 0.999430604555462, 
  0.03374117185137758, -0.999430604555462, -0.0337411718513777, 
  -0.03374117185137751, 0.999430604555462, 0.03374117185137764, 
  -0.999430604555462, 0.682845546385248, 0.730562769227827, 
  -0.682845546385248, -0.730562769227828, -0.730562769227827, 
  0.682845546385248, 0.730562769227828, -0.682845546385248, 
  0.910441292258067, 0.413638312238435, -0.910441292258067, 
  -0.413638312238435, -0.413638312238435, 0.910441292258067, 
  0.413638312238435, -0.910441292258067, 0.351292756085567, 
  0.936265667170278, -0.351292756085567, -0.936265667170278, 
  -0.936265667170278, 0.351292756085567, 0.936265667170278, 
  -0.351292756085567, 0.973644249650812, 0.2280720831708857, 
  -0.973644249650812, -0.228072083170886, -0.2280720831708857, 
  0.973644249650812, 0.2280720831708858, -0.973644249650812, 
  0.527199134781901, 0.849741768000852, -0.527199134781901, 
  -0.849741768000853, -0.849741768000853, 0.527199134781901, 
  0.849741768000852, -0.527199134781901, 0.812250586585204, 
  0.583308652937698, -0.812250586585204, -0.583308652937699, 
  -0.583308652937698, 0.812250586585204, 0.583308652937698, 
  -0.812250586585204, 0.1618863937801119, 0.986809401814185, 
  -0.1618863937801118, -0.986809401814186, -0.986809401814186, 
  0.1618863937801117, 0.986809401814185, -0.1618863937801118, 
  0.991310859846115, 0.1315400287028831, -0.991310859846115, 
  -0.1315400287028833, -0.1315400287028831, 0.991310859846115, 
  0.1315400287028833, -0.991310859846115, 0.607949784967774, 
  0.793975477554337, -0.607949784967774, -0.793975477554337, 
  -0.793975477554337, 0.607949784967774, 0.793975477554337, 
  -0.607949784967774, 0.865513624090569, 0.500885382611241, 
  -0.865513624090569, -0.500885382611241, -0.500885382611241, 
  0.865513624090569, 0.500885382611241, -0.865513624090569, 
  0.257831102162159, 0.966190003445413, -0.257831102162159, 
  -0.966190003445413, -0.966190003445413, 0.257831102162159, 
  0.966190003445413, -0.257831102162159, 0.946600913083284, 
  0.322407678801070, -0.946600913083284, -0.322407678801070, 
  -0.322407678801070, 0.946600913083284, 0.322407678801070, 
  -0.946600913083284, 0.441371268731717, 0.897324580705418, 
  -0.441371268731717, -0.897324580705418, -0.897324580705418, 
  0.441371268731717, 0.897324580705418, -0.441371268731717, 
  0.751165131909686, 0.660114342067420, -0.751165131909686, 
  -0.660114342067420, -0.660114342067420, 0.751165131909687, 
  0.660114342067420, -0.751165131909686, 0.06438263092985741, 
  0.997925286198596, -0.06438263092985731, -0.997925286198596, 
  -0.997925286198596, 0.0643826309298577, 0.997925286198596, 
  -0.06438263092985747, 0.996571145790555, 0.0827402645493757, 
  -0.996571145790555, -0.0827402645493757, -0.0827402645493757, 
  0.996571145790555, 0.0827402645493758, -0.996571145790555, 
  0.646176012983316, 0.763188417263381, -0.646176012983316, 
  -0.763188417263381, -0.763188417263381, 0.646176012983317, 
  0.763188417263381, -0.646176012983316, 0.889048355854664, 
  0.457813303598877, -0.889048355854665, -0.457813303598877, 
  -0.457813303598877, 0.889048355854665, 0.457813303598877, 
  -0.889048355854664, 0.304929229735402, 0.952375012719766, 
  -0.304929229735402, -0.952375012719766, -0.952375012719766, 
  0.304929229735403, 0.952375012719766, -0.304929229735402, 
  0.961280485811321, 0.275571819310958, -0.961280485811321, 
  -0.275571819310958, -0.275571819310958, 0.961280485811321, 
  0.275571819310958, -0.961280485811321, 0.484869248000791, 
  0.874586652278176, -0.484869248000791, -0.874586652278176, 
  -0.874586652278176, 0.484869248000791, 0.874586652278176, 
  -0.484869248000791, 0.782650596166576, 0.622461279374150, 
  -0.782650596166576, -0.622461279374150, -0.622461279374150, 
  0.782650596166576, 0.622461279374150, -0.782650596166576, 
  0.1132709521775643, 0.993564135520595, -0.1132709521775642, 
  -0.993564135520595, -0.993564135520595, 0.1132709521775644, 
  0.993564135520595, -0.1132709521775643, 0.983662419211730, 
  0.1800229014056995, -0.983662419211730, -0.1800229014056996, 
  -0.1800229014056994, 0.983662419211730, 0.1800229014056995, 
  -0.983662419211730, 0.568258952670132, 0.822849781375826, 
  -0.568258952670131, -0.822849781375826, -0.822849781375826, 
  0.568258952670132, 0.822849781375826, -0.568258952670131, 
  0.839893794196000, 0.542750784864516, -0.839893794195999, 
  -0.542750784864516, -0.542750784864516, 0.839893794196000, 
  0.542750784864516, -0.839893794195999, 0.2101118368804697, 
  0.977677357824510, -0.2101118368804696, -0.977677357824510, 
  -0.977677357824510, 0.2101118368804698, 0.977677357824510, 
  -0.2101118368804696, 0.929640895843181, 0.368466829953372, 
  -0.929640895843181, -0.368466829953373, -0.368466829953372, 
  0.929640895843181, 0.368466829953372, -0.929640895843181, 
  0.396809987416710, 0.917900775621390, -0.396809987416710, 
  -0.917900775621390, -0.917900775621390, 0.396809987416710, 
  0.917900775621390, -0.396809987416710, 0.717870045055732, 
  0.696177131491463, -0.717870045055731, -0.696177131491463, 
  -0.696177131491463, 0.717870045055732, 0.696177131491463, 
  -0.717870045055732, 0.01533920628498822, 0.999882347454212, 
  -0.0153392062849881, -0.999882347454212, -0.999882347454212, 
  0.01533920628498806, 0.999882347454212, -0.0153392062849881, 
  0.999769405351215, 0.02147408027546951, -0.999769405351215, 
  -0.02147408027546967, -0.02147408027546948, 0.999769405351215, 
  0.02147408027546961, -0.999769405351215, 0.691759258364158, 
  0.722128193929215, -0.691759258364158, -0.722128193929215, 
  -0.722128193929215, 0.691759258364158, 0.722128193929215, 
  -0.691759258364158, 0.915448716088268, 0.402434650859418, 
  -0.915448716088268, -0.402434650859419, -0.402434650859418, 
  0.915448716088268, 0.402434650859418, -0.915448716088268, 
  0.362755724367397, 0.931884265581668, -0.362755724367397, 
  -0.931884265581668, -0.931884265581668, 0.362755724367397, 
  0.931884265581668, -0.362755724367397, 0.976369731330021, 
  0.2161067970762195, -0.976369731330021, -0.2161067970762194, 
  -0.2161067970762195, 0.976369731330021, 0.2161067970762196, 
  -0.976369731330021, 0.537587076295646, 0.843208239641845, 
  -0.537587076295646, -0.843208239641845, -0.843208239641845, 
  0.537587076295646, 0.843208239641845, -0.537587076295645, 
  0.819347520076797, 0.573297166698042, -0.819347520076797, 
  -0.573297166698042, -0.573297166698042, 0.819347520076797, 
  0.573297166698042, -0.819347520076797, 0.1739838733874639, 
  0.984748501801904, -0.1739838733874637, -0.984748501801904, 
  -0.984748501801904, 0.1739838733874641, 0.984748501801904, 
  -0.1739838733874638, 0.992850414459865, 0.1193652148109914, 
  -0.992850414459865, -0.1193652148109916, -0.1193652148109912, 
  0.992850414459865, 0.1193652148109913, -0.992850414459865, 
  0.617647307937804, 0.786455213599086, -0.617647307937804, 
  -0.786455213599086, -0.786455213599086, 0.617647307937804, 
  0.786455213599086, -0.617647307937804, 0.871595086655951, 
  0.490226483288291, -0.871595086655951, -0.490226483288291, 
  -0.490226483288291, 0.871595086655951, 0.490226483288291, 
  -0.871595086655951, 0.269668325572915, 0.962953266873684, 
  -0.269668325572915, -0.962953266873684, -0.962953266873684, 
  0.269668325572915, 0.962953266873684, -0.269668325572915, 
  0.950486073949482, 0.310767152749611, -0.950486073949482, 
  -0.310767152749612, -0.310767152749611, 0.950486073949482, 
  0.310767152749611, -0.950486073949482, 0.452349587233771, 
  0.891840709392343, -0.452349587233771, -0.891840709392343, 
  -0.891840709392343, 0.452349587233771, 0.891840709392343, 
  -0.452349587233771, 0.759209188978388, 0.650846684996381, 
  -0.759209188978388, -0.650846684996381, -0.650846684996381, 
  0.759209188978388, 0.650846684996381, -0.759209188978388, 
  0.07662386139203161, 0.997060070339483, -0.0766238613920315, 
  -0.997060070339483, -0.997060070339483, 0.07662386139203169, 
  0.997060070339483, -0.0766238613920315, 0.997511456140303, 
  0.07050457338961386, -0.997511456140303, -0.07050457338961386, 
  -0.07050457338961391, 0.997511456140303, 0.07050457338961401, 
  -0.997511456140303, 0.655492852999615, 0.755201376896536, 
  -0.655492852999615, -0.755201376896536, -0.755201376896536, 
  0.655492852999616, 0.755201376896537, -0.655492852999615, 
  0.894599485631383, 0.446868840162374, -0.894599485631383, 
  -0.446868840162374, -0.446868840162374, 0.894599485631383, 
  0.446868840162374, -0.894599485631383, 0.316593375556166, 
  0.948561349915730, -0.316593375556166, -0.948561349915730, 
  -0.948561349915730, 0.316593375556166, 0.948561349915730, 
  -0.316593375556166, 0.964589793289813, 0.263754678974831, 
  -0.964589793289813, -0.263754678974832, -0.263754678974831, 
  0.964589793289813, 0.263754678974832, -0.964589793289813, 
  0.495565261825773, 0.868570705971341, -0.495565261825772, 
  -0.868570705971341, -0.868570705971341, 0.495565261825773, 
  0.868570705971341, -0.495565261825773, 0.790230221437310, 
  0.612810082429410, -0.790230221437310, -0.612810082429410, 
  -0.612810082429410, 0.790230221437310, 0.612810082429410, 
  -0.790230221437310, 0.1254549834115462, 0.992099313142192, 
  -0.1254549834115461, -0.992099313142192, -0.992099313142192, 
  0.1254549834115463, 0.992099313142192, -0.1254549834115462, 
  0.985797509167567, 0.1679382949747312, -0.985797509167567, 
  -0.1679382949747312, -0.1679382949747311, 0.985797509167567, 
  0.1679382949747312, -0.985797509167567, 0.578313796411656, 
  0.815814410806734, -0.578313796411655, -0.815814410806734, 
  -0.815814410806734, 0.578313796411656, 0.815814410806734, 
  -0.578313796411656, 0.846490938774052, 0.532403127877198, 
  -0.846490938774052, -0.532403127877198, -0.532403127877198, 
  0.846490938774052, 0.532403127877198, -0.846490938774052, 
  0.2220936209732036, 0.975025345066994, -0.2220936209732035, 
  -0.975025345066994, -0.975025345066994, 0.2220936209732037, 
  0.975025345066994, -0.2220936209732035, 0.934092550404259, 
  0.357030961233430, -0.934092550404259, -0.357030961233430, 
  -0.357030961233430, 0.934092550404259, 0.357030961233430, 
  -0.934092550404259, 0.408044162864979, 0.912962190428398, 
  -0.408044162864979, -0.912962190428398, -0.912962190428398, 
  0.408044162864979, 0.912962190428398, -0.408044162864979, 
  0.726359155084346, 0.687315340891759, -0.726359155084346, 
  -0.687315340891759, -0.687315340891759, 0.726359155084346, 
  0.687315340891759, -0.726359155084346, 0.02760814577896582, 
  0.999618822495179, -0.02760814577896569, -0.999618822495179, 
  -0.999618822495179, 0.02760814577896565, 0.999618822495179, 
  -0.02760814577896574, 0.998941293186857, 0.04600318213091463, 
  -0.998941293186857, -0.04600318213091471, -0.04600318213091452, 
  0.998941293186857, 0.04600318213091465, -0.998941293186857, 
  0.673829000378756, 0.738887324460615, -0.673829000378756, 
  -0.738887324460615, -0.738887324460615, 0.673829000378756, 
  0.738887324460615, -0.673829000378756, 0.905296759318119, 
  0.424779681209109, -0.905296759318119, -0.424779681209109, 
  -0.424779681209109, 0.905296759318119, 0.424779681209109, 
  -0.905296759318119, 0.339776884406827, 0.940506070593268, 
  -0.339776884406827, -0.940506070593268, -0.940506070593268, 
  0.339776884406827, 0.940506070593268, -0.339776884406827, 
  0.970772140728950, 0.2400030224487415, -0.970772140728950, 
  -0.2400030224487418, -0.2400030224487414, 0.970772140728950, 
  0.2400030224487415, -0.970772140728950, 0.516731799017650, 
  0.856147328375194, -0.516731799017650, -0.856147328375195, 
  -0.856147328375195, 0.516731799017650, 0.856147328375194, 
  -0.516731799017650, 0.805031331142964, 0.593232295039800, 
  -0.805031331142963, -0.593232295039800, -0.593232295039800, 
  0.805031331142964, 0.593232295039800, -0.805031331142964, 
  0.1497645346773216, 0.988721691960324, -0.1497645346773215, 
  -0.988721691960324, -0.988721691960324, 0.1497645346773214, 
  0.988721691960324, -0.1497645346773215, 0.989622017463201, 
  0.1436950331502945, -0.989622017463201, -0.1436950331502946, 
  -0.1436950331502945, 0.989622017463201, 0.1436950331502946, 
  -0.989622017463201, 0.598160706996342, 0.801376171723140, 
  -0.598160706996342, -0.801376171723140, -0.801376171723140, 
  0.598160706996342, 0.801376171723140, -0.598160706996342, 
  0.859301818357008, 0.511468850437970, -0.859301818357008, 
  -0.511468850437971, -0.511468850437970, 0.859301818357008, 
  0.511468850437971, -0.859301818357008, 0.2459550503357946, 
  0.969281235356549, -0.2459550503357945, -0.969281235356549, 
  -0.969281235356549, 0.2459550503357947, 0.969281235356549, 
  -0.2459550503357946, 0.942573197601447, 0.333999651442009, 
  -0.942573197601447, -0.333999651442009, -0.333999651442009, 
  0.942573197601447, 0.333999651442009, -0.942573197601447, 
  0.430326481340083, 0.902673318237259, -0.430326481340083, 
  -0.902673318237259, -0.902673318237259, 0.430326481340083, 
  0.902673318237259, -0.430326481340083, 0.743007952135122, 
  0.669282588346636, -0.743007952135122, -0.669282588346636, 
  -0.669282588346636, 0.743007952135122, 0.669282588346636, 
  -0.743007952135122, 0.05213170468028333, 0.998640218180265, 
  -0.05213170468028319, -0.998640218180265, -0.998640218180265, 
  0.0521317046802836, 0.998640218180265, -0.05213170468028333, 
  0.995480755491927, 0.094963495329639, -0.995480755491927, 
  -0.0949634953296389, -0.0949634953296389, 0.995480755491927, 
  0.0949634953296391, -0.995480755491927, 0.636761861236284, 
  0.771060524261814, -0.636761861236284, -0.771060524261814, 
  -0.771060524261813, 0.636761861236284, 0.771060524261814, 
  -0.636761861236284, 0.883363338665732, 0.468688822035828, 
  -0.883363338665732, -0.468688822035828, -0.468688822035828, 
  0.883363338665732, 0.468688822035828, -0.883363338665732, 
  0.293219162694259, 0.956045251349996, -0.293219162694259, 
  -0.956045251349996, -0.956045251349996, 0.293219162694259, 
  0.956045251349996, -0.293219162694259, 0.957826413027533, 
  0.287347459544730, -0.957826413027533, -0.287347459544730, 
  -0.287347459544729, 0.957826413027533, 0.287347459544730, 
  -0.957826413027533, 0.474100214650550, 0.880470889052161, 
  -0.474100214650550, -0.880470889052161, -0.880470889052161, 
  0.474100214650550, 0.880470889052161, -0.474100214650550, 
  0.774953106594874, 0.632018735939809, -0.774953106594874, 
  -0.632018735939809, -0.632018735939809, 0.774953106594874, 
  0.632018735939809, -0.774953106594874, 0.1010698627548278, 
  0.994879330794806, -0.1010698627548277, -0.994879330794806, 
  -0.994879330794806, 0.1010698627548279, 0.994879330794806, 
  -0.1010698627548278, 0.981379193313755, 0.1920803970498924, 
  -0.981379193313755, -0.1920803970498924, -0.1920803970498923, 
  0.981379193313755, 0.1920803970498924, -0.981379193313755, 
  0.558118531220556, 0.829761233794523, -0.558118531220556, 
  -0.829761233794523, -0.829761233794523, 0.558118531220556, 
  0.829761233794523, -0.558118531220556, 0.833170164701913, 
  0.553016705580027, -0.833170164701913, -0.553016705580027, 
  -0.553016705580027, 0.833170164701913, 0.553016705580028, 
  -0.833170164701913, 0.1980984107179537, 0.980182135968117, 
  -0.1980984107179536, -0.980182135968117, -0.980182135968117, 
  0.1980984107179538, 0.980182135968117, -0.1980984107179535, 
  0.925049240782677, 0.379847208924051, -0.925049240782677, 
  -0.379847208924051, -0.379847208924051, 0.925049240782678, 
  0.379847208924051, -0.925049240782678, 0.385516053843919, 
  0.922701128333879, -0.385516053843919, -0.922701128333879, 
  -0.922701128333879, 0.385516053843919, 0.922701128333879, 
  -0.385516053843919, 0.709272826438866, 0.704934080375905, 
  -0.709272826438865, -0.704934080375905, -0.704934080375905, 
  0.709272826438866, 0.704934080375905, -0.709272826438866, 
  0.003067956762966138, 0.999995293809576, -0.003067956762966015, 
  -0.999995293809576, -0.999995293809576, 0.003067956762965977, 
  0.999995293809576, -0.003067956762965976, 0.999998823451702, 
  0.001533980186284765, -0.999998823451702, -0.001533980186285049, 
  -0.001533980186284644, 0.999998823451702, 0.001533980186284766, 
  -0.999998823451702, 0.706021261449340, 0.708190637033195, 
  -0.706021261449340, -0.708190637033196, -0.708190637033195, 
  0.706021261449340, 0.708190637033195, -0.706021261449340, 
  0.923291416719528, 0.384100195016935, -0.923291416719528, 
  -0.384100195016935, -0.384100195016935, 0.923291416719528, 
  0.384100195016935, -0.923291416719528, 0.381265769222162, 
  0.924465474325263, -0.381265769222162, -0.924465474325263, 
  -0.924465474325263, 0.381265769222162, 0.924465474325263, 
  -0.381265769222162, 0.980484861773469, 0.1965945976700802, 
  -0.980484861773469, -0.1965945976700803, -0.1965945976700801, 
  0.980484861773469, 0.1965945976700802, -0.980484861773469, 
  0.554294121453620, 0.832320867767930, -0.554294121453620, 
  -0.832320867767930, -0.832320867767929, 0.554294121453620, 
  0.832320867767930, -0.554294121453620, 0.830616400308846, 
  0.556845037275160, -0.830616400308846, -0.556845037275160, 
  -0.556845037275160, 0.830616400308846, 0.556845037275160, 
  -0.830616400308846, 0.1935855872958037, 0.981083391150487, 
  -0.1935855872958036, -0.981083391150487, -0.981083391150487, 
  0.1935855872958038, 0.981083391150487, -0.1935855872958036, 
  0.995033199438119, 0.0995436186600693, -0.995033199438119, 
  -0.0995436186600693, -0.0995436186600693, 0.995033199438119, 
  0.0995436186600694, -0.995033199438119, 0.633206755050057, 
  0.773982690606823, -0.633206755050057, -0.773982690606823, 
  -0.773982690606823, 0.633206755050057, 0.773982690606823, 
  -0.633206755050057, 0.881197113471222, 0.472749031950343, 
  -0.881197113471222, -0.472749031950343, -0.472749031950343, 
  0.881197113471222, 0.472749031950343, -0.881197113471222, 
  0.288816408206049, 0.957384500788976, -0.288816408206049, 
  -0.957384500788976, -0.957384500788976, 0.288816408206050, 
  0.957384500788976, -0.288816408206049, 0.956493918902395, 
  0.291752263234989, -0.956493918902395, -0.291752263234989, 
  -0.291752263234989, 0.956493918902395, 0.291752263234989, 
  -0.956493918902395, 0.470043332459596, 0.882643339979563, 
  -0.470043332459596, -0.882643339979563, -0.882643339979563, 
  0.470043332459596, 0.882643339979563, -0.470043332459596, 
  0.772036397150385, 0.635578320488556, -0.772036397150384, 
  -0.635578320488556, -0.635578320488556, 0.772036397150385, 
  0.635578320488556, -0.772036397150384, 0.0964904313552526, 
  0.995333912140482, -0.0964904313552525, -0.995333912140482, 
  -0.995333912140482, 0.0964904313552527, 0.995333912140482, 
  -0.0964904313552526, 0.998719012233873, 0.05059974903689928, 
  -0.998719012233873, -0.05059974903689941, -0.05059974903689922, 
  0.998719012233873, 0.05059974903689933, -0.998719012233873, 
  0.670421560380173, 0.741980411720831, -0.670421560380173, 
  -0.741980411720831, -0.741980411720831, 0.670421560380173, 
  0.741980411720831, -0.670421560380173, 0.903332368494512, 
  0.428941292055329, -0.903332368494512, -0.428941292055330, 
  -0.428941292055329, 0.903332368494512, 0.428941292055330, 
  -0.903332368494512, 0.335445147084532, 0.942059739771017, 
  -0.335445147084532, -0.942059739771017, -0.942059739771017, 
  0.335445147084532, 0.942059739771017, -0.335445147084532, 
  0.969657385124292, 0.2444679027478242, -0.969657385124292, 
  -0.2444679027478245, -0.2444679027478241, 0.969657385124292, 
  0.2444679027478242, -0.969657385124292, 0.512786400633563, 
  0.858516224264443, -0.512786400633563, -0.858516224264443, 
  -0.858516224264443, 0.512786400633563, 0.858516224264443, 
  -0.512786400633563, 0.802292795538116, 0.596930708062196, 
  -0.802292795538115, -0.596930708062197, -0.596930708062197, 
  0.802292795538116, 0.596930708062197, -0.802292795538116, 
  0.1452129246528475, 0.989400427791380, -0.1452129246528474, 
  -0.989400427791380, -0.989400427791380, 0.1452129246528473, 
  0.989400427791380, -0.1452129246528475, 0.988950264510303, 
  0.148247678986896, -0.988950264510303, -0.1482476789868963, 
  -0.1482476789868961, 0.988950264510303, 0.1482476789868962, 
  -0.988950264510303, 0.594466499184665, 0.804120377398266, 
  -0.594466499184664, -0.804120377398266, -0.804120377398266, 
  0.594466499184664, 0.804120377398266, -0.594466499184664, 
  0.856938977417829, 0.515417878019463, -0.856938977417829, 
  -0.515417878019463, -0.515417878019463, 0.856938977417829, 
  0.515417878019463, -0.856938977417829, 0.2414918853028693, 
  0.970402838687556, -0.2414918853028692, -0.970402838687556, 
  -0.970402838687556, 0.2414918853028693, 0.970402838687556, 
  -0.2414918853028693, 0.941026175050889, 0.338333766965541, 
  -0.941026175050889, -0.338333766965541, -0.338333766965541, 
  0.941026175050889, 0.338333766965541, -0.941026175050889, 
  0.426167888726800, 0.904644090578246, -0.426167888726800, 
  -0.904644090578246, -0.904644090578246, 0.426167888726800, 
  0.904644090578246, -0.426167888726800, 0.739920095459516, 
  0.672694769070773, -0.739920095459516, -0.672694769070773, 
  -0.672694769070773, 0.739920095459516, 0.672694769070773, 
  -0.739920095459516, 0.04753548415695926, 0.998869549914284, 
  -0.04753548415695914, -0.998869549914284, -0.998869549914284, 
  0.04753548415695955, 0.998869549914284, -0.04753548415695931, 
  0.999659996743959, 0.0260747178291039, -0.999659996743959, 
  -0.0260747178291041, -0.02607471782910391, 0.999659996743959, 
  0.02607471782910404, -0.999659996743959, 0.688428752784091, 
  0.725303972373061, -0.688428752784090, -0.725303972373061, 
  -0.725303972373061, 0.688428752784090, 0.725303972373061, 
  -0.688428752784090, 0.913587047945251, 0.406643216870369, 
  -0.913587047945251, -0.406643216870369, -0.406643216870369, 
  0.913587047945251, 0.406643216870369, -0.913587047945251, 
  0.358463420633737, 0.933543772978836, -0.358463420633736, 
  -0.933543772978836, -0.933543772978836, 0.358463420633737, 
  0.933543772978836, -0.358463420633737, 0.975364885116657, 
  0.2205976901088735, -0.975364885116657, -0.2205976901088735, 
  -0.2205976901088735, 0.975364885116657, 0.2205976901088737, 
  -0.975364885116657, 0.533701001807153, 0.845673246987299, 
  -0.533701001807153, -0.845673246987299, -0.845673246987299, 
  0.533701001807153, 0.845673246987299, -0.533701001807153, 
  0.816700572866828, 0.577061672855679, -0.816700572866828, 
  -0.577061672855679, -0.577061672855679, 0.816700572866828, 
  0.577061672855680, -0.816700572866828, 0.1694502912339679, 
  0.985538735312176, -0.1694502912339678, -0.985538735312176, 
  -0.985538735312176, 0.1694502912339682, 0.985538735312176, 
  -0.169450291233968, 0.992290591348257, 0.1239329751185122, 
  -0.992290591348257, -0.1239329751185125, -0.1239329751185121, 
  0.992290591348257, 0.1239329751185122, -0.992290591348257, 
  0.614021558931038, 0.789289253168886, -0.614021558931038, 
  -0.789289253168886, -0.789289253168886, 0.614021558931038, 
  0.789289253168886, -0.614021558931038, 0.869329871348607, 
  0.494232308515960, -0.869329871348607, -0.494232308515960, 
  -0.494232308515960, 0.869329871348607, 0.494232308515960, 
  -0.869329871348607, 0.265234030285512, 0.964184063951746, 
  -0.265234030285512, -0.964184063951746, -0.964184063951746, 
  0.265234030285512, 0.964184063951746, -0.265234030285512, 
  0.949045881852701, 0.315137928752522, -0.949045881852701, 
  -0.315137928752522, -0.315137928752522, 0.949045881852701, 
  0.315137928752522, -0.949045881852701, 0.448240612285220, 
  0.893912945145203, -0.448240612285220, -0.893912945145203, 
  -0.893912945145203, 0.448240612285220, 0.893912945145203, 
  -0.448240612285220, 0.756206001414395, 0.654333617831800, 
  -0.756206001414394, -0.654333617831801, -0.654333617831800, 
  0.756206001414395, 0.654333617831801, -0.756206001414395, 
  0.07203465324688941, 0.997402129901275, -0.07203465324688931, 
  -0.997402129901275, -0.997402129901275, 0.07203465324688949, 
  0.997402129901275, -0.07203465324688933, 0.997176436735326, 
  0.07509430084792131, -0.997176436735326, -0.07509430084792135, 
  -0.07509430084792117, 0.997176436735326, 0.07509430084792128, 
  -0.997176436735326, 0.652010531096960, 0.758209909813015, 
  -0.652010531096960, -0.758209909813015, -0.758209909813015, 
  0.652010531096960, 0.758209909813015, -0.652010531096960, 
  0.892533555402765, 0.450980989045104, -0.892533555402765, 
  -0.450980989045104, -0.450980989045104, 0.892533555402765, 
  0.450980989045104, -0.892533555402765, 0.312224813921825, 
  0.950008245001843, -0.312224813921825, -0.950008245001843, 
  -0.950008245001843, 0.312224813921825, 0.950008245001843, 
  -0.312224813921825, 0.963365799780954, 0.268190857063403, 
  -0.963365799780954, -0.268190857063403, -0.268190857063403, 
  0.963365799780954, 0.268190857063403, -0.963365799780954, 
  0.491562916106550, 0.870842063470079, -0.491562916106550, 
  -0.870842063470079, -0.870842063470079, 0.491562916106550, 
  0.870842063470079, -0.491562916106550, 0.787401747029031, 
  0.616440174530854, -0.787401747029031, -0.616440174530854, 
  -0.616440174530854, 0.787401747029031, 0.616440174530854, 
  -0.787401747029031, 0.1208880872357772, 0.992666142448948, 
  -0.1208880872357771, -0.992666142448948, -0.992666142448948, 
  0.1208880872357771, 0.992666142448948, -0.1208880872357771, 
  0.985014231012240, 0.1724730839967959, -0.985014231012240, 
  -0.1724730839967961, -0.1724730839967959, 0.985014231012240, 
  0.172473083996796, -0.985014231012240, 0.574553355047716, 
  0.818467129580299, -0.574553355047716, -0.818467129580299, 
  -0.818467129580299, 0.574553355047716, 0.818467129580299, 
  -0.574553355047716, 0.844031895490066, 0.536292979065963, 
  -0.844031895490066, -0.536292979065963, -0.536292979065963, 
  0.844031895490067, 0.536292979065963, -0.844031895490066, 
  0.2176042746384837, 0.976037079039039, -0.2176042746384835, 
  -0.976037079039039, -0.976037079039039, 0.2176042746384837, 
  0.976037079039039, -0.2176042746384836, 0.932439629268462, 
  0.361325805568454, -0.932439629268462, -0.361325805568454, 
  -0.361325805568454, 0.932439629268462, 0.361325805568454, 
  -0.932439629268462, 0.403838457567654, 0.914830312237946, 
  -0.403838457567654, -0.914830312237946, -0.914830312237946, 
  0.403838457567654, 0.914830312237946, -0.403838457567654, 
  0.723188489306527, 0.690650714134535, -0.723188489306527, 
  -0.690650714134534, -0.690650714134534, 0.723188489306528, 
  0.690650714134535, -0.723188489306527, 0.02300768146883941, 
  0.999735288260562, -0.02300768146883929, -0.999735288260562, 
  -0.999735288260562, 0.02300768146883969, 0.999735288260562, 
  -0.02300768146883937, 0.999904701082853, 0.01380538852806039, 
  -0.999904701082853, -0.01380538852806063, -0.01380538852806023, 
  0.999904701082853, 0.01380538852806035, -0.999904701082853, 
  0.697277510830887, 0.716801278521100, -0.697277510830886, 
  -0.716801278521100, -0.716801278521100, 0.697277510830887, 
  0.716801278521100, -0.697277510830887, 0.918508394325212, 
  0.395401478947816, -0.918508394325212, -0.395401478947817, 
  -0.395401478947816, 0.918508394325212, 0.395401478947816, 
  -0.918508394325212, 0.369892447148934, 0.929074581259316, 
  -0.369892447148934, -0.929074581259316, -0.929074581259316, 
  0.369892447148934, 0.929074581259316, -0.369892447148934, 
  0.977998514934557, 0.2086118519782635, -0.977998514934557, 
  -0.2086118519782635, -0.2086118519782633, 0.977998514934557, 
  0.2086118519782634, -0.977998514934557, 0.544038526730884, 
  0.839060237070313, -0.544038526730884, -0.839060237070313, 
  -0.839060237070313, 0.544038526730884, 0.839060237070313, 
  -0.544038526730884, 0.823720511227391, 0.566996048825109, 
  -0.823720511227391, -0.566996048825109, -0.566996048825108, 
  0.823720511227391, 0.566996048825109, -0.823720511227391, 
  0.1815316082611251, 0.983385110321551, -0.181531608261125, 
  -0.983385110321551, -0.983385110321551, 0.1815316082611252, 
  0.983385110321551, -0.181531608261125, 0.993736721940725, 
  0.1117467112111266, -0.993736721940725, -0.1117467112111265, 
  -0.1117467112111265, 0.993736721940725, 0.1117467112111266, 
  -0.993736721940725, 0.623661117525695, 0.781694832071059, 
  -0.623661117525695, -0.781694832071059, -0.781694832071059, 
  0.623661117525695, 0.781694832071059, -0.623661117525695, 
  0.875329403104111, 0.483527078932919, -0.875329403104111, 
  -0.483527078932919, -0.483527078932918, 0.875329403104111, 
  0.483527078932919, -0.875329403104111, 0.277046080306100, 
  0.960856633107680, -0.277046080306100, -0.960856633107680, 
  -0.960856633107680, 0.277046080306100, 0.960856633107680, 
  -0.277046080306100, 0.952841647601199, 0.303467946572011, 
  -0.952841647601199, -0.303467946572011, -0.303467946572011, 
  0.952841647601199, 0.303467946572011, -0.952841647601199, 
  0.459176547521944, 0.888345033309596, -0.459176547521944, 
  -0.888345033309596, -0.888345033309596, 0.459176547521944, 
  0.888345033309596, -0.459176547521944, 0.764178740536117, 
  0.645004536815544, -0.764178740536117, -0.645004536815544, 
  -0.645004536815544, 0.764178740536117, 0.645004536815544, 
  -0.764178740536117, 0.0842688875933241, 0.996443051350043, 
  -0.084268887593324, -0.996443051350043, -0.996443051350043, 
  0.0842688875933242, 0.996443051350043, -0.0842688875933241, 
  0.998022873771486, 0.06285175756416141, -0.998022873771486, 
  -0.06285175756416149, -0.06285175756416131, 0.998022873771486, 
  0.06285175756416141, -0.998022873771486, 0.661265837839992, 
  0.750151645806215, -0.661265837839992, -0.750151645806215, 
  -0.750151645806215, 0.661265837839992, 0.750151645806215, 
  -0.661265837839992, 0.898000579740740, 0.439994271309633, 
  -0.898000579740740, -0.439994271309633, -0.439994271309633, 
  0.898000579740740, 0.439994271309633, -0.898000579740740, 
  0.323859366517853, 0.946105232370403, -0.323859366517853, 
  -0.946105232370403, -0.946105232370403, 0.323859366517853, 
  0.946105232370403, -0.323859366517853, 0.966584374478333, 
  0.256348682489943, -0.966584374478333, -0.256348682489943, 
  -0.256348682489943, 0.966584374478333, 0.256348682489943, 
  -0.966584374478333, 0.502212474045711, 0.864744257519462, 
  -0.502212474045711, -0.864744257519463, -0.864744257519462, 
  0.502212474045711, 0.864744257519462, -0.502212474045711, 
  0.794907126328237, 0.606731127034524, -0.794907126328237, 
  -0.606731127034525, -0.606731127034525, 0.794907126328237, 
  0.606731127034525, -0.794907126328237, 0.1330605251571391, 
  0.991107913723277, -0.1330605251571391, -0.991107913723277, 
  -0.991107913723277, 0.133060525157139, 0.991107913723277, 
  -0.1330605251571391, 0.987056571305751, 0.1603724572429283, 
  -0.987056571305751, -0.1603724572429284, -0.1603724572429283, 
  0.987056571305751, 0.1603724572429284, -0.987056571305751, 
  0.584553942953015, 0.811354847017064, -0.584553942953015, 
  -0.811354847017064, -0.811354847017064, 0.584553942953015, 
  0.811354847017064, -0.584553942953015, 0.850549481265603, 
  0.525895027471085, -0.850549481265603, -0.525895027471085, 
  -0.525895027471085, 0.850549481265603, 0.525895027471085, 
  -0.850549481265603, 0.2295653658205189, 0.973293246054698, 
  -0.2295653658205187, -0.973293246054698, -0.973293246054698, 
  0.2295653658205189, 0.973293246054698, -0.2295653658205189, 
  0.936803441735922, 0.349856129790135, -0.936803441735922, 
  -0.349856129790135, -0.349856129790135, 0.936803441735922, 
  0.349856129790135, -0.936803441735922, 0.415034424476082, 
  0.909805708104652, -0.415034424476082, -0.909805708104652, 
  -0.909805708104652, 0.415034424476082, 0.909805708104652, 
  -0.415034424476082, 0.731609381223893, 0.681724074171650, 
  -0.731609381223893, -0.681724074171650, -0.681724074171650, 
  0.731609381223893, 0.681724074171650, -0.731609381223893, 
  0.03527423889821395, 0.999377670388003, -0.03527423889821382, 
  -0.999377670388003, -0.999377670388003, 0.03527423889821423, 
  0.999377670388003, -0.03527423889821395, 0.999264747286594, 
  0.0383401203735527, -0.999264747286594, -0.03834012037355286, 
  -0.03834012037355267, 0.999264747286595, 0.03834012037355279, 
  -0.999264747286594, 0.679476319899365, 0.733697438114660, 
  -0.679476319899365, -0.733697438114660, -0.733697438114660, 
  0.679476319899365, 0.733697438114660, -0.679476319899365, 
  0.908528118716306, 0.417823715820212, -0.908528118716306, 
  -0.417823715820212, -0.417823715820212, 0.908528118716306, 
  0.417823715820212, -0.908528118716306, 0.346980410845924, 
  0.937872376439990, -0.346980410845924, -0.937872376439990, 
  -0.937872376439990, 0.346980410845924, 0.937872376439990, 
  -0.346980410845924, 0.972584368934732, 0.2325503070387752, 
  -0.972584368934732, -0.2325503070387751, -0.2325503070387752, 
  0.972584368934732, 0.2325503070387753, -0.972584368934732, 
  0.523283103475656, 0.852158901623920, -0.523283103475656, 
  -0.852158901623920, -0.852158901623920, 0.523283103475657, 
  0.852158901623920, -0.523283103475656, 0.809557642404051, 
  0.587040393520918, -0.809557642404051, -0.587040393520918, 
  -0.587040393520918, 0.809557642404051, 0.587040393520918, 
  -0.809557642404051, 0.1573434556162383, 0.987543941794359, 
  -0.1573434556162382, -0.987543941794359, -0.987543941794359, 
  0.1573434556162385, 0.987543941794359, -0.1573434556162383, 
  0.990695025442665, 0.1361005751757062, -0.990695025442665, 
  -0.1361005751757065, -0.1361005751757061, 0.990695025442665, 
  0.1361005751757062, -0.990695025442665, 0.604289530948156, 
  0.796764810208419, -0.604289530948156, -0.796764810208419, 
  -0.796764810208419, 0.604289530948156, 0.796764810208419, 
  -0.604289530948156, 0.863199421712124, 0.504863108531268, 
  -0.863199421712124, -0.504863108531268, -0.504863108531268, 
  0.863199421712124, 0.504863108531268, -0.863199421712124, 
  0.253382036995570, 0.967366292222329, -0.253382036995570, 
  -0.967366292222329, -0.967366292222329, 0.253382036995570, 
  0.967366292222329, -0.253382036995570, 0.945107193285261, 
  0.326760452320132, -0.945107193285261, -0.326760452320132, 
  -0.326760452320132, 0.945107193285261, 0.326760452320132, 
  -0.945107193285261, 0.437237173661044, 0.899346236979341, 
  -0.437237173661044, -0.899346236979342, -0.899346236979341, 
  0.437237173661044, 0.899346236979341, -0.437237173661044, 
  0.748119380450404, 0.663564158612040, -0.748119380450403, 
  -0.663564158612040, -0.663564158612040, 0.748119380450404, 
  0.663564158612040, -0.748119380450403, 0.05978957074664001, 
  0.998211003360478, -0.05978957074663989, -0.998211003360478, 
  -0.998211003360478, 0.05978957074664006, 0.998211003360478, 
  -0.05978957074663987, 0.996179828595697, 0.0873255352061921, 
  -0.996179828595697, -0.0873255352061921, -0.0873255352061921, 
  0.996179828595697, 0.0873255352061922, -0.996179828595697, 
  0.642657033966227, 0.766153990196313, -0.642657033966227, 
  -0.766153990196313, -0.766153990196313, 0.642657033966227, 
  0.766153990196313, -0.642657033966227, 0.886932118794342, 
  0.461899790702463, -0.886932118794342, -0.461899790702463, 
  -0.461899790702463, 0.886932118794342, 0.461899790702463, 
  -0.886932118794342, 0.300543241417273, 0.953768189885990, 
  -0.300543241417273, -0.953768189885990, -0.953768189885990, 
  0.300543241417274, 0.953768189885990, -0.300543241417273, 
  0.960002145737666, 0.279992643080273, -0.960002145737666, 
  -0.279992643080273, -0.279992643080273, 0.960002145737666, 
  0.279992643080273, -0.960002145737666, 0.480839330600334, 
  0.876808723809146, -0.480839330600334, -0.876808723809146, 
  -0.876808723809146, 0.480839330600334, 0.876808723809146, 
  -0.480839330600334, 0.779777787923015, 0.626056388404344, 
  -0.779777787923014, -0.626056388404344, -0.626056388404344, 
  0.779777787923014, 0.626056388404344, -0.779777787923014, 
  0.1086974440131387, 0.994074879304879, -0.1086974440131386, 
  -0.994074879304879, -0.994074879304879, 0.1086974440131387, 
  0.994074879304879, -0.1086974440131387, 0.982823551198705, 
  0.1845477369386196, -0.982823551198705, -0.1845477369386197, 
  -0.1845477369386195, 0.982823551198705, 0.1845477369386196, 
  -0.982823551198705, 0.564466241520519, 0.825456154004377, 
  -0.564466241520519, -0.825456154004378, -0.825456154004377, 
  0.564466241520519, 0.825456154004378, -0.564466241520519, 
  0.837387201615662, 0.546610166910835, -0.837387201615662, 
  -0.546610166910835, -0.546610166910835, 0.837387201615662, 
  0.546610166910835, -0.837387201615662, 0.2056104130530993, 
  0.978633924429423, -0.2056104130530992, -0.978633924429423, 
  -0.978633924429423, 0.2056104130530994, 0.978633924429423, 
  -0.2056104130530993, 0.927935394822618, 0.372741067009516, 
  -0.927935394822618, -0.372741067009516, -0.372741067009516, 
  0.927935394822618, 0.372741067009516, -0.927935394822618, 
  0.392581674072952, 0.919717146291227, -0.392581674072951, 
  -0.919717146291227, -0.919717146291227, 0.392581674072951, 
  0.919717146291227, -0.392581674072951, 0.714658687862769, 
  0.699473344640284, -0.714658687862769, -0.699473344640284, 
  -0.699473344640284, 0.714658687862769, 0.699473344640284, 
  -0.714658687862769, 0.01073765916726457, 0.999942349676024, 
  -0.01073765916726445, -0.999942349676024, -0.999942349676024, 
  0.01073765916726441, 0.999942349676024, -0.01073765916726449, 
  0.999970586430974, 0.007669828739531097, -0.999970586430974, 
  -0.007669828739531138, -0.007669828739530954, 0.999970586430974, 
  0.007669828739531078, -0.999970586430974, 0.701662594740169, 
  0.712509370564692, -0.701662594740168, -0.712509370564692, 
  -0.712509370564692, 0.701662594740169, 0.712509370564692, 
  -0.701662594740168, 0.920917241529189, 0.389758174069856, 
  -0.920917241529189, -0.389758174069856, -0.389758174069856, 
  0.920917241529190, 0.389758174069856, -0.920917241529189, 
  0.375586178489217, 0.926787474304582, -0.375586178489217, 
  -0.926787474304582, -0.926787474304582, 0.375586178489217, 
  0.926787474304582, -0.375586178489217, 0.979260122649082, 
  0.2026070388444211, -0.979260122649082, -0.2026070388444213, 
  -0.202607038844421, 0.979260122649082, 0.2026070388444211, 
  -0.979260122649082, 0.549176662187720, 0.835706284353753, 
  -0.549176662187720, -0.835706284353753, -0.835706284353753, 
  0.549176662187720, 0.835706284353753, -0.549176662187720, 
  0.827184027273669, 0.561931121244689, -0.827184027273669, 
  -0.561931121244690, -0.561931121244689, 0.827184027273669, 
  0.561931121244689, -0.827184027273669, 0.1875621285825297, 
  0.982252741366289, -0.1875621285825296, -0.982252741366289, 
  -0.982252741366289, 0.1875621285825296, 0.982252741366289, 
  -0.1875621285825296, 0.994403680057679, 0.1056471537134106, 
  -0.994403680057679, -0.1056471537134108, -0.1056471537134106, 
  0.994403680057679, 0.1056471537134107, -0.994403680057679, 
  0.628445766601833, 0.777853404209453, -0.628445766601833, 
  -0.777853404209453, -0.777853404209453, 0.628445766601833, 
  0.777853404209453, -0.628445766601833, 0.878279791656541, 
  0.478147056424843, -0.878279791656541, -0.478147056424843, 
  -0.478147056424843, 0.878279791656542, 0.478147056424843, 
  -0.878279791656541, 0.282936570457055, 0.959138622461842, 
  -0.282936570457055, -0.959138622461842, -0.959138622461842, 
  0.282936570457055, 0.959138622461842, -0.282936570457055, 
  0.954685754941338, 0.297615707435086, -0.954685754941338, 
  -0.297615707435086, -0.297615707435086, 0.954685754941338, 
  0.297615707435086, -0.954685754941338, 0.464618686306238, 
  0.885510856136200, -0.464618686306238, -0.885510856136200, 
  -0.885510856136200, 0.464618686306238, 0.885510856136200, 
  -0.464618686306238, 0.768122028523365, 0.640303482184152, 
  -0.768122028523365, -0.640303482184152, -0.640303482184151, 
  0.768122028523366, 0.640303482184152, -0.768122028523365, 
  0.090381360877865, 0.995907229417412, -0.0903813608778649, 
  -0.995907229417412, -0.995907229417412, 0.0903813608778653, 
  0.995907229417412, -0.090381360877865, 0.998389737407340, 
  0.05672682116690775, -0.998389737407340, -0.05672682116690808, 
  -0.05672682116690766, 0.998389737407340, 0.05672682116690778, 
  -0.998389737407340, 0.665856233665510, 0.746080073510064, 
  -0.665856233665509, -0.746080073510064, -0.746080073510064, 
  0.665856233665510, 0.746080073510064, -0.665856233665510, 
  0.900683429228647, 0.434475960569656, -0.900683429228647, 
  -0.434475960569656, -0.434475960569656, 0.900683429228647, 
  0.434475960569656, -0.900683429228647, 0.329658462528588, 
  0.944100258491273, -0.329658462528587, -0.944100258491273, 
  -0.944100258491273, 0.329658462528587, 0.944100258491273, 
  -0.329658462528587, 0.968139104746362, 0.250413006572965, 
  -0.968139104746362, -0.250413006572965, -0.250413006572965, 
  0.968139104746363, 0.250413006572965, -0.968139104746362, 
  0.507508991052971, 0.861646461143081, -0.507508991052971, 
  -0.861646461143081, -0.861646461143081, 0.507508991052971, 
  0.861646461143081, -0.507508991052971, 0.798614994634761, 
  0.601842247058580, -0.798614994634761, -0.601842247058580, 
  -0.601842247058580, 0.798614994634761, 0.601842247058580, 
  -0.798614994634761, 0.1391393441638263, 0.990272812363169, 
  -0.1391393441638262, -0.990272812363169, -0.990272812363169, 
  0.1391393441638263, 0.990272812363169, -0.1391393441638262, 
  0.988022017143284, 0.1543129730130201, -0.988022017143284, 
  -0.1543129730130201, -0.1543129730130201, 0.988022017143284, 
  0.1543129730130202, -0.988022017143284, 0.589521318641064, 
  0.807752817926190, -0.589521318641064, -0.807752817926190, 
  -0.807752817926190, 0.589521318641064, 0.807752817926190, 
  -0.589521318641064, 0.853760301138111, 0.520666254140367, 
  -0.853760301138111, -0.520666254140367, -0.520666254140367, 
  0.853760301138112, 0.520666254140367, -0.853760301138111, 
  0.2355330594049755, 0.971866337480279, -0.2355330594049753, 
  -0.971866337480279, -0.971866337480279, 0.2355330594049757, 
  0.971866337480279, -0.2355330594049755, 0.938932483532064, 
  0.344101425989939, -0.938932483532064, -0.344101425989939, 
  -0.344101425989939, 0.938932483532064, 0.344101425989939, 
  -0.938932483532064, 0.420609074448402, 0.907241977915296, 
  -0.420609074448402, -0.907241977915296, -0.907241977915296, 
  0.420609074448403, 0.907241977915296, -0.420609074448403, 
  0.735778589165714, 0.677222170137180, -0.735778589165713, 
  -0.677222170137181, -0.677222170137180, 0.735778589165713, 
  0.677222170137180, -0.735778589165713, 0.04140564097707672, 
  0.999142418724817, -0.0414056409770766, -0.999142418724817, 
  -0.999142418724817, 0.04140564097707678, 0.999142418724817, 
  -0.04140564097707675, 0.999481186966167, 0.03220802540830459, 
  -0.999481186966167, -0.03220802540830454, -0.03220802540830458, 
  0.999481186966167, 0.0322080254083047, -0.999481186966167, 
  0.683965411797316, 0.729514438146997, -0.683965411797315, 
  -0.729514438146997, -0.729514438146997, 0.683965411797316, 
  0.729514438146997, -0.683965411797315, 0.911074734055176, 
  0.412241226669883, -0.911074734055176, -0.412241226669883, 
  -0.412241226669883, 0.911074734055176, 0.412241226669883, 
  -0.911074734055176, 0.352728555755211, 0.935725689481080, 
  -0.352728555755211, -0.935725689481080, -0.935725689481080, 
  0.352728555755211, 0.935725689481080, -0.352728555755211, 
  0.973992962167956, 0.22657826384561, -0.973992962167956, 
  -0.2265782638456101, -0.22657826384561, 0.973992962167956, 
  0.2265782638456101, -0.973992962167956, 0.528502001542228, 
  0.848932055211640, -0.528502001542228, -0.848932055211640, 
  -0.848932055211640, 0.528502001542228, 0.848932055211640, 
  -0.528502001542228, 0.813144414849254, 0.582061990340775, 
  -0.813144414849253, -0.582061990340776, -0.582061990340775, 
  0.813144414849253, 0.582061990340776, -0.813144414849253, 
  0.1633999493829732, 0.986559910264775, -0.1633999493829731, 
  -0.986559910264776, -0.986559910264775, 0.1633999493829733, 
  0.986559910264775, -0.1633999493829732, 0.991511473318744, 
  0.1300192227222333, -0.991511473318744, -0.1300192227222334, 
  -0.1300192227222332, 0.991511473318744, 0.1300192227222333, 
  -0.991511473318744, 0.609167012336453, 0.793041960479444, 
  -0.609167012336453, -0.793041960479444, -0.793041960479444, 
  0.609167012336453, 0.793041960479444, -0.609167012336453, 
  0.866280954024513, 0.499557112545082, -0.866280954024513, 
  -0.499557112545082, -0.499557112545082, 0.866280954024513, 
  0.499557112545082, -0.866280954024513, 0.259312915132886, 
  0.965793358874084, -0.259312915132886, -0.965793358874084, 
  -0.965793358874084, 0.259312915132886, 0.965793358874084, 
  -0.259312915132886, 0.947094366352777, 0.320955232427875, 
  -0.947094366352777, -0.320955232427875, -0.320955232427875, 
  0.947094366352777, 0.320955232427875, -0.947094366352777, 
  0.442747227564570, 0.896646470178680, -0.442747227564570, 
  -0.896646470178680, -0.896646470178680, 0.442747227564570, 
  0.896646470178680, -0.442747227564570, 0.752176850449043, 
  0.658961292982037, -0.752176850449042, -0.658961292982038, 
  -0.658961292982037, 0.752176850449043, 0.658961292982037, 
  -0.752176850449043, 0.06591335279700392, 0.997825350411112, 
  -0.06591335279700381, -0.997825350411112, -0.997825350411112, 
  0.06591335279700377, 0.997825350411112, -0.06591335279700381, 
  0.996696895202896, 0.0812114468095924, -0.996696895202896, 
  -0.0812114468095927, -0.0812114468095923, 0.996696895202896, 
  0.0812114468095924, -0.996696895202896, 0.647345968636512, 
  0.762196298134579, -0.647345968636512, -0.762196298134579, 
  -0.762196298134579, 0.647345968636512, 0.762196298134579, 
  -0.647345968636512, 0.889749586383073, 0.456448982396884, 
  -0.889749586383073, -0.456448982396884, -0.456448982396884, 
  0.889749586383073, 0.456448982396884, -0.889749586383073, 
  0.306389795370861, 0.951906136807932, -0.306389795370861, 
  -0.951906136807932, -0.951906136807932, 0.306389795370861, 
  0.951906136807932, -0.306389795370861, 0.961702076529123, 
  0.274096909868706, -0.961702076529123, -0.274096909868706, 
  -0.274096909868706, 0.961702076529123, 0.274096909868706, 
  -0.961702076529123, 0.486210276124487, 0.873841843465367, 
  -0.486210276124486, -0.873841843465367, -0.873841843465367, 
  0.486210276124487, 0.873841843465367, -0.486210276124486, 
  0.783604518609638, 0.621259976511088, -0.783604518609638, 
  -0.621259976511088, -0.621259976511087, 0.783604518609638, 
  0.621259976511088, -0.783604518609638, 0.1147949266065102, 
  0.993389211148081, -0.1147949266065101, -0.993389211148081, 
  -0.993389211148081, 0.1147949266065103, 0.993389211148081, 
  -0.1147949266065101, 0.983937413449219, 0.1785137709389975, 
  -0.983937413449219, -0.1785137709389974, -0.1785137709389974, 
  0.983937413449219, 0.1785137709389976, -0.983937413449219, 
  0.569520519346947, 0.821977115279242, -0.569520519346947, 
  -0.821977115279241, -0.821977115279241, 0.569520519346947, 
  0.821977115279242, -0.569520519346947, 0.840725374970458, 
  0.541461765853123, -0.840725374970458, -0.541461765853123, 
  -0.541461765853123, 0.840725374970458, 0.541461765853124, 
  -0.840725374970458, 0.2116113273692276, 0.977353900145200, 
  -0.2116113273692275, -0.977353900145200, -0.977353900145200, 
  0.2116113273692279, 0.977353900145200, -0.2116113273692275, 
  0.930205022892219, 0.367040345719767, -0.930205022892219, 
  -0.367040345719767, -0.367040345719767, 0.930205022892219, 
  0.367040345719767, -0.930205022892219, 0.398217562153374, 
  0.917290997008378, -0.398217562153374, -0.917290997008378, 
  -0.917290997008378, 0.398217562153374, 0.917290997008378, 
  -0.398217562153374, 0.718937122372804, 0.695075113980001, 
  -0.718937122372804, -0.695075113980001, -0.695075113980001, 
  0.718937122372804, 0.695075113980001, -0.718937122372804, 
  0.01687298794728177, 0.999857641005824, -0.01687298794728165, 
  -0.999857641005824, -0.999857641005824, 0.01687298794728183, 
  0.999857641005824, -0.01687298794728171, 0.999801169887884, 
  0.01994042855151444, -0.999801169887884, -0.01994042855151444, 
  -0.01994042855151448, 0.999801169887884, 0.0199404285515146, 
  -0.999801169887884, 0.692866174817425, 0.721066199314508, 
  -0.692866174817425, -0.721066199314508, -0.721066199314508, 
  0.692866174817425, 0.721066199314508, -0.692866174817425, 
  0.916064965799332, 0.401029897183576, -0.916064965799332, 
  -0.401029897183576, -0.401029897183576, 0.916064965799332, 
  0.401029897183576, -0.916064965799332, 0.364184789567080, 
  0.931326709081181, -0.364184789567080, -0.931326709081181, 
  -0.931326709081180, 0.364184789567080, 0.931326709081180, 
  -0.364184789567080, 0.976700086128712, 0.2146088109937867, 
  -0.976700086128712, -0.214608810993787, -0.2146088109937868, 
  0.976700086128712, 0.2146088109937869, -0.976700086128712, 
  0.538879908531008, 0.842382599643186, -0.538879908531008, 
  -0.842382599643186, -0.842382599643186, 0.538879908531008, 
  0.842382599643186, -0.538879908531008, 0.820225982569435, 
  0.572039629324757, -0.820225982569434, -0.572039629324757, 
  -0.572039629324757, 0.820225982569435, 0.572039629324757, 
  -0.820225982569435, 0.1754942533772714, 0.984480455383221, 
  -0.1754942533772712, -0.984480455383221, -0.984480455383221, 
  0.1754942533772714, 0.984480455383221, -0.1754942533772714, 
  0.993032350197851, 0.117842061508325, -0.993032350197851, 
  -0.1178420615083251, -0.1178420615083249, 0.993032350197851, 
  0.117842061508325, -0.993032350197851, 0.618852987960976, 
  0.785506829564054, -0.618852987960976, -0.785506829564054, 
  -0.785506829564054, 0.618852987960976, 0.785506829564054, 
  -0.618852987960976, 0.872346058894391, 0.488888896919763, 
  -0.872346058894391, -0.488888896919763, -0.488888896919763, 
  0.872346058894392, 0.488888896919763, -0.872346058894391, 
  0.271145159526808, 0.962538468044359, -0.271145159526808, 
  -0.962538468044359, -0.962538468044359, 0.271145159526808, 
  0.962538468044359, -0.271145159526808, 0.950961666311575, 
  0.309308760312269, -0.950961666311575, -0.309308760312269, 
  -0.309308760312269, 0.950961666311575, 0.309308760312269, 
  -0.950961666311575, 0.453717121000164, 0.891145764794583, 
  -0.453717121000164, -0.891145764794583, -0.891145764794583, 
  0.453717121000164, 0.891145764794583, -0.453717121000164, 
  0.760206681651203, 0.649681307390683, -0.760206681651202, 
  -0.649681307390683, -0.649681307390683, 0.760206681651202, 
  0.649681307390683, -0.760206681651202, 0.07815324163279431, 
  0.996941357764982, -0.07815324163279419, -0.996941357764982, 
  -0.996941357764982, 0.07815324163279415, 0.996941357764982, 
  -0.07815324163279424, 0.997618435138520, 0.06897432762826674, 
  -0.997618435138519, -0.06897432762826704, -0.06897432762826662, 
  0.997618435138520, 0.06897432762826674, -0.997618435138520, 
  0.656650545729429, 0.754194975316889, -0.656650545729429, 
  -0.754194975316889, -0.754194975316889, 0.656650545729429, 
  0.754194975316889, -0.656650545729429, 0.895283921038557, 
  0.445496016513982, -0.895283921038557, -0.445496016513982, 
  -0.445496016513982, 0.895283921038557, 0.445496016513982, 
  -0.895283921038557, 0.318048077385015, 0.948074585922276, 
  -0.318048077385015, -0.948074585922276, -0.948074585922276, 
  0.318048077385015, 0.948074585922276, -0.318048077385015, 
  0.964993252854920, 0.262274707023914, -0.964993252854920, 
  -0.262274707023914, -0.262274707023913, 0.964993252854920, 
  0.262274707023914, -0.964993252854920, 0.496897049022655, 
  0.867809496763303, -0.496897049022654, -0.867809496763303, 
  -0.867809496763303, 0.496897049022655, 0.867809496763303, 
  -0.496897049022654, 0.791169330217690, 0.611597163926462, 
  -0.791169330217690, -0.611597163926462, -0.611597163926462, 
  0.791169330217690, 0.611597163926462, -0.791169330217690, 
  0.126976696496886, 0.991905700430609, -0.1269766964968859, 
  -0.991905700430609, -0.991905700430609, 0.126976696496886, 
  0.991905700430609, -0.1269766964968859, 0.986053963346195, 
  0.1664259035404641, -0.986053963346195, -0.166425903540464, 
  -0.1664259035404641, 0.986053963346195, 0.1664259035404642, 
  -0.986053963346195, 0.579564559139406, 0.814926329056527, 
  -0.579564559139406, -0.814926329056527, -0.814926329056526, 
  0.579564559139406, 0.814926329056527, -0.579564559139406, 
  0.847306638685858, 0.531104001151255, -0.847306638685858, 
  -0.531104001151255, -0.531104001151255, 0.847306638685859, 
  0.531104001151255, -0.847306638685858, 0.22358902922979, 0.974683510688511, 
  -0.2235890292297899, -0.974683510688511, -0.974683510688511, 
  0.2235890292297903, 0.974683510688511, -0.22358902922979, 
  0.934639129819681, 0.355597661704784, -0.934639129819681, 
  -0.355597661704784, -0.355597661704784, 0.934639129819681, 
  0.355597661704784, -0.934639129819681, 0.409444148692258, 
  0.912335184623323, -0.409444148692258, -0.912335184623323, 
  -0.912335184623323, 0.409444148692258, 0.912335184623323, 
  -0.409444148692258, 0.727412628602376, 0.686200311680039, 
  -0.727412628602376, -0.686200311680039, -0.686200311680038, 
  0.727412628602376, 0.686200311680039, -0.727412628602376, 
  0.02914150876419374, 0.999575296046749, -0.02914150876419362, 
  -0.999575296046749, -0.999575296046749, 0.0291415087641938, 
  0.999575296046749, -0.02914150876419372, 0.999010685854073, 
  0.04447077185493867, -0.999010685854073, -0.04447077185493859, 
  -0.04447077185493863, 0.999010685854073, 0.04447077185493875, 
  -0.999010685854073, 0.674961646102012, 0.737852814788466, 
  -0.674961646102012, -0.737852814788466, -0.737852814788466, 
  0.674961646102012, 0.737852814788466, -0.674961646102012, 
  0.905947297807268, 0.423390474143796, -0.905947297807268, 
  -0.423390474143796, -0.423390474143796, 0.905947297807269, 
  0.423390474143796, -0.905947297807268, 0.341219202320282, 
  0.939983753034014, -0.341219202320282, -0.939983753034014, 
  -0.939983753034014, 0.341219202320283, 0.939983753034014, 
  -0.341219202320282, 0.971139158449725, 0.2385135948443184, 
  -0.971139158449725, -0.2385135948443185, -0.2385135948443184, 
  0.971139158449725, 0.2385135948443185, -0.971139158449725, 
  0.518044504095999, 0.855353664735196, -0.518044504095999, 
  -0.855353664735196, -0.855353664735196, 0.518044504095999, 
  0.855353664735196, -0.518044504095999, 0.805940390571176, 
  0.591996694962041, -0.805940390571176, -0.591996694962041, 
  -0.591996694962041, 0.805940390571176, 0.591996694962041, 
  -0.805940390571176, 0.1512810379573302, 0.988490792852697, 
  -0.1512810379573301, -0.988490792852697, -0.988490792852697, 
  0.1512810379573303, 0.988490792852697, -0.1512810379573302, 
  0.989841278458820, 0.142176803519448, -0.989841278458820, 
  -0.1421768035194481, -0.1421768035194479, 0.989841278458820, 
  0.142176803519448, -0.989841278458820, 0.599389298400565, 
  0.800457662192623, -0.599389298400565, -0.800457662192623, 
  -0.800457662192623, 0.599389298400565, 0.800457662192623, 
  -0.599389298400565, 0.860085390429390, 0.510150096706767, 
  -0.860085390429390, -0.510150096706767, -0.510150096706767, 
  0.860085390429390, 0.510150096706767, -0.860085390429390, 
  0.2474416191677734, 0.968902804776429, -0.2474416191677733, 
  -0.968902804776429, -0.968902804776429, 0.2474416191677735, 
  0.968902804776429, -0.2474416191677732, 0.943084437466093, 
  0.332553369866044, -0.943084437466093, -0.332553369866044, 
  -0.332553369866044, 0.943084437466094, 0.332553369866044, 
  -0.943084437466093, 0.431710658025057, 0.902012143902493, 
  -0.431710658025057, -0.902012143902493, -0.902012143902493, 
  0.431710658025057, 0.902012143902493, -0.431710658025057, 
  0.744033744179929, 0.668142041426518, -0.744033744179929, 
  -0.668142041426519, -0.668142041426518, 0.744033744179929, 
  0.668142041426519, -0.744033744179929, 0.05366353765273068, 
  0.998559074229759, -0.05366353765273056, -0.998559074229759, 
  -0.998559074229759, 0.05366353765273053, 0.998559074229759, 
  -0.05366353765273053, 0.995625256380994, 0.0934363358457478, 
  -0.995625256380994, -0.093436335845748, -0.0934363358457478, 
  0.995625256380994, 0.0934363358457479, -0.995625256380994, 
  0.637943903621844, 0.770082836993348, -0.637943903621844, 
  -0.770082836993348, -0.770082836993348, 0.637943903621844, 
  0.770082836993348, -0.637943903621844, 0.884081258712635, 
  0.467333208741988, -0.884081258712635, -0.467333208741989, 
  -0.467333208741988, 0.884081258712635, 0.467333208741989, 
  -0.884081258712635, 0.294685372180514, 0.955594334130771, 
  -0.294685372180514, -0.955594334130771, -0.955594334130771, 
  0.294685372180514, 0.955594334130771, -0.294685372180514, 
  0.958266071408018, 0.285877834727081, -0.958266071408018, 
  -0.285877834727081, -0.285877834727081, 0.958266071408018, 
  0.285877834727081, -0.958266071408018, 0.475450281747156, 
  0.879742592800048, -0.475450281747156, -0.879742592800048, 
  -0.879742592800047, 0.475450281747156, 0.879742592800048, 
  -0.475450281747156, 0.775921699043408, 0.630829229628424, 
  -0.775921699043408, -0.630829229628424, -0.630829229628424, 
  0.775921699043408, 0.630829229628425, -0.775921699043408, 
  0.1025958690224363, 0.994723121104326, -0.1025958690224362, 
  -0.994723121104326, -0.994723121104326, 0.1025958690224366, 
  0.994723121104326, -0.1025958690224363, 0.981672686196983, 
  0.1905747548202527, -0.981672686196983, -0.190574754820253, 
  -0.1905747548202526, 0.981672686196983, 0.1905747548202528, 
  -0.981672686196983, 0.559390711859136, 0.828904114771865, 
  -0.559390711859136, -0.828904114771865, -0.828904114771865, 
  0.559390711859136, 0.828904114771865, -0.559390711859136, 
  0.834017501106018, 0.551737988404707, -0.834017501106018, 
  -0.551737988404708, -0.551737988404707, 0.834017501106018, 
  0.551737988404707, -0.834017501106018, 0.199601757621131, 
  0.979877103699518, -0.1996017576211309, -0.979877103699518, 
  -0.979877103699518, 0.1996017576211309, 0.979877103699518, 
  -0.199601757621131, 0.925630830509873, 0.378427754808766, 
  -0.925630830509873, -0.378427754808766, -0.378427754808766, 
  0.925630830509873, 0.378427754808766, -0.925630830509873, 
  0.386931005514389, 0.922108668743345, -0.386931005514389, 
  -0.922108668743345, -0.922108668743345, 0.386931005514389, 
  0.922108668743345, -0.386931005514389, 0.710353346857062, 
  0.703845240524485, -0.710353346857062, -0.703845240524485, 
  -0.703845240524485, 0.710353346857062, 0.703845240524485, 
  -0.710353346857062, 0.004601926120448672, 0.999989411081928, 
  -0.004601926120448549, -0.999989411081928, -0.999989411081928, 
  0.004601926120448733, 0.999989411081928, -0.004601926120448571, 
  0.999989411081928, 0.004601926120448571, -0.999989411081928, 
  -0.004601926120448733, -0.004601926120448549, 0.999989411081928, 
  0.004601926120448672, -0.999989411081928, 0.703845240524485, 
  0.710353346857062, -0.703845240524485, -0.710353346857062, 
  -0.710353346857062, 0.703845240524485, 0.710353346857062, 
  -0.703845240524485, 0.922108668743345, 0.386931005514389, 
  -0.922108668743345, -0.386931005514389, -0.386931005514389, 
  0.922108668743345, 0.386931005514389, -0.922108668743345, 
  0.378427754808766, 0.925630830509873, -0.378427754808766, 
  -0.925630830509873, -0.925630830509873, 0.378427754808766, 
  0.925630830509873, -0.378427754808766, 0.979877103699518, 
  0.199601757621131, -0.979877103699518, -0.1996017576211309, 
  -0.1996017576211309, 0.979877103699518, 0.199601757621131, 
  -0.979877103699518, 0.551737988404707, 0.834017501106018, 
  -0.551737988404707, -0.834017501106018, -0.834017501106018, 
  0.551737988404708, 0.834017501106018, -0.551737988404707, 
  0.828904114771865, 0.559390711859136, -0.828904114771865, 
  -0.559390711859136, -0.559390711859136, 0.828904114771865, 
  0.559390711859136, -0.828904114771865, 0.1905747548202528, 
  0.981672686196983, -0.1905747548202526, -0.981672686196983, 
  -0.981672686196983, 0.190574754820253, 0.981672686196983, 
  -0.1905747548202527, 0.994723121104326, 0.1025958690224363, 
  -0.994723121104326, -0.1025958690224366, -0.1025958690224362, 
  0.994723121104326, 0.1025958690224363, -0.994723121104326, 
  0.630829229628425, 0.775921699043408, -0.630829229628424, 
  -0.775921699043408, -0.775921699043408, 0.630829229628424, 
  0.775921699043408, -0.630829229628424, 0.879742592800048, 
  0.475450281747156, -0.879742592800047, -0.475450281747156, 
  -0.475450281747156, 0.879742592800048, 0.475450281747156, 
  -0.879742592800048, 0.285877834727081, 0.958266071408018, 
  -0.285877834727081, -0.958266071408018, -0.958266071408018, 
  0.285877834727081, 0.958266071408018, -0.285877834727081, 
  0.955594334130771, 0.294685372180514, -0.955594334130771, 
  -0.294685372180514, -0.294685372180514, 0.955594334130771, 
  0.294685372180514, -0.955594334130771, 0.467333208741989, 
  0.884081258712635, -0.467333208741988, -0.884081258712635, 
  -0.884081258712635, 0.467333208741989, 0.884081258712635, 
  -0.467333208741988, 0.770082836993348, 0.637943903621844, 
  -0.770082836993348, -0.637943903621844, -0.637943903621844, 
  0.770082836993348, 0.637943903621844, -0.770082836993348, 
  0.0934363358457479, 0.995625256380994, -0.0934363358457478, 
  -0.995625256380994, -0.995625256380994, 0.093436335845748, 
  0.995625256380994, -0.0934363358457478, 0.998559074229759, 
  0.05366353765273053, -0.998559074229759, -0.05366353765273053, 
  -0.05366353765273056, 0.998559074229759, 0.05366353765273068, 
  -0.998559074229759, 0.668142041426519, 0.744033744179929, 
  -0.668142041426518, -0.744033744179929, -0.744033744179929, 
  0.668142041426519, 0.744033744179929, -0.668142041426518, 
  0.902012143902493, 0.431710658025057, -0.902012143902493, 
  -0.431710658025057, -0.431710658025057, 0.902012143902493, 
  0.431710658025057, -0.902012143902493, 0.332553369866044, 
  0.943084437466093, -0.332553369866044, -0.943084437466094, 
  -0.943084437466093, 0.332553369866044, 0.943084437466093, 
  -0.332553369866044, 0.968902804776429, 0.2474416191677732, 
  -0.968902804776429, -0.2474416191677735, -0.2474416191677733, 
  0.968902804776429, 0.2474416191677734, -0.968902804776429, 
  0.510150096706767, 0.860085390429390, -0.510150096706767, 
  -0.860085390429390, -0.860085390429390, 0.510150096706767, 
  0.860085390429390, -0.510150096706767, 0.800457662192623, 
  0.599389298400565, -0.800457662192623, -0.599389298400565, 
  -0.599389298400565, 0.800457662192623, 0.599389298400565, 
  -0.800457662192623, 0.142176803519448, 0.989841278458820, 
  -0.1421768035194479, -0.989841278458820, -0.989841278458820, 
  0.1421768035194481, 0.989841278458820, -0.142176803519448, 
  0.988490792852697, 0.1512810379573302, -0.988490792852697, 
  -0.1512810379573303, -0.1512810379573301, 0.988490792852697, 
  0.1512810379573302, -0.988490792852697, 0.591996694962041, 
  0.805940390571176, -0.591996694962041, -0.805940390571176, 
  -0.805940390571176, 0.591996694962041, 0.805940390571176, 
  -0.591996694962041, 0.855353664735196, 0.518044504095999, 
  -0.855353664735196, -0.518044504095999, -0.518044504095999, 
  0.855353664735196, 0.518044504095999, -0.855353664735196, 
  0.2385135948443185, 0.971139158449725, -0.2385135948443184, 
  -0.971139158449725, -0.971139158449725, 0.2385135948443185, 
  0.971139158449725, -0.2385135948443184, 0.939983753034014, 
  0.341219202320282, -0.939983753034014, -0.341219202320283, 
  -0.341219202320282, 0.939983753034014, 0.341219202320282, 
  -0.939983753034014, 0.423390474143796, 0.905947297807268, 
  -0.423390474143796, -0.905947297807269, -0.905947297807268, 
  0.423390474143796, 0.905947297807268, -0.423390474143796, 
  0.737852814788466, 0.674961646102012, -0.737852814788466, 
  -0.674961646102012, -0.674961646102012, 0.737852814788466, 
  0.674961646102012, -0.737852814788466, 0.04447077185493875, 
  0.999010685854073, -0.04447077185493863, -0.999010685854073, 
  -0.999010685854073, 0.04447077185493859, 0.999010685854073, 
  -0.04447077185493867, 0.999575296046749, 0.02914150876419372, 
  -0.999575296046749, -0.0291415087641938, -0.02914150876419362, 
  0.999575296046749, 0.02914150876419374, -0.999575296046749, 
  0.686200311680039, 0.727412628602376, -0.686200311680038, 
  -0.727412628602376, -0.727412628602376, 0.686200311680039, 
  0.727412628602376, -0.686200311680039, 0.912335184623323, 
  0.409444148692258, -0.912335184623323, -0.409444148692258, 
  -0.409444148692258, 0.912335184623323, 0.409444148692258, 
  -0.912335184623323, 0.355597661704784, 0.934639129819681, 
  -0.355597661704784, -0.934639129819681, -0.934639129819681, 
  0.355597661704784, 0.934639129819681, -0.355597661704784, 
  0.974683510688511, 0.22358902922979, -0.974683510688511, 
  -0.2235890292297903, -0.2235890292297899, 0.974683510688511, 
  0.22358902922979, -0.974683510688511, 0.531104001151255, 0.847306638685858, 
  -0.531104001151255, -0.847306638685859, -0.847306638685858, 
  0.531104001151255, 0.847306638685858, -0.531104001151255, 
  0.814926329056527, 0.579564559139406, -0.814926329056526, 
  -0.579564559139406, -0.579564559139406, 0.814926329056527, 
  0.579564559139406, -0.814926329056527, 0.1664259035404642, 
  0.986053963346195, -0.1664259035404641, -0.986053963346195, 
  -0.986053963346195, 0.166425903540464, 0.986053963346195, 
  -0.1664259035404641, 0.991905700430609, 0.1269766964968859, 
  -0.991905700430609, -0.126976696496886, -0.1269766964968859, 
  0.991905700430609, 0.126976696496886, -0.991905700430609, 
  0.611597163926462, 0.791169330217690, -0.611597163926462, 
  -0.791169330217690, -0.791169330217690, 0.611597163926462, 
  0.791169330217690, -0.611597163926462, 0.867809496763303, 
  0.496897049022654, -0.867809496763303, -0.496897049022655, 
  -0.496897049022654, 0.867809496763303, 0.496897049022655, 
  -0.867809496763303, 0.262274707023914, 0.964993252854920, 
  -0.262274707023913, -0.964993252854920, -0.964993252854920, 
  0.262274707023914, 0.964993252854920, -0.262274707023914, 
  0.948074585922276, 0.318048077385015, -0.948074585922276, 
  -0.318048077385015, -0.318048077385015, 0.948074585922276, 
  0.318048077385015, -0.948074585922276, 0.445496016513982, 
  0.895283921038557, -0.445496016513982, -0.895283921038557, 
  -0.895283921038557, 0.445496016513982, 0.895283921038557, 
  -0.445496016513982, 0.754194975316889, 0.656650545729429, 
  -0.754194975316889, -0.656650545729429, -0.656650545729429, 
  0.754194975316889, 0.656650545729429, -0.754194975316889, 
  0.06897432762826674, 0.997618435138520, -0.06897432762826662, 
  -0.997618435138520, -0.997618435138519, 0.06897432762826704, 
  0.997618435138520, -0.06897432762826674, 0.996941357764982, 
  0.07815324163279424, -0.996941357764982, -0.07815324163279415, 
  -0.07815324163279419, 0.996941357764982, 0.07815324163279431, 
  -0.996941357764982, 0.649681307390683, 0.760206681651202, 
  -0.649681307390683, -0.760206681651202, -0.760206681651202, 
  0.649681307390683, 0.760206681651203, -0.649681307390683, 
  0.891145764794583, 0.453717121000164, -0.891145764794583, 
  -0.453717121000164, -0.453717121000164, 0.891145764794583, 
  0.453717121000164, -0.891145764794583, 0.309308760312269, 
  0.950961666311575, -0.309308760312269, -0.950961666311575, 
  -0.950961666311575, 0.309308760312269, 0.950961666311575, 
  -0.309308760312269, 0.962538468044359, 0.271145159526808, 
  -0.962538468044359, -0.271145159526808, -0.271145159526808, 
  0.962538468044359, 0.271145159526808, -0.962538468044359, 
  0.488888896919763, 0.872346058894391, -0.488888896919763, 
  -0.872346058894392, -0.872346058894391, 0.488888896919763, 
  0.872346058894391, -0.488888896919763, 0.785506829564054, 
  0.618852987960976, -0.785506829564054, -0.618852987960976, 
  -0.618852987960976, 0.785506829564054, 0.618852987960976, 
  -0.785506829564054, 0.117842061508325, 0.993032350197851, 
  -0.1178420615083249, -0.993032350197851, -0.993032350197851, 
  0.1178420615083251, 0.993032350197851, -0.117842061508325, 
  0.984480455383221, 0.1754942533772714, -0.984480455383221, 
  -0.1754942533772714, -0.1754942533772712, 0.984480455383221, 
  0.1754942533772714, -0.984480455383221, 0.572039629324757, 
  0.820225982569435, -0.572039629324757, -0.820225982569435, 
  -0.820225982569434, 0.572039629324757, 0.820225982569435, 
  -0.572039629324757, 0.842382599643186, 0.538879908531008, 
  -0.842382599643186, -0.538879908531008, -0.538879908531008, 
  0.842382599643186, 0.538879908531008, -0.842382599643186, 
  0.2146088109937869, 0.976700086128712, -0.2146088109937868, 
  -0.976700086128712, -0.976700086128712, 0.214608810993787, 
  0.976700086128712, -0.2146088109937867, 0.931326709081180, 
  0.364184789567080, -0.931326709081180, -0.364184789567080, 
  -0.364184789567080, 0.931326709081181, 0.364184789567080, 
  -0.931326709081181, 0.401029897183576, 0.916064965799332, 
  -0.401029897183576, -0.916064965799332, -0.916064965799332, 
  0.401029897183576, 0.916064965799332, -0.401029897183576, 
  0.721066199314508, 0.692866174817425, -0.721066199314508, 
  -0.692866174817425, -0.692866174817425, 0.721066199314508, 
  0.692866174817425, -0.721066199314508, 0.0199404285515146, 
  0.999801169887884, -0.01994042855151448, -0.999801169887884, 
  -0.999801169887884, 0.01994042855151444, 0.999801169887884, 
  -0.01994042855151444, 0.999857641005824, 0.01687298794728171, 
  -0.999857641005824, -0.01687298794728183, -0.01687298794728165, 
  0.999857641005824, 0.01687298794728177, -0.999857641005824, 
  0.695075113980001, 0.718937122372804, -0.695075113980001, 
  -0.718937122372804, -0.718937122372804, 0.695075113980001, 
  0.718937122372804, -0.695075113980001, 0.917290997008378, 
  0.398217562153374, -0.917290997008378, -0.398217562153374, 
  -0.398217562153374, 0.917290997008378, 0.398217562153374, 
  -0.917290997008378, 0.367040345719767, 0.930205022892219, 
  -0.367040345719767, -0.930205022892219, -0.930205022892219, 
  0.367040345719767, 0.930205022892219, -0.367040345719767, 
  0.977353900145200, 0.2116113273692275, -0.977353900145200, 
  -0.2116113273692279, -0.2116113273692275, 0.977353900145200, 
  0.2116113273692276, -0.977353900145200, 0.541461765853124, 
  0.840725374970458, -0.541461765853123, -0.840725374970458, 
  -0.840725374970458, 0.541461765853123, 0.840725374970458, 
  -0.541461765853123, 0.821977115279242, 0.569520519346947, 
  -0.821977115279241, -0.569520519346947, -0.569520519346947, 
  0.821977115279241, 0.569520519346947, -0.821977115279242, 
  0.1785137709389976, 0.983937413449219, -0.1785137709389974, 
  -0.983937413449219, -0.983937413449219, 0.1785137709389974, 
  0.983937413449219, -0.1785137709389975, 0.993389211148081, 
  0.1147949266065101, -0.993389211148081, -0.1147949266065103, 
  -0.1147949266065101, 0.993389211148081, 0.1147949266065102, 
  -0.993389211148081, 0.621259976511088, 0.783604518609638, 
  -0.621259976511087, -0.783604518609638, -0.783604518609638, 
  0.621259976511088, 0.783604518609638, -0.621259976511088, 
  0.873841843465367, 0.486210276124486, -0.873841843465367, 
  -0.486210276124487, -0.486210276124486, 0.873841843465367, 
  0.486210276124487, -0.873841843465367, 0.274096909868706, 
  0.961702076529123, -0.274096909868706, -0.961702076529123, 
  -0.961702076529123, 0.274096909868706, 0.961702076529123, 
  -0.274096909868706, 0.951906136807932, 0.306389795370861, 
  -0.951906136807932, -0.306389795370861, -0.306389795370861, 
  0.951906136807932, 0.306389795370861, -0.951906136807932, 
  0.456448982396884, 0.889749586383073, -0.456448982396884, 
  -0.889749586383073, -0.889749586383073, 0.456448982396884, 
  0.889749586383073, -0.456448982396884, 0.762196298134579, 
  0.647345968636512, -0.762196298134579, -0.647345968636512, 
  -0.647345968636512, 0.762196298134579, 0.647345968636512, 
  -0.762196298134579, 0.0812114468095924, 0.996696895202896, 
  -0.0812114468095923, -0.996696895202896, -0.996696895202896, 
  0.0812114468095927, 0.996696895202896, -0.0812114468095924, 
  0.997825350411112, 0.06591335279700381, -0.997825350411112, 
  -0.06591335279700377, -0.06591335279700381, 0.997825350411112, 
  0.06591335279700392, -0.997825350411112, 0.658961292982037, 
  0.752176850449043, -0.658961292982037, -0.752176850449043, 
  -0.752176850449042, 0.658961292982038, 0.752176850449043, 
  -0.658961292982037, 0.896646470178680, 0.442747227564570, 
  -0.896646470178680, -0.442747227564570, -0.442747227564570, 
  0.896646470178680, 0.442747227564570, -0.896646470178680, 
  0.320955232427875, 0.947094366352777, -0.320955232427875, 
  -0.947094366352777, -0.947094366352777, 0.320955232427875, 
  0.947094366352777, -0.320955232427875, 0.965793358874084, 
  0.259312915132886, -0.965793358874084, -0.259312915132886, 
  -0.259312915132886, 0.965793358874084, 0.259312915132886, 
  -0.965793358874084, 0.499557112545082, 0.866280954024513, 
  -0.499557112545082, -0.866280954024513, -0.866280954024513, 
  0.499557112545082, 0.866280954024513, -0.499557112545082, 
  0.793041960479444, 0.609167012336453, -0.793041960479444, 
  -0.609167012336453, -0.609167012336453, 0.793041960479444, 
  0.609167012336453, -0.793041960479444, 0.1300192227222333, 
  0.991511473318744, -0.1300192227222332, -0.991511473318744, 
  -0.991511473318744, 0.1300192227222334, 0.991511473318744, 
  -0.1300192227222333, 0.986559910264775, 0.1633999493829732, 
  -0.986559910264775, -0.1633999493829733, -0.1633999493829731, 
  0.986559910264776, 0.1633999493829732, -0.986559910264775, 
  0.582061990340776, 0.813144414849253, -0.582061990340775, 
  -0.813144414849253, -0.813144414849253, 0.582061990340776, 
  0.813144414849254, -0.582061990340775, 0.848932055211640, 
  0.528502001542228, -0.848932055211640, -0.528502001542228, 
  -0.528502001542228, 0.848932055211640, 0.528502001542228, 
  -0.848932055211640, 0.2265782638456101, 0.973992962167956, 
  -0.22657826384561, -0.973992962167956, -0.973992962167956, 
  0.2265782638456101, 0.973992962167956, -0.22657826384561, 
  0.935725689481080, 0.352728555755211, -0.935725689481080, 
  -0.352728555755211, -0.352728555755211, 0.935725689481080, 
  0.352728555755211, -0.935725689481080, 0.412241226669883, 
  0.911074734055176, -0.412241226669883, -0.911074734055176, 
  -0.911074734055176, 0.412241226669883, 0.911074734055176, 
  -0.412241226669883, 0.729514438146997, 0.683965411797315, 
  -0.729514438146997, -0.683965411797316, -0.683965411797315, 
  0.729514438146997, 0.683965411797316, -0.729514438146997, 
  0.0322080254083047, 0.999481186966167, -0.03220802540830458, 
  -0.999481186966167, -0.999481186966167, 0.03220802540830454, 
  0.999481186966167, -0.03220802540830459, 0.999142418724817, 
  0.04140564097707675, -0.999142418724817, -0.04140564097707678, 
  -0.0414056409770766, 0.999142418724817, 0.04140564097707672, 
  -0.999142418724817, 0.677222170137180, 0.735778589165713, 
  -0.677222170137180, -0.735778589165713, -0.735778589165713, 
  0.677222170137181, 0.735778589165714, -0.677222170137180, 
  0.907241977915296, 0.420609074448403, -0.907241977915296, 
  -0.420609074448403, -0.420609074448402, 0.907241977915296, 
  0.420609074448402, -0.907241977915296, 0.344101425989939, 
  0.938932483532064, -0.344101425989939, -0.938932483532064, 
  -0.938932483532064, 0.344101425989939, 0.938932483532064, 
  -0.344101425989939, 0.971866337480279, 0.2355330594049755, 
  -0.971866337480279, -0.2355330594049757, -0.2355330594049753, 
  0.971866337480279, 0.2355330594049755, -0.971866337480279, 
  0.520666254140367, 0.853760301138111, -0.520666254140367, 
  -0.853760301138112, -0.853760301138111, 0.520666254140367, 
  0.853760301138111, -0.520666254140367, 0.807752817926190, 
  0.589521318641064, -0.807752817926190, -0.589521318641064, 
  -0.589521318641064, 0.807752817926190, 0.589521318641064, 
  -0.807752817926190, 0.1543129730130202, 0.988022017143284, 
  -0.1543129730130201, -0.988022017143284, -0.988022017143284, 
  0.1543129730130201, 0.988022017143284, -0.1543129730130201, 
  0.990272812363169, 0.1391393441638262, -0.990272812363169, 
  -0.1391393441638263, -0.1391393441638262, 0.990272812363169, 
  0.1391393441638263, -0.990272812363169, 0.601842247058580, 
  0.798614994634761, -0.601842247058580, -0.798614994634761, 
  -0.798614994634761, 0.601842247058580, 0.798614994634761, 
  -0.601842247058580, 0.861646461143081, 0.507508991052971, 
  -0.861646461143081, -0.507508991052971, -0.507508991052971, 
  0.861646461143081, 0.507508991052971, -0.861646461143081, 
  0.250413006572965, 0.968139104746362, -0.250413006572965, 
  -0.968139104746363, -0.968139104746362, 0.250413006572965, 
  0.968139104746362, -0.250413006572965, 0.944100258491273, 
  0.329658462528587, -0.944100258491273, -0.329658462528587, 
  -0.329658462528587, 0.944100258491273, 0.329658462528588, 
  -0.944100258491273, 0.434475960569656, 0.900683429228647, 
  -0.434475960569656, -0.900683429228647, -0.900683429228647, 
  0.434475960569656, 0.900683429228647, -0.434475960569656, 
  0.746080073510064, 0.665856233665510, -0.746080073510064, 
  -0.665856233665510, -0.665856233665509, 0.746080073510064, 
  0.665856233665510, -0.746080073510064, 0.05672682116690778, 
  0.998389737407340, -0.05672682116690766, -0.998389737407340, 
  -0.998389737407340, 0.05672682116690808, 0.998389737407340, 
  -0.05672682116690775, 0.995907229417412, 0.090381360877865, 
  -0.995907229417412, -0.0903813608778653, -0.0903813608778649, 
  0.995907229417412, 0.090381360877865, -0.995907229417412, 
  0.640303482184152, 0.768122028523365, -0.640303482184151, 
  -0.768122028523366, -0.768122028523365, 0.640303482184152, 
  0.768122028523365, -0.640303482184152, 0.885510856136200, 
  0.464618686306238, -0.885510856136200, -0.464618686306238, 
  -0.464618686306238, 0.885510856136200, 0.464618686306238, 
  -0.885510856136200, 0.297615707435086, 0.954685754941338, 
  -0.297615707435086, -0.954685754941338, -0.954685754941338, 
  0.297615707435086, 0.954685754941338, -0.297615707435086, 
  0.959138622461842, 0.282936570457055, -0.959138622461842, 
  -0.282936570457055, -0.282936570457055, 0.959138622461842, 
  0.282936570457055, -0.959138622461842, 0.478147056424843, 
  0.878279791656541, -0.478147056424843, -0.878279791656542, 
  -0.878279791656541, 0.478147056424843, 0.878279791656541, 
  -0.478147056424843, 0.777853404209453, 0.628445766601833, 
  -0.777853404209453, -0.628445766601833, -0.628445766601833, 
  0.777853404209453, 0.628445766601833, -0.777853404209453, 
  0.1056471537134107, 0.994403680057679, -0.1056471537134106, 
  -0.994403680057679, -0.994403680057679, 0.1056471537134108, 
  0.994403680057679, -0.1056471537134106, 0.982252741366289, 
  0.1875621285825296, -0.982252741366289, -0.1875621285825296, 
  -0.1875621285825296, 0.982252741366289, 0.1875621285825297, 
  -0.982252741366289, 0.561931121244689, 0.827184027273669, 
  -0.561931121244689, -0.827184027273669, -0.827184027273669, 
  0.561931121244690, 0.827184027273669, -0.561931121244689, 
  0.835706284353753, 0.549176662187720, -0.835706284353753, 
  -0.549176662187720, -0.549176662187720, 0.835706284353753, 
  0.549176662187720, -0.835706284353753, 0.2026070388444211, 
  0.979260122649082, -0.202607038844421, -0.979260122649082, 
  -0.979260122649082, 0.2026070388444213, 0.979260122649082, 
  -0.2026070388444211, 0.926787474304582, 0.375586178489217, 
  -0.926787474304582, -0.375586178489217, -0.375586178489217, 
  0.926787474304582, 0.375586178489217, -0.926787474304582, 
  0.389758174069856, 0.920917241529189, -0.389758174069856, 
  -0.920917241529190, -0.920917241529189, 0.389758174069856, 
  0.920917241529189, -0.389758174069856, 0.712509370564692, 
  0.701662594740168, -0.712509370564692, -0.701662594740169, 
  -0.701662594740168, 0.712509370564692, 0.701662594740169, 
  -0.712509370564692, 0.007669828739531078, 0.999970586430974, 
  -0.007669828739530954, -0.999970586430974, -0.999970586430974, 
  0.007669828739531138, 0.999970586430974, -0.007669828739531097, 
  0.999942349676024, 0.01073765916726449, -0.999942349676024, 
  -0.01073765916726441, -0.01073765916726445, 0.999942349676024, 
  0.01073765916726457, -0.999942349676024, 0.699473344640284, 
  0.714658687862769, -0.699473344640284, -0.714658687862769, 
  -0.714658687862769, 0.699473344640284, 0.714658687862769, 
  -0.699473344640284, 0.919717146291227, 0.392581674072951, 
  -0.919717146291227, -0.392581674072951, -0.392581674072951, 
  0.919717146291227, 0.392581674072952, -0.919717146291227, 
  0.372741067009516, 0.927935394822618, -0.372741067009516, 
  -0.927935394822618, -0.927935394822618, 0.372741067009516, 
  0.927935394822618, -0.372741067009516, 0.978633924429423, 
  0.2056104130530993, -0.978633924429423, -0.2056104130530994, 
  -0.2056104130530992, 0.978633924429423, 0.2056104130530993, 
  -0.978633924429423, 0.546610166910835, 0.837387201615662, 
  -0.546610166910835, -0.837387201615662, -0.837387201615662, 
  0.546610166910835, 0.837387201615662, -0.546610166910835, 
  0.825456154004378, 0.564466241520519, -0.825456154004377, 
  -0.564466241520519, -0.564466241520519, 0.825456154004378, 
  0.564466241520519, -0.825456154004377, 0.1845477369386196, 
  0.982823551198705, -0.1845477369386195, -0.982823551198705, 
  -0.982823551198705, 0.1845477369386197, 0.982823551198705, 
  -0.1845477369386196, 0.994074879304879, 0.1086974440131387, 
  -0.994074879304879, -0.1086974440131387, -0.1086974440131386, 
  0.994074879304879, 0.1086974440131387, -0.994074879304879, 
  0.626056388404344, 0.779777787923014, -0.626056388404344, 
  -0.779777787923014, -0.779777787923014, 0.626056388404344, 
  0.779777787923015, -0.626056388404344, 0.876808723809146, 
  0.480839330600334, -0.876808723809146, -0.480839330600334, 
  -0.480839330600334, 0.876808723809146, 0.480839330600334, 
  -0.876808723809146, 0.279992643080273, 0.960002145737666, 
  -0.279992643080273, -0.960002145737666, -0.960002145737666, 
  0.279992643080273, 0.960002145737666, -0.279992643080273, 
  0.953768189885990, 0.300543241417273, -0.953768189885990, 
  -0.300543241417274, -0.300543241417273, 0.953768189885990, 
  0.300543241417273, -0.953768189885990, 0.461899790702463, 
  0.886932118794342, -0.461899790702463, -0.886932118794342, 
  -0.886932118794342, 0.461899790702463, 0.886932118794342, 
  -0.461899790702463, 0.766153990196313, 0.642657033966227, 
  -0.766153990196313, -0.642657033966227, -0.642657033966227, 
  0.766153990196313, 0.642657033966227, -0.766153990196313, 
  0.0873255352061922, 0.996179828595697, -0.0873255352061921, 
  -0.996179828595697, -0.996179828595697, 0.0873255352061921, 
  0.996179828595697, -0.0873255352061921, 0.998211003360478, 
  0.05978957074663987, -0.998211003360478, -0.05978957074664006, 
  -0.05978957074663989, 0.998211003360478, 0.05978957074664001, 
  -0.998211003360478, 0.663564158612040, 0.748119380450403, 
  -0.663564158612040, -0.748119380450404, -0.748119380450403, 
  0.663564158612040, 0.748119380450404, -0.663564158612040, 
  0.899346236979341, 0.437237173661044, -0.899346236979341, 
  -0.437237173661044, -0.437237173661044, 0.899346236979342, 
  0.437237173661044, -0.899346236979341, 0.326760452320132, 
  0.945107193285261, -0.326760452320132, -0.945107193285261, 
  -0.945107193285261, 0.326760452320132, 0.945107193285261, 
  -0.326760452320132, 0.967366292222329, 0.253382036995570, 
  -0.967366292222329, -0.253382036995570, -0.253382036995570, 
  0.967366292222329, 0.253382036995570, -0.967366292222329, 
  0.504863108531268, 0.863199421712124, -0.504863108531268, 
  -0.863199421712124, -0.863199421712124, 0.504863108531268, 
  0.863199421712124, -0.504863108531268, 0.796764810208419, 
  0.604289530948156, -0.796764810208419, -0.604289530948156, 
  -0.604289530948156, 0.796764810208419, 0.604289530948156, 
  -0.796764810208419, 0.1361005751757062, 0.990695025442665, 
  -0.1361005751757061, -0.990695025442665, -0.990695025442665, 
  0.1361005751757065, 0.990695025442665, -0.1361005751757062, 
  0.987543941794359, 0.1573434556162383, -0.987543941794359, 
  -0.1573434556162385, -0.1573434556162382, 0.987543941794359, 
  0.1573434556162383, -0.987543941794359, 0.587040393520918, 
  0.809557642404051, -0.587040393520918, -0.809557642404051, 
  -0.809557642404051, 0.587040393520918, 0.809557642404051, 
  -0.587040393520918, 0.852158901623920, 0.523283103475656, 
  -0.852158901623920, -0.523283103475657, -0.523283103475656, 
  0.852158901623920, 0.523283103475656, -0.852158901623920, 
  0.2325503070387753, 0.972584368934732, -0.2325503070387752, 
  -0.972584368934732, -0.972584368934732, 0.2325503070387751, 
  0.972584368934732, -0.2325503070387752, 0.937872376439990, 
  0.346980410845924, -0.937872376439990, -0.346980410845924, 
  -0.346980410845924, 0.937872376439990, 0.346980410845924, 
  -0.937872376439990, 0.417823715820212, 0.908528118716306, 
  -0.417823715820212, -0.908528118716306, -0.908528118716306, 
  0.417823715820212, 0.908528118716306, -0.417823715820212, 
  0.733697438114660, 0.679476319899365, -0.733697438114660, 
  -0.679476319899365, -0.679476319899365, 0.733697438114660, 
  0.679476319899365, -0.733697438114660, 0.03834012037355279, 
  0.999264747286594, -0.03834012037355267, -0.999264747286595, 
  -0.999264747286594, 0.03834012037355286, 0.999264747286594, 
  -0.0383401203735527, 0.999377670388003, 0.03527423889821395, 
  -0.999377670388003, -0.03527423889821423, -0.03527423889821382, 
  0.999377670388003, 0.03527423889821395, -0.999377670388003, 
  0.681724074171650, 0.731609381223893, -0.681724074171650, 
  -0.731609381223893, -0.731609381223893, 0.681724074171650, 
  0.731609381223893, -0.681724074171650, 0.909805708104652, 
  0.415034424476082, -0.909805708104652, -0.415034424476082, 
  -0.415034424476082, 0.909805708104652, 0.415034424476082, 
  -0.909805708104652, 0.349856129790135, 0.936803441735922, 
  -0.349856129790135, -0.936803441735922, -0.936803441735922, 
  0.349856129790135, 0.936803441735922, -0.349856129790135, 
  0.973293246054698, 0.2295653658205189, -0.973293246054698, 
  -0.2295653658205189, -0.2295653658205187, 0.973293246054698, 
  0.2295653658205189, -0.973293246054698, 0.525895027471085, 
  0.850549481265603, -0.525895027471085, -0.850549481265603, 
  -0.850549481265603, 0.525895027471085, 0.850549481265603, 
  -0.525895027471085, 0.811354847017064, 0.584553942953015, 
  -0.811354847017064, -0.584553942953015, -0.584553942953015, 
  0.811354847017064, 0.584553942953015, -0.811354847017064, 
  0.1603724572429284, 0.987056571305751, -0.1603724572429283, 
  -0.987056571305751, -0.987056571305751, 0.1603724572429284, 
  0.987056571305751, -0.1603724572429283, 0.991107913723277, 
  0.1330605251571391, -0.991107913723277, -0.133060525157139, 
  -0.1330605251571391, 0.991107913723277, 0.1330605251571391, 
  -0.991107913723277, 0.606731127034525, 0.794907126328237, 
  -0.606731127034525, -0.794907126328237, -0.794907126328237, 
  0.606731127034525, 0.794907126328237, -0.606731127034524, 
  0.864744257519462, 0.502212474045711, -0.864744257519462, 
  -0.502212474045711, -0.502212474045711, 0.864744257519463, 
  0.502212474045711, -0.864744257519462, 0.256348682489943, 
  0.966584374478333, -0.256348682489943, -0.966584374478333, 
  -0.966584374478333, 0.256348682489943, 0.966584374478333, 
  -0.256348682489943, 0.946105232370403, 0.323859366517853, 
  -0.946105232370403, -0.323859366517853, -0.323859366517853, 
  0.946105232370403, 0.323859366517853, -0.946105232370403, 
  0.439994271309633, 0.898000579740740, -0.439994271309633, 
  -0.898000579740740, -0.898000579740740, 0.439994271309633, 
  0.898000579740740, -0.439994271309633, 0.750151645806215, 
  0.661265837839992, -0.750151645806215, -0.661265837839992, 
  -0.661265837839992, 0.750151645806215, 0.661265837839992, 
  -0.750151645806215, 0.06285175756416141, 0.998022873771486, 
  -0.06285175756416131, -0.998022873771486, -0.998022873771486, 
  0.06285175756416149, 0.998022873771486, -0.06285175756416141, 
  0.996443051350043, 0.0842688875933241, -0.996443051350043, 
  -0.0842688875933242, -0.084268887593324, 0.996443051350043, 
  0.0842688875933241, -0.996443051350043, 0.645004536815544, 
  0.764178740536117, -0.645004536815544, -0.764178740536117, 
  -0.764178740536117, 0.645004536815544, 0.764178740536117, 
  -0.645004536815544, 0.888345033309596, 0.459176547521944, 
  -0.888345033309596, -0.459176547521944, -0.459176547521944, 
  0.888345033309596, 0.459176547521944, -0.888345033309596, 
  0.303467946572011, 0.952841647601199, -0.303467946572011, 
  -0.952841647601199, -0.952841647601199, 0.303467946572011, 
  0.952841647601199, -0.303467946572011, 0.960856633107680, 
  0.277046080306100, -0.960856633107680, -0.277046080306100, 
  -0.277046080306100, 0.960856633107680, 0.277046080306100, 
  -0.960856633107680, 0.483527078932919, 0.875329403104111, 
  -0.483527078932918, -0.875329403104111, -0.875329403104111, 
  0.483527078932919, 0.875329403104111, -0.483527078932919, 
  0.781694832071059, 0.623661117525695, -0.781694832071059, 
  -0.623661117525695, -0.623661117525695, 0.781694832071059, 
  0.623661117525695, -0.781694832071059, 0.1117467112111266, 
  0.993736721940725, -0.1117467112111265, -0.993736721940725, 
  -0.993736721940725, 0.1117467112111265, 0.993736721940725, 
  -0.1117467112111266, 0.983385110321551, 0.181531608261125, 
  -0.983385110321551, -0.1815316082611252, -0.181531608261125, 
  0.983385110321551, 0.1815316082611251, -0.983385110321551, 
  0.566996048825109, 0.823720511227391, -0.566996048825108, 
  -0.823720511227391, -0.823720511227391, 0.566996048825109, 
  0.823720511227391, -0.566996048825109, 0.839060237070313, 
  0.544038526730884, -0.839060237070313, -0.544038526730884, 
  -0.544038526730884, 0.839060237070313, 0.544038526730884, 
  -0.839060237070313, 0.2086118519782634, 0.977998514934557, 
  -0.2086118519782633, -0.977998514934557, -0.977998514934557, 
  0.2086118519782635, 0.977998514934557, -0.2086118519782635, 
  0.929074581259316, 0.369892447148934, -0.929074581259316, 
  -0.369892447148934, -0.369892447148934, 0.929074581259316, 
  0.369892447148934, -0.929074581259316, 0.395401478947816, 
  0.918508394325212, -0.395401478947816, -0.918508394325212, 
  -0.918508394325212, 0.395401478947817, 0.918508394325212, 
  -0.395401478947816, 0.716801278521100, 0.697277510830887, 
  -0.716801278521100, -0.697277510830887, -0.697277510830886, 
  0.716801278521100, 0.697277510830887, -0.716801278521100, 
  0.01380538852806035, 0.999904701082853, -0.01380538852806023, 
  -0.999904701082853, -0.999904701082853, 0.01380538852806063, 
  0.999904701082853, -0.01380538852806039, 0.999735288260562, 
  0.02300768146883937, -0.999735288260562, -0.02300768146883969, 
  -0.02300768146883929, 0.999735288260562, 0.02300768146883941, 
  -0.999735288260562, 0.690650714134535, 0.723188489306527, 
  -0.690650714134534, -0.723188489306528, -0.723188489306527, 
  0.690650714134534, 0.723188489306527, -0.690650714134535, 
  0.914830312237946, 0.403838457567654, -0.914830312237946, 
  -0.403838457567654, -0.403838457567654, 0.914830312237946, 
  0.403838457567654, -0.914830312237946, 0.361325805568454, 
  0.932439629268462, -0.361325805568454, -0.932439629268462, 
  -0.932439629268462, 0.361325805568454, 0.932439629268462, 
  -0.361325805568454, 0.976037079039039, 0.2176042746384836, 
  -0.976037079039039, -0.2176042746384837, -0.2176042746384835, 
  0.976037079039039, 0.2176042746384837, -0.976037079039039, 
  0.536292979065963, 0.844031895490066, -0.536292979065963, 
  -0.844031895490067, -0.844031895490066, 0.536292979065963, 
  0.844031895490066, -0.536292979065963, 0.818467129580299, 
  0.574553355047716, -0.818467129580299, -0.574553355047716, 
  -0.574553355047716, 0.818467129580299, 0.574553355047716, 
  -0.818467129580299, 0.172473083996796, 0.985014231012240, 
  -0.1724730839967959, -0.985014231012240, -0.985014231012240, 
  0.1724730839967961, 0.985014231012240, -0.1724730839967959, 
  0.992666142448948, 0.1208880872357771, -0.992666142448948, 
  -0.1208880872357771, -0.1208880872357771, 0.992666142448948, 
  0.1208880872357772, -0.992666142448948, 0.616440174530854, 
  0.787401747029031, -0.616440174530854, -0.787401747029031, 
  -0.787401747029031, 0.616440174530854, 0.787401747029031, 
  -0.616440174530854, 0.870842063470079, 0.491562916106550, 
  -0.870842063470079, -0.491562916106550, -0.491562916106550, 
  0.870842063470079, 0.491562916106550, -0.870842063470079, 
  0.268190857063403, 0.963365799780954, -0.268190857063403, 
  -0.963365799780954, -0.963365799780954, 0.268190857063403, 
  0.963365799780954, -0.268190857063403, 0.950008245001843, 
  0.312224813921825, -0.950008245001843, -0.312224813921825, 
  -0.312224813921825, 0.950008245001843, 0.312224813921825, 
  -0.950008245001843, 0.450980989045104, 0.892533555402765, 
  -0.450980989045104, -0.892533555402765, -0.892533555402765, 
  0.450980989045104, 0.892533555402765, -0.450980989045104, 
  0.758209909813015, 0.652010531096960, -0.758209909813015, 
  -0.652010531096960, -0.652010531096960, 0.758209909813015, 
  0.652010531096960, -0.758209909813015, 0.07509430084792128, 
  0.997176436735326, -0.07509430084792117, -0.997176436735326, 
  -0.997176436735326, 0.07509430084792135, 0.997176436735326, 
  -0.07509430084792131, 0.997402129901275, 0.07203465324688933, 
  -0.997402129901275, -0.07203465324688949, -0.07203465324688931, 
  0.997402129901275, 0.07203465324688941, -0.997402129901275, 
  0.654333617831801, 0.756206001414395, -0.654333617831800, 
  -0.756206001414395, -0.756206001414394, 0.654333617831801, 
  0.756206001414395, -0.654333617831800, 0.893912945145203, 
  0.448240612285220, -0.893912945145203, -0.448240612285220, 
  -0.448240612285220, 0.893912945145203, 0.448240612285220, 
  -0.893912945145203, 0.315137928752522, 0.949045881852701, 
  -0.315137928752522, -0.949045881852701, -0.949045881852701, 
  0.315137928752522, 0.949045881852701, -0.315137928752522, 
  0.964184063951746, 0.265234030285512, -0.964184063951746, 
  -0.265234030285512, -0.265234030285512, 0.964184063951746, 
  0.265234030285512, -0.964184063951746, 0.494232308515960, 
  0.869329871348607, -0.494232308515960, -0.869329871348607, 
  -0.869329871348607, 0.494232308515960, 0.869329871348607, 
  -0.494232308515960, 0.789289253168886, 0.614021558931038, 
  -0.789289253168886, -0.614021558931038, -0.614021558931038, 
  0.789289253168886, 0.614021558931038, -0.789289253168886, 
  0.1239329751185122, 0.992290591348257, -0.1239329751185121, 
  -0.992290591348257, -0.992290591348257, 0.1239329751185125, 
  0.992290591348257, -0.1239329751185122, 0.985538735312176, 
  0.169450291233968, -0.985538735312176, -0.1694502912339682, 
  -0.1694502912339678, 0.985538735312176, 0.1694502912339679, 
  -0.985538735312176, 0.577061672855680, 0.816700572866828, 
  -0.577061672855679, -0.816700572866828, -0.816700572866828, 
  0.577061672855679, 0.816700572866828, -0.577061672855679, 
  0.845673246987299, 0.533701001807153, -0.845673246987299, 
  -0.533701001807153, -0.533701001807153, 0.845673246987299, 
  0.533701001807153, -0.845673246987299, 0.2205976901088737, 
  0.975364885116657, -0.2205976901088735, -0.975364885116657, 
  -0.975364885116657, 0.2205976901088735, 0.975364885116657, 
  -0.2205976901088735, 0.933543772978836, 0.358463420633737, 
  -0.933543772978836, -0.358463420633737, -0.358463420633736, 
  0.933543772978836, 0.358463420633737, -0.933543772978836, 
  0.406643216870369, 0.913587047945251, -0.406643216870369, 
  -0.913587047945251, -0.913587047945251, 0.406643216870369, 
  0.913587047945251, -0.406643216870369, 0.725303972373061, 
  0.688428752784090, -0.725303972373061, -0.688428752784090, 
  -0.688428752784090, 0.725303972373061, 0.688428752784091, 
  -0.725303972373061, 0.02607471782910404, 0.999659996743959, 
  -0.02607471782910391, -0.999659996743959, -0.999659996743959, 
  0.0260747178291041, 0.999659996743959, -0.0260747178291039, 
  0.998869549914284, 0.04753548415695931, -0.998869549914284, 
  -0.04753548415695955, -0.04753548415695914, 0.998869549914284, 
  0.04753548415695926, -0.998869549914284, 0.672694769070773, 
  0.739920095459516, -0.672694769070773, -0.739920095459516, 
  -0.739920095459516, 0.672694769070773, 0.739920095459516, 
  -0.672694769070773, 0.904644090578246, 0.426167888726800, 
  -0.904644090578246, -0.426167888726800, -0.426167888726800, 
  0.904644090578246, 0.426167888726800, -0.904644090578246, 
  0.338333766965541, 0.941026175050889, -0.338333766965541, 
  -0.941026175050889, -0.941026175050889, 0.338333766965541, 
  0.941026175050889, -0.338333766965541, 0.970402838687556, 
  0.2414918853028693, -0.970402838687556, -0.2414918853028693, 
  -0.2414918853028692, 0.970402838687556, 0.2414918853028693, 
  -0.970402838687556, 0.515417878019463, 0.856938977417829, 
  -0.515417878019463, -0.856938977417829, -0.856938977417829, 
  0.515417878019463, 0.856938977417829, -0.515417878019463, 
  0.804120377398266, 0.594466499184664, -0.804120377398266, 
  -0.594466499184664, -0.594466499184664, 0.804120377398266, 
  0.594466499184665, -0.804120377398266, 0.1482476789868962, 
  0.988950264510303, -0.1482476789868961, -0.988950264510303, 
  -0.988950264510303, 0.1482476789868963, 0.988950264510303, 
  -0.148247678986896, 0.989400427791380, 0.1452129246528475, 
  -0.989400427791380, -0.1452129246528473, -0.1452129246528474, 
  0.989400427791380, 0.1452129246528475, -0.989400427791380, 
  0.596930708062197, 0.802292795538116, -0.596930708062197, 
  -0.802292795538116, -0.802292795538115, 0.596930708062197, 
  0.802292795538116, -0.596930708062196, 0.858516224264443, 
  0.512786400633563, -0.858516224264443, -0.512786400633563, 
  -0.512786400633563, 0.858516224264443, 0.512786400633563, 
  -0.858516224264443, 0.2444679027478242, 0.969657385124292, 
  -0.2444679027478241, -0.969657385124292, -0.969657385124292, 
  0.2444679027478245, 0.969657385124292, -0.2444679027478242, 
  0.942059739771017, 0.335445147084532, -0.942059739771017, 
  -0.335445147084532, -0.335445147084532, 0.942059739771017, 
  0.335445147084532, -0.942059739771017, 0.428941292055330, 
  0.903332368494512, -0.428941292055329, -0.903332368494512, 
  -0.903332368494512, 0.428941292055330, 0.903332368494512, 
  -0.428941292055329, 0.741980411720831, 0.670421560380173, 
  -0.741980411720831, -0.670421560380173, -0.670421560380173, 
  0.741980411720831, 0.670421560380173, -0.741980411720831, 
  0.05059974903689933, 0.998719012233873, -0.05059974903689922, 
  -0.998719012233873, -0.998719012233873, 0.05059974903689941, 
  0.998719012233873, -0.05059974903689928, 0.995333912140482, 
  0.0964904313552526, -0.995333912140482, -0.0964904313552527, 
  -0.0964904313552525, 0.995333912140482, 0.0964904313552526, 
  -0.995333912140482, 0.635578320488556, 0.772036397150384, 
  -0.635578320488556, -0.772036397150385, -0.772036397150384, 
  0.635578320488556, 0.772036397150385, -0.635578320488556, 
  0.882643339979563, 0.470043332459596, -0.882643339979563, 
  -0.470043332459596, -0.470043332459596, 0.882643339979563, 
  0.470043332459596, -0.882643339979563, 0.291752263234989, 
  0.956493918902395, -0.291752263234989, -0.956493918902395, 
  -0.956493918902395, 0.291752263234989, 0.956493918902395, 
  -0.291752263234989, 0.957384500788976, 0.288816408206049, 
  -0.957384500788976, -0.288816408206050, -0.288816408206049, 
  0.957384500788976, 0.288816408206049, -0.957384500788976, 
  0.472749031950343, 0.881197113471222, -0.472749031950343, 
  -0.881197113471222, -0.881197113471222, 0.472749031950343, 
  0.881197113471222, -0.472749031950343, 0.773982690606823, 
  0.633206755050057, -0.773982690606823, -0.633206755050057, 
  -0.633206755050057, 0.773982690606823, 0.633206755050057, 
  -0.773982690606823, 0.0995436186600694, 0.995033199438119, 
  -0.0995436186600693, -0.995033199438119, -0.995033199438119, 
  0.0995436186600693, 0.995033199438119, -0.0995436186600693, 
  0.981083391150487, 0.1935855872958036, -0.981083391150487, 
  -0.1935855872958038, -0.1935855872958036, 0.981083391150487, 
  0.1935855872958037, -0.981083391150487, 0.556845037275160, 
  0.830616400308846, -0.556845037275160, -0.830616400308846, 
  -0.830616400308846, 0.556845037275160, 0.830616400308846, 
  -0.556845037275160, 0.832320867767930, 0.554294121453620, 
  -0.832320867767929, -0.554294121453620, -0.554294121453620, 
  0.832320867767930, 0.554294121453620, -0.832320867767930, 
  0.1965945976700802, 0.980484861773469, -0.1965945976700801, 
  -0.980484861773469, -0.980484861773469, 0.1965945976700803, 
  0.980484861773469, -0.1965945976700802, 0.924465474325263, 
  0.381265769222162, -0.924465474325263, -0.381265769222162, 
  -0.381265769222162, 0.924465474325263, 0.381265769222162, 
  -0.924465474325263, 0.384100195016935, 0.923291416719528, 
  -0.384100195016935, -0.923291416719528, -0.923291416719528, 
  0.384100195016935, 0.923291416719528, -0.384100195016935, 
  0.708190637033195, 0.706021261449340, -0.708190637033195, 
  -0.706021261449340, -0.706021261449340, 0.708190637033196, 
  0.706021261449340, -0.708190637033195, 0.001533980186284766, 
  0.999998823451702, -0.001533980186284644, -0.999998823451702, 
  -0.999998823451702, 0.001533980186285049, 0.999998823451702, 
  -0.001533980186284765};
#endif // !USE_CPP