#ifndef IMAGE_INCLUDED
#define IMAGE_INCLUDED

/** This structure represents a 4-channel, 32-bit, RGBA pixel. */
class Pixel32 {
public:
	/** The red, green, blue, and alpha components of the pixel */
    unsigned char r, g, b, a;

	/** This constructor instantiates a pixel with 0 for the red, green and blue components, and 255 for the alpha.*/
	Pixel32(void);
};


/** This class represents an RGBA image with 8 bits per channel. */
class Image32{
	int w,h;
	Pixel32* pixels;
public:
	Image32(void);
	~Image32(void);

	/** This method sets the dimension of the image. */
	int setSize(const int& width,const int& height);

	/** This overloaded operator copies the input image into the current image. */
	Image32& operator = (const Image32& img);

	/** This method returns the width of the image */
	int width(void) const;
	/** This method returns the height of the image */
	int height(void) const;

	/** This method returns a reference to the indexed pixel.*/
	Pixel32& operator() (const int& x,const int& y);

	/** This method returns a reference to the indexed pixel.*/
	const Pixel32& operator() (const int& x,const int& y) const;

	/** This method returns a reference to the indexed pixel.*/
	Pixel32& pixel(const int& x,const int& y);

	/** This method returns a reference to the indexed pixel.*/
	const Pixel32& pixel(const int& x,const int& y) const;
};

/** This function reads in an image from a .bmp format */
extern int BMPReadImage(char* fileName,Image32& img);

/** This function reads in an image from a .jpeg format */
extern int JPEGReadImage(char* fileName,Image32& img);

/** This function writes out an image in .bmp format */
extern int BMPWriteImage(Image32& img,char* fileName);

/** This function writes out an image in .jpeg format */
extern int JPEGWriteImage(Image32& img,char* fileName,int quality=100);

#endif // IMAGE_INCLUDED

