/*
Copyright (c) 2009, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef TRIANGLE_INTEGRALS_INCLUDED
#define TRIANGLE_INTEGRALS_INCLUDED
#include "Geometry.h"

// Cubature weights taken from "Asymmetric cubature formulas for polynomial integration in the triangle and square", Taylor 2007
// Used to compute the integrals of (up to) 12-th degree polynomials over a unit right triangle.
template< class VectorType >
class TriangleIntegrator10
{
public:
	const static int SampleNum = 24;
private:
	const static double _SamplePositionsAndWeights[];
	double _area;
	Point3D< double > _samplePositions[ SampleNum ];
public:
	VectorType values[ SampleNum ];
	double weights[ SampleNum ];

	TriangleIntegrator10( void );
	TriangleIntegrator10( const Point3D< double >& p1 , const Point3D< double >& p2 , const Point3D< double >& p3 );
	TriangleIntegrator10( const Point3D< float >&  p1 , const Point3D< float >&  p2 , const Point3D< float >&  p3 );
	VectorType integrate( void ) const;
	static VectorType Integrate( const VectorType* values );
	inline const Point3D< double >& operator [] ( int idx ) const;
	inline double area( void ) const;
};

template< class VectorType >
class TriangleIntegrator11
{
public:
	const static int SampleNum = 27;
private:
	const static double _SamplePositionsAndWeights[];
	double _area;
	Point3D< double > _samplePositions[ SampleNum ];
public:
	VectorType values[ SampleNum ];
	double weights[ SampleNum ];

	TriangleIntegrator11( void );
	TriangleIntegrator11( const Point3D< double >& p1 , const Point3D< double >& p2 , const Point3D< double >& p3 );
	TriangleIntegrator11( const Point3D< float >&  p1 , const Point3D< float >&  p2 , const Point3D< float >&  p3 );
	VectorType integrate( void ) const;
	static VectorType Integrate( const VectorType* values );
	inline const Point3D< double >& operator [] ( int idx ) const;
	inline double area( void ) const;
};

template< class VectorType >
class TriangleIntegrator12
{
public:
	const static int SampleNum = 32;
private:
	const static double _SamplePositionsAndWeights[];
	double _area;
	Point3D< double > _samplePositions[ SampleNum ];
public:
	VectorType values[ SampleNum ];
	double weights[ SampleNum ];

	TriangleIntegrator12( void );
	TriangleIntegrator12( const Point3D< double >& p1 , const Point3D< double >& p2 , const Point3D< double >& p3 );
	TriangleIntegrator12( const Point3D< float >&  p1 , const Point3D< float >&  p2 , const Point3D< float >&  p3 );
	VectorType integrate( void ) const;
	static VectorType Integrate( const VectorType* values );
	inline const Point3D< double >& operator [] ( int idx ) const;
	inline double area( void ) const;
};
#include "TriangleIntegrals.inl"

#endif // TRIANGLE_INTEGRALS_INCLUDED
